/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextMenuSource {
    private Map<String, String> names;

    public abstract String[] getKeys();

    public String getName(String actionKey) {
        return this.getNames().get(actionKey);
    }

    public abstract void updateActionEnabled(JComponent var1, ActionMap var2);

    public ActionMap createActionMap(JComponent component) {
        ActionMap map = new ActionMap();
        String[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Action action;
            if (keys[i] == null || (action = this.createDelegateAction(component, keys[i])) == null) continue;
            map.put(keys[i], action);
        }
        return map;
    }

    protected Map<String, String> getNames() {
        if (this.names == null) {
            this.names = new HashMap<String, String>();
            this.initNames(this.names);
        }
        return this.names;
    }

    protected String getValue(String key, String defaultValue) {
        String value = UIManager.getString(this.getResourcePrefix() + key);
        return value != null ? value : defaultValue;
    }

    protected abstract void initNames(Map<String, String> var1);

    protected abstract String getResourcePrefix();

    protected Action createDelegateAction(JComponent component, String actionKey) {
        Action action = component.getActionMap().get(actionKey);
        if (action != null) {
            return new DelegateAction(this.getName(actionKey), action, component);
        }
        return null;
    }

    public static class DelegateAction
    extends AbstractAction {
        private Action delegatee;
        private JComponent target;

        public DelegateAction(String name, Action delegatee, JComponent target) {
            super(name);
            this.delegatee = delegatee;
            this.target = target;
        }

        public void actionPerformed(ActionEvent e) {
            this.delegatee.actionPerformed(this.createActionEvent(e));
        }

        private ActionEvent createActionEvent(ActionEvent e) {
            if (this.target != null) {
                return new ActionEvent(this.target, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
            }
            return e;
        }
    }
}

