/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.nodes;

import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.nodes.TableCellNode;
import com.jaspersoft.ireport.components.table.nodes.TableColumnGroupNode;
import com.jaspersoft.ireport.components.table.nodes.TableNullCellNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public abstract class AbstractTableChildren
extends Index.KeysChildren
implements PropertyChangeListener {
    private JasperDesign jd = null;
    private Lookup doLkp = null;
    private JRDesignComponentElement component = null;
    private JRDesignGroup group = null;
    private byte section = 0;
    private TableMatrix matrix = null;

    public AbstractTableChildren(JasperDesign jd, JRDesignComponentElement componentElement, byte section, JRDesignGroup group, Lookup doLkp) {
        super(new ArrayList());
        this.jd = jd;
        this.doLkp = doLkp;
        this.section = section;
        this.group = group;
        this.component = componentElement;
    }

    protected void addNotify() {
        super.addNotify();
        this.recalculateKeys();
    }

    public abstract void recalculateKeysImpl();

    public void recalculateKeys() {
        this.setMatrix(new TableMatrix(this.jd, (StandardTable)this.component.getComponent()));
        this.recalculateKeysImpl();
        this.update();
    }

    protected String getCellPropertyName() {
        switch (this.getSection()) {
            case 0: {
                return "tableHeader";
            }
            case 1: {
                return "columnHeader";
            }
            case 2: {
                return "groupHeaders";
            }
            case 4: {
                return "groupFooters";
            }
            case 5: {
                return "columnFooter";
            }
            case 6: {
                return "tableFooter";
            }
            case 3: {
                return "detail";
            }
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(this.getCellPropertyName())) {
            this.refreshKey(evt.getSource());
        } else if (evt.getPropertyName().equals("columns") || evt.getPropertyName().equals("datasetRun")) {
            this.recalculateKeys();
        }
        this.updateNodeNames(this.getNodes());
    }

    private void updateNodeNames(Node[] nodesToUpdated) {
        if (nodesToUpdated == null || nodesToUpdated.length == 0) {
            return;
        }
        for (Node node : nodesToUpdated) {
            node.setDisplayName(null);
            this.updateNodeNames(node.getChildren().getNodes());
        }
    }

    protected Node[] createNodes(Object key) {
        ArrayList<Object> theNodes = new ArrayList<Object>();
        BaseColumn column = (BaseColumn)key;
        theNodes.add(this.createCellNode(column));
        if (key instanceof StandardColumnGroup) {
            TableColumnGroupNode node = new TableColumnGroupNode(this.jd, this.component, (StandardColumnGroup)key, this.getMatrix().getColumnParent(column), this.getSection(), this.group, this.doLkp);
            String name = "Column Group ";
            if (this.getMatrix() != null) {
                name = name + (this.getMatrix().getColumnIndex(column) + 1);
            }
            node.setDisplayName(name);
            theNodes.add(node);
        }
        return theNodes.toArray(new Node[theNodes.size()]);
    }

    public Node createCellNode(BaseColumn column) {
        Cell cell = null;
        if (column instanceof StandardColumn && this.getSection() == 3 && ((StandardColumn)column).getDetailCell() != null) {
            TableCellNode node = new TableCellNode(this.jd, this.component, column, (DesignCell)((StandardColumn)column).getDetailCell(), 3, null, this.doLkp);
            return node;
        }
        switch (this.getSection()) {
            case 0: {
                cell = column.getTableHeader();
                break;
            }
            case 1: {
                cell = column.getColumnHeader();
                break;
            }
            case 2: {
                cell = column.getGroupHeader(this.group.getName());
                break;
            }
            case 4: {
                cell = column.getGroupFooter(this.group.getName());
                break;
            }
            case 5: {
                cell = column.getColumnFooter();
                break;
            }
            case 6: {
                cell = column.getTableFooter();
            }
        }
        Object node = null;
        node = cell == null ? new TableNullCellNode(this.jd, this.component, column, this.getSection(), (JRGroup)this.group, this.doLkp) : new TableCellNode(this.jd, this.component, column, (DesignCell)cell, this.getSection(), (JRGroup)this.group, this.doLkp);
        return node;
    }

    public TableMatrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(TableMatrix matrix) {
        this.matrix = matrix;
    }

    public byte getSection() {
        return this.section;
    }
}

