/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.export.draw.FrameDrawer;
import net.sf.jasperreports.engine.export.legacy.BorderOffset;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRProperties;

public class JRGraphics2DExporter
extends JRAbstractExporter {
    private static final float DEFAULT_ZOOM = 1.0f;
    public static final String MINIMIZE_PRINTER_JOB_SIZE = "net.sf.jasperreports.export.graphics2d.min.job.size";
    private static final String GRAPHICS2D_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.graphics2d.";
    protected Graphics2D grx;
    protected JRExportProgressMonitor progressMonitor;
    protected float zoom = 1.0f;
    protected TextRenderer textRenderer;
    protected FrameDrawer frameDrawer;

    public JRGraphics2DExporter() throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset(false);
        try {
            this.setExportContext();
            this.setInput();
            if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                this.filter = this.createFilter(GRAPHICS2D_EXPORTER_PROPERTIES_PREFIX);
            }
            this.setPageRange();
            this.setTextRenderer();
            this.grx = (Graphics2D)this.parameters.get(JRGraphics2DExporterParameter.GRAPHICS_2D);
            if (this.grx == null) {
                throw new JRException("No output specified for the exporter. java.awt.Graphics2D object expected.");
            }
            BorderOffset.setLegacy(JRProperties.getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.export.legacy.border.offset", false));
            this.setDrawers();
            Float zoomRatio = (Float)this.parameters.get(JRGraphics2DExporterParameter.ZOOM_RATIO);
            if (zoomRatio != null) {
                this.zoom = zoomRatio.floatValue();
                if (this.zoom <= 0.0f) {
                    throw new JRException("Invalid zoom ratio : " + this.zoom);
                }
            } else {
                this.zoom = 1.0f;
            }
            this.exportReportToGraphics2D();
        }
        finally {
            this.resetExportContext();
        }
    }

    protected void setTextRenderer() {
        boolean isMinimizePrinterJobSize = true;
        Boolean isMinimizePrinterJobSizeParam = (Boolean)this.parameters.get(JRGraphics2DExporterParameter.MINIMIZE_PRINTER_JOB_SIZE);
        isMinimizePrinterJobSize = isMinimizePrinterJobSizeParam == null ? JRProperties.getBooleanProperty(MINIMIZE_PRINTER_JOB_SIZE) : isMinimizePrinterJobSizeParam;
        this.textRenderer = new TextRenderer(isMinimizePrinterJobSize, JRProperties.getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.awt.ignore.missing.font", false));
    }

    protected void setDrawers() {
        this.frameDrawer = new FrameDrawer(this.filter, this.textRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReportToGraphics2D() throws JRException {
        this.grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.grx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.grx.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform atrans = new AffineTransform();
        atrans.translate(this.globalOffsetX, this.globalOffsetY);
        atrans.scale(this.zoom, this.zoom);
        this.grx.transform(atrans);
        List pages = this.jasperPrint.getPages();
        if (pages != null) {
            Shape oldClipShape = this.grx.getClip();
            this.grx.clip(new Rectangle(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight()));
            try {
                JRPrintPage page = (JRPrintPage)pages.get(this.startPageIndex);
                this.exportPage(page);
            }
            finally {
                this.grx.setClip(oldClipShape);
            }
        }
    }

    protected void exportPage(JRPrintPage page) throws JRException {
        this.grx.setColor(Color.white);
        this.grx.fillRect(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
        this.grx.setColor(Color.black);
        this.grx.setStroke(new BasicStroke(1.0f));
        this.frameDrawer.draw(this.grx, page.getElements(), this.getOffsetX(), this.getOffsetY());
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected String getExporterKey() {
        return null;
    }
}

