/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.base;

import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.LockModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.VersionLockingPolicy;
import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.essentials.internal.ejb.cmp3.base.CMP3Policy;
import oracle.toplink.essentials.internal.ejb.cmp3.base.RepeatableWriteUnitOfWork;
import oracle.toplink.essentials.internal.ejb.cmp3.transaction.base.TransactionWrapperImpl;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ReadAllQuery;
import oracle.toplink.essentials.queryframework.ReadObjectQuery;
import oracle.toplink.essentials.sessions.Session;
import oracle.toplink.essentials.sessions.UnitOfWork;
import oracle.toplink.essentials.threetier.ServerSession;
import oracle.toplink.essentials.tools.sessionmanagement.SessionManager;

public abstract class EntityManagerImpl {
    protected TransactionWrapperImpl transaction = null;
    protected boolean isOpen = true;
    protected RepeatableWriteUnitOfWork extendedPersistenceContext;
    protected ServerSession serverSession;
    protected boolean extended;
    protected boolean propagatePersistenceContext;

    protected abstract void setJTATransactionWrapper();

    protected abstract void setEntityTransactionWrapper();

    public abstract boolean isFlushModeAUTO();

    public EntityManagerImpl(String sessionName, boolean propagatePersistenceContext, boolean extended) {
        this((ServerSession)SessionManager.getManager().getSession(sessionName), null, propagatePersistenceContext, extended);
    }

    public EntityManagerImpl(ServerSession serverSession, boolean propagatePersistenceContext, boolean extended) {
        this(serverSession, null, propagatePersistenceContext, extended);
    }

    public EntityManagerImpl(ServerSession serverSession, Map properties, boolean propagatePersistenceContext, boolean extended) {
        this.serverSession = serverSession;
        this.detectTransactionWrapper();
        this.extended = true;
        this.propagatePersistenceContext = false;
    }

    public void clear() {
        if (this.isExtended()) {
            if (this.extendedPersistenceContext != null) {
                if (this.checkForTransaction(false) != null) {
                    this.extendedPersistenceContext.clear();
                } else {
                    this.extendedPersistenceContext = null;
                }
            }
        } else {
            this.transaction.clear();
        }
    }

    public void persist(Object entity) {
        this.verifyOpen();
        try {
            this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended())).registerNewObjectForPersist(entity, new IdentityHashtable());
        }
        catch (RuntimeException e) {
            this.transaction.setRollbackOnlyInternal();
            if (ValidationException.class.isAssignableFrom(e.getClass())) {
                throw new EntityExistsException(e.getLocalizedMessage(), e);
            }
            throw e;
        }
    }

    protected Object mergeInternal(Object entity) {
        this.verifyOpen();
        try {
            return this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended())).mergeCloneWithReferences(entity, 4);
        }
        catch (oracle.toplink.essentials.exceptions.OptimisticLockException ole) {
            throw new OptimisticLockException(ole);
        }
    }

    public void remove(Object entity) {
        this.verifyOpen();
        try {
            this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended())).performRemove(entity, new IdentityHashtable());
        }
        catch (RuntimeException e) {
            this.transaction.setRollbackOnlyInternal();
            throw e;
        }
    }

    public Object find(String entityName, Object primaryKey) {
        this.verifyOpen();
        try {
            Session session = this.getActiveSession();
            ClassDescriptor descriptor = session.getDescriptorForAlias(entityName);
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_entitybean_name", new Object[]{entityName}));
            }
            if (((CMP3Policy)descriptor.getCMPPolicy()).getPKClass() != null && !((CMP3Policy)descriptor.getCMPPolicy()).getPKClass().isAssignableFrom(primaryKey.getClass())) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_pk_class", new Object[]{((CMP3Policy)descriptor.getCMPPolicy()).getPKClass(), primaryKey.getClass()}));
            }
            return EntityManagerImpl.findInternal(descriptor, session, primaryKey);
        }
        catch (RuntimeException e) {
            this.transaction.setRollbackOnlyInternal();
            throw e;
        }
    }

    protected Object findInternal(Class entityClass, Object primaryKey) {
        this.verifyOpen();
        Session session = this.getActiveSession();
        ClassDescriptor descriptor = session.getDescriptor(entityClass);
        if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_bean_class", new Object[]{entityClass}));
        }
        if (((CMP3Policy)descriptor.getCMPPolicy()).getPKClass() != null && !((CMP3Policy)descriptor.getCMPPolicy()).getPKClass().isAssignableFrom(primaryKey.getClass())) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_pk_class", new Object[]{((CMP3Policy)descriptor.getCMPPolicy()).getPKClass(), primaryKey.getClass()}));
        }
        return EntityManagerImpl.findInternal(descriptor, session, primaryKey);
    }

    protected static Object findInternal(ClassDescriptor descriptor, Session session, Object primaryKey) {
        Vector pk = primaryKey instanceof Vector ? (Vector)primaryKey : ((CMP3Policy)descriptor.getCMPPolicy()).createPkVectorFromKey(primaryKey, (AbstractSession)session);
        ReadObjectQuery query = new ReadObjectQuery(descriptor.getJavaClass());
        query.setSelectionKey(pk);
        query.conformResultsInUnitOfWork();
        return session.executeQuery(query);
    }

    public void flush() {
        this.verifyOpen();
        try {
            this.getActivePersistenceContext(this.checkForTransaction(true)).writeChanges();
        }
        catch (RuntimeException e) {
            this.transaction.setRollbackOnlyInternal();
            if (TopLinkException.class.isAssignableFrom(e.getClass())) {
                throw new PersistenceException(e);
            }
            throw e;
        }
    }

    protected void detectTransactionWrapper() {
        if (this.serverSession.hasExternalTransactionController()) {
            this.setJTATransactionWrapper();
        } else {
            this.setEntityTransactionWrapper();
        }
    }

    public void refresh(Object entity) {
        this.verifyOpen();
        RepeatableWriteUnitOfWork uow = this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended()));
        if (!this.contains(entity, uow)) {
            this.transaction.setRollbackOnlyInternal();
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cant_refresh_not_managed_object", new Object[]{entity}));
        }
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject(entity);
        query.refreshIdentityMapResult();
        query.cascadeByMapping();
        query.setLockMode((short)0);
        Object refreshedEntity = null;
        try {
            refreshedEntity = uow.executeQuery(query);
        }
        catch (RuntimeException e) {
            this.transaction.setRollbackOnlyInternal();
            throw e;
        }
        if (refreshedEntity == null) {
            throw new EntityNotFoundException(ExceptionLocalization.buildMessage("entity_no_longer_exists_in_db", new Object[]{entity}));
        }
    }

    public boolean contains(Object entity) {
        this.verifyOpen();
        ClassDescriptor descriptor = (ClassDescriptor)this.getServerSession().getDescriptors().get(entity.getClass());
        if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
        }
        if (!this.hasActivePersistenceContext()) {
            return false;
        }
        return this.contains(entity, this.getActivePersistenceContext(this.checkForTransaction(false)));
    }

    protected boolean contains(Object entity, UnitOfWork uow) {
        return ((UnitOfWorkImpl)uow).isObjectRegistered(entity) && !((UnitOfWorkImpl)uow).isObjectDeleted(entity);
    }

    public Session getActiveSession() {
        Object txn = this.checkForTransaction(false);
        if (txn == null && !this.isExtended()) {
            return this.serverSession.acquireNonSynchronizedUnitOfWork();
        }
        return this.getActivePersistenceContext(txn);
    }

    public Object getDelegate() {
        return this;
    }

    public UnitOfWork getUnitOfWork() {
        return this.getActivePersistenceContext(this.checkForTransaction(false));
    }

    public Session getSession() {
        if (this.checkForTransaction(false) == null) {
            return this.serverSession.acquireNonSynchronizedUnitOfWork();
        }
        return null;
    }

    public ServerSession getServerSession() {
        return this.serverSession;
    }

    protected DatabaseQuery createNativeQueryInternal(String sqlString, Class resultType) {
        this.verifyOpen();
        ReadAllQuery query = new ReadAllQuery(resultType);
        query.setSQLString(sqlString);
        return query;
    }

    protected DatabaseQuery createQueryInternal(Expression expression, Class resultType) {
        ReadAllQuery query = new ReadAllQuery(resultType);
        query.setSelectionCriteria(expression);
        return query;
    }

    public void close() {
        this.verifyOpen();
        this.isOpen = false;
        if (this.transaction.shouldClose()) {
            if (this.isExtended() && this.extendedPersistenceContext != null) {
                this.extendedPersistenceContext.release();
                this.extendedPersistenceContext.getParent().release();
            }
        } else {
            if (this.isExtended() && this.extendedPersistenceContext != null) {
                this.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(false);
            }
            this.transaction.markLastTransaction();
        }
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void lock(Object entity, LockModeType lockMode) {
        RepeatableWriteUnitOfWork context = this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended()));
        ClassDescriptor descriptor = context.getDescriptor(entity);
        OptimisticLockingPolicy lockingPolicy = descriptor.getOptimisticLockingPolicy();
        if (lockingPolicy == null || !(lockingPolicy instanceof VersionLockingPolicy)) {
            this.transaction.setRollbackOnlyInternal();
            throw new PersistenceException(ExceptionLocalization.buildMessage("ejb30-wrong-lock_called_without_version_locking-index", null));
        }
        context.forceUpdateToVersionField(entity, lockMode == LockModeType.WRITE);
    }

    public void verifyOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_on_closed_entity_manager"));
        }
    }

    public RepeatableWriteUnitOfWork getActivePersistenceContext(Object txn) {
        if (this.isExtended()) {
            if (this.extendedPersistenceContext == null || !this.extendedPersistenceContext.isActive()) {
                this.extendedPersistenceContext = new RepeatableWriteUnitOfWork(this.serverSession.acquireClientSession());
                this.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(true);
                if (txn != null) {
                    this.transaction.registerUnitOfWorkWithTxn(this.extendedPersistenceContext);
                }
            }
            return this.extendedPersistenceContext;
        }
        return this.getTransactionalUnitOfWork_new(txn);
    }

    private boolean hasActivePersistenceContext() {
        return !this.isExtended() || this.extendedPersistenceContext != null && this.extendedPersistenceContext.isActive();
    }

    protected RepeatableWriteUnitOfWork getTransactionalUnitOfWork_new(Object tnx) {
        return this.transaction.getTransactionalUnitOfWork(tnx);
    }

    protected Object checkForTransaction(boolean validateExistence) {
        return this.transaction.checkForTransaction(validateExistence);
    }

    public boolean shouldPropagatePersistenceContext() {
        return this.propagatePersistenceContext;
    }

    public void joinTransaction() {
        this.transaction.registerUnitOfWorkWithTxn(this.getActivePersistenceContext(this.checkForTransaction(true)));
    }
}

