/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.identitymaps;

import java.io.Serializable;
import java.util.Vector;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.ConcurrencyManager;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.identitymaps.IdentityMap;
import oracle.toplink.essentials.sessions.Record;

public class CacheKey
implements Serializable,
Cloneable {
    protected Vector key;
    protected int hash;
    protected Object object;
    protected IdentityMap mapOwner;
    protected Object writeLockValue;
    protected Object wrapper;
    protected ConcurrencyManager mutex;
    protected Record record;
    protected long lastUpdatedQueryId;
    protected int invalidationState = 0;
    public static final int CHECK_INVALIDATION_POLICY = 0;
    public static final int CACHE_KEY_INVALID = -1;
    protected long readTime = 0L;

    public CacheKey(Vector primaryKeys) {
        this.key = primaryKeys;
        this.hash = this.computeHash(primaryKeys);
    }

    public CacheKey(Vector primaryKey, Object object, Object lockValue) {
        this(primaryKey);
        this.setObject(object);
        this.writeLockValue = lockValue;
    }

    public CacheKey(Vector primaryKey, Object object, Object lockValue, long readTime) {
        this(primaryKey, object, lockValue);
        this.readTime = readTime;
    }

    public void acquire() {
        this.getMutex().acquire(false);
    }

    public void acquire(boolean forMerge) {
        this.getMutex().acquire(forMerge);
    }

    public boolean acquireNoWait() {
        return this.getMutex().acquireNoWait(false);
    }

    public boolean acquireNoWait(boolean forMerge) {
        return this.getMutex().acquireNoWait(forMerge);
    }

    public void acquireDeferredLock() {
        this.getMutex().acquireDeferredLock();
    }

    public void checkReadLock() {
        this.getMutex().checkReadLock();
    }

    public void acquireReadLock() {
        this.getMutex().acquireReadLock();
    }

    public boolean acquireReadLockNoWait() {
        return this.getMutex().acquireReadLockNoWait();
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        return object;
    }

    protected int computeHash(Vector primaryKey) {
        int computedHashValue = 0;
        for (int index = 0; index < primaryKey.size(); ++index) {
            Object value = primaryKey.elementAt(index);
            if (value == null) continue;
            computedHashValue ^= value.hashCode();
        }
        return computedHashValue;
    }

    public boolean equals(Object object) {
        if (object instanceof CacheKey) {
            return this.equals((CacheKey)object);
        }
        return false;
    }

    public boolean equals(CacheKey key) {
        if (this == key) {
            return true;
        }
        if (this.getKey().size() == key.getKey().size()) {
            for (int index = 0; index < this.getKey().size(); ++index) {
                Object myValue = this.getKey().elementAt(index);
                Object comparisionValue = key.getKey().elementAt(index);
                if (myValue == null) {
                    if (comparisionValue == null) continue;
                    return false;
                }
                if (myValue.getClass().isArray()) {
                    if (myValue.getClass() == ClassConstants.APBYTE && comparisionValue.getClass() == ClassConstants.APBYTE && Helper.compareByteArrays((byte[])myValue, (byte[])comparisionValue)) {
                        return false;
                    }
                    if (myValue.getClass() == ClassConstants.APCHAR && comparisionValue.getClass() == ClassConstants.APCHAR && Helper.compareCharArrays((char[])myValue, (char[])comparisionValue)) {
                        return false;
                    }
                    if (!Helper.compareArrays((Object[])myValue, (Object[])comparisionValue)) continue;
                    return false;
                }
                if (myValue.equals(comparisionValue)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public long getLastUpdatedQueryId() {
        return this.lastUpdatedQueryId;
    }

    public Vector getKey() {
        return this.key;
    }

    public synchronized ConcurrencyManager getMutex() {
        if (this.mutex == null) {
            this.mutex = new ConcurrencyManager(this);
        }
        return this.mutex;
    }

    public Object getObject() {
        return this.object;
    }

    public IdentityMap getOwningMap() {
        return this.mapOwner;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public Record getRecord() {
        return this.record;
    }

    public Object getWrapper() {
        return this.wrapper;
    }

    public Object getWriteLockValue() {
        return this.writeLockValue;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isAcquired() {
        return this.getMutex().isAcquired();
    }

    public int getInvalidationState() {
        return this.invalidationState;
    }

    public void release() {
        this.getMutex().release();
    }

    public void releaseDeferredLock() {
        this.getMutex().releaseDeferredLock();
    }

    public void releaseReadLock() {
        this.getMutex().releaseReadLock();
    }

    public void setInvalidationState(int invalidationState) {
        this.invalidationState = invalidationState;
    }

    public void setLastUpdatedQueryId(long id) {
        this.lastUpdatedQueryId = id;
    }

    public void setKey(Vector key) {
        this.key = key;
        this.hash = this.computeHash(key);
    }

    public void setMutex(ConcurrencyManager mutex) {
        this.mutex = mutex;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setOwningMap(IdentityMap map) {
        this.mapOwner = map;
    }

    public void setReadTime(long readTime) {
        this.readTime = readTime;
        this.invalidationState = 0;
    }

    public void setRecord(Record newRecord) {
        this.record = newRecord;
    }

    public void setWrapper(Object wrapper) {
        this.wrapper = wrapper;
    }

    public void setWriteLockValue(Object writeLockValue) {
        this.writeLockValue = writeLockValue;
    }

    public String toString() {
        int hashCode = 0;
        if (this.getObject() != null) {
            hashCode = this.getObject().hashCode();
        }
        return "[" + this.getKey() + ": " + hashCode + ": " + this.getWriteLockValue() + ": " + this.getReadTime() + ": " + this.getObject() + "]";
    }

    public void updateAccess() {
    }
}

