/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.lang.reflect.Field;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.parsing.BasicTypeHelperImpl;
import oracle.toplink.essentials.internal.parsing.TypeHelper;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.AggregateMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;

public class TypeHelperImpl
extends BasicTypeHelperImpl
implements TypeHelper {
    private final AbstractSession session;
    private final ClassLoader classLoader;

    public TypeHelperImpl(AbstractSession session, ClassLoader classLoader) {
        this.session = session;
        this.classLoader = classLoader;
    }

    public Object resolveTypeName(String typeName) {
        try {
            return PrivilegedAccessController.getClassForName(typeName, true, this.classLoader);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public Object resolveAttribute(Object ownerClass, String attribute) {
        Class clazz = (Class)ownerClass;
        DatabaseMapping mapping = this.resolveAttributeMapping((Class)ownerClass, attribute);
        Class<?> type = this.getType(mapping);
        if (type == null && mapping != null) {
            try {
                Field field = Helper.getField(clazz, attribute);
                if (field != null) {
                    type = field.getType();
                }
            }
            catch (NoSuchFieldException ex) {
                // empty catch block
            }
        }
        return type;
    }

    public Object resolveSchema(String schemaName) {
        ClassDescriptor descriptor = this.session.getDescriptorForAlias(schemaName);
        return descriptor != null ? descriptor.getJavaClass() : null;
    }

    public String getTypeName(Object type) {
        if (type == null) {
            return null;
        }
        return ((Class)type).getName();
    }

    public Object resolveEnumConstant(Object type, String constant) {
        Class clazz = (Class)type;
        T[] constants = clazz.getEnumConstants();
        if (constants != null) {
            for (int i = 0; i < constants.length; ++i) {
                if (!constant.equals(constants[i].toString())) continue;
                return constants[i];
            }
        }
        return null;
    }

    private DatabaseMapping resolveAttributeMapping(Class ownerClass, String attribute) {
        ClassDescriptor descriptor = this.session.getDescriptor(ownerClass);
        return descriptor == null ? null : descriptor.getMappingForAttributeName(attribute);
    }

    private Object getType(DatabaseMapping mapping) {
        ClassDescriptor descriptor;
        if (mapping == null) {
            return null;
        }
        Class type = null;
        type = mapping.isForeignReferenceMapping() ? ((descriptor = mapping.getReferenceDescriptor()) == null ? null : descriptor.getJavaClass()) : (mapping.isAggregateMapping() ? ((AggregateMapping)mapping).getReferenceClass() : mapping.getAttributeClassification());
        return type;
    }
}

