/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.chartData.processors;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.Iterator;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.chartData.interfaces.IDataSeries;
import org.jCharts.chartData.interfaces.IStockChartDataSet;
import org.jCharts.chartData.processors.NonStackedDataProcessor;
import org.jCharts.chartData.processors.StackedDataProcessor;
import org.jCharts.chartData.processors.StockDataProcessor;
import org.jCharts.chartData.processors.TextProcessor;
import org.jCharts.types.ChartType;

public final class AxisChartDataProcessor {
    private double max;
    private double min;
    private TextProcessor lengendLabelProcessor;
    private TextProcessor axisLabelProcessor;
    private TextLayout titleTextLayout;

    public void processData(AxisChart axisChart, FontRenderContext fontRenderContext) {
        if (!axisChart.getAxisProperties().hasUserDefinedScale()) {
            this.processDataSet(axisChart.getIDataSeries());
        }
        this.processAxisLabels(axisChart.getIDataSeries(), axisChart.getAxisProperties().getScaleFont(), fontRenderContext);
    }

    private void processAxisLabels(IDataSeries iDataSeries, Font font, FontRenderContext fontRenderContext) {
        this.axisLabelProcessor = new TextProcessor(iDataSeries.getNumberOfXAxisLabels());
        int n = 0;
        while (n < iDataSeries.getNumberOfXAxisLabels()) {
            this.axisLabelProcessor.processLabel(iDataSeries.getXAxisLabel(n), font, fontRenderContext);
            ++n;
        }
    }

    private void processDataSet(IDataSeries iDataSeries) {
        Iterator iterator = iDataSeries.getIAxisChartDataSetIterator();
        while (iterator.hasNext()) {
            IAxisPlotDataSet iAxisPlotDataSet = (IAxisPlotDataSet)iterator.next();
            if (iAxisPlotDataSet.getChartType().isStacked()) {
                StackedDataProcessor.processData((IAxisChartDataSet)iAxisPlotDataSet, this);
                continue;
            }
            if (iAxisPlotDataSet.getChartType().equals(ChartType.STOCK)) {
                StockDataProcessor.processData((IStockChartDataSet)iAxisPlotDataSet, this);
                continue;
            }
            NonStackedDataProcessor.processData((IAxisChartDataSet)iAxisPlotDataSet, this);
        }
    }

    public TextLayout getTitleTextLayout() {
        return this.titleTextLayout;
    }

    void setMaxValue(double d) {
        this.max = d;
    }

    public double getMaxValue() {
        return this.max;
    }

    void setMinValue(double d) {
        this.min = d;
    }

    public double getMinValue() {
        return this.min;
    }

    public TextProcessor getLegendLabelProcessor() {
        return this.lengendLabelProcessor;
    }

    public TextProcessor getAxisLabelProcessor() {
        return this.axisLabelProcessor;
    }
}

