/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.encoders;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.jCharts.Chart;
import org.jCharts.encoders.BinaryEncoderUtil;

public final class PNGEncoder {
    public static final String MIME_TYPE = "image/png";
    private static final String PNG = "png";

    private PNGEncoder() throws Exception {
        throw new Exception("No need to create an instance of this class!");
    }

    public static final void encode(Chart chart, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType(MIME_TYPE);
        PNGEncoder.encode(chart, (OutputStream)httpServletResponse.getOutputStream());
    }

    public static final void encode(Chart chart, OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = BinaryEncoderUtil.render(chart);
        ImageIO.write((RenderedImage)bufferedImage, PNG, outputStream);
    }

    static {
        ImageIO.setUseCache(false);
    }
}

