/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.Collections;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.CrossJoinFunDef;
import mondrian.olap.fun.ReflectiveMultiResolver;

public class NonEmptyCrossJoinFunDef
extends CrossJoinFunDef {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("NonEmptyCrossJoin", "NonEmptyCrossJoin(<Set1>, <Set2>)", "Returns the cross product of two sets, excluding empty tuples and tuples without associated fact table data.", new String[]{"fxxx"}, NonEmptyCrossJoinFunDef.class);

    public NonEmptyCrossJoinFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(final ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc1 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc2 = compiler.compileList(call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{listCalc1, listCalc2}, false){

            public List evaluateList(Evaluator evaluator) {
                SchemaReader schemaReader = evaluator.getSchemaReader();
                evaluator = evaluator.push(true);
                NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
                if (nativeEvaluator != null) {
                    return (List)nativeEvaluator.execute(ResultStyle.LIST);
                }
                List list1 = listCalc1.evaluateList(evaluator);
                if (list1.isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                List list2 = listCalc2.evaluateList(evaluator);
                List<Member[]> result = CrossJoinFunDef.crossJoin(list1, list2);
                result = NonEmptyCrossJoinFunDef.this.nonEmptyList(evaluator, result, call);
                return result;
            }

            public boolean dependsOn(Dimension dimension) {
                if (super.dependsOn(dimension)) {
                    return true;
                }
                if (listCalc1.getType().usesDimension(dimension, true)) {
                    return false;
                }
                return !listCalc2.getType().usesDimension(dimension, true);
            }
        };
    }
}

