/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.Axis;

public interface Modulos {
    public int[] getCellPos(int var1);

    public int getCellOrdinal(int[] var1);

    public static class Many
    extends Base {
        private Many(Axis[] axes) {
            super(axes);
            int modulo = 1;
            for (int i = 0; i < axes.length; ++i) {
                this.modulos[i + 1] = modulo *= axes[i].getPositions().size();
            }
        }

        private Many(int[] lengths) {
            super(lengths);
            int modulo = 1;
            for (int i = 0; i < lengths.length; ++i) {
                this.modulos[i + 1] = modulo *= lengths[i];
            }
        }

        public int[] getCellPos(int cellOrdinal) {
            int[] modulos = this.modulos;
            int size = modulos.length - 1;
            int[] pos = new int[size];
            for (int i = 0; i < size; ++i) {
                pos[i] = cellOrdinal % modulos[i + 1] / modulos[i];
            }
            return pos;
        }

        public int getCellOrdinal(int[] pos) {
            int[] modulos = this.modulos;
            int size = modulos.length - 1;
            int ordinal = 0;
            for (int i = 0; i < size; ++i) {
                ordinal += pos[i] * modulos[i];
            }
            return ordinal;
        }
    }

    public static class Three
    extends Base {
        private Three(Axis[] axes) {
            super(axes);
            int modulo;
            this.modulos[1] = modulo = axes[0].getPositions().size();
            this.modulos[2] = modulo *= axes[1].getPositions().size();
            this.modulos[3] = modulo *= axes[2].getPositions().size();
        }

        public final int[] getCellPos(int cellOrdinal) {
            int[] modulos = this.modulos;
            return new int[]{cellOrdinal % modulos[1], cellOrdinal % modulos[2] / modulos[1], cellOrdinal % modulos[3] / modulos[2]};
        }

        public final int getCellOrdinal(int[] pos) {
            int[] modulos = this.modulos;
            return pos[0] * modulos[0] + pos[1] * modulos[1] + pos[2] * modulos[2];
        }
    }

    public static class Two
    extends Base {
        private Two(Axis[] axes) {
            super(axes);
            int modulo;
            this.modulos[1] = modulo = axes[0].getPositions().size();
            this.modulos[2] = modulo *= axes[1].getPositions().size();
        }

        public final int[] getCellPos(int cellOrdinal) {
            int[] modulos = this.modulos;
            return new int[]{cellOrdinal % modulos[1], cellOrdinal % modulos[2] / modulos[1]};
        }

        public final int getCellOrdinal(int[] pos) {
            int[] modulos = this.modulos;
            return pos[0] * modulos[0] + pos[1] * modulos[1];
        }
    }

    public static class One
    extends Base {
        private One(Axis[] axes) {
            super(axes);
            this.modulos[1] = axes[0].getPositions().size();
        }

        public final int[] getCellPos(int cellOrdinal) {
            return new int[]{cellOrdinal % this.modulos[1]};
        }

        public final int getCellOrdinal(int[] pos) {
            return pos[0] * this.modulos[0];
        }
    }

    public static class Zero
    extends Base {
        private static final int[] pos = new int[0];

        private Zero(Axis[] axes) {
            super(axes);
        }

        public final int[] getCellPos(int cellOrdinal) {
            return pos;
        }

        public final int getCellOrdinal(int[] pos) {
            return 0;
        }
    }

    public static abstract class Base
    implements Modulos {
        protected final int[] modulos;

        protected Base(Axis[] axes) {
            this.modulos = new int[axes.length + 1];
            this.modulos[0] = 1;
        }

        protected Base(int[] lengths) {
            this.modulos = new int[lengths.length + 1];
            this.modulos[0] = 1;
        }

        public abstract int[] getCellPos(int var1);

        public abstract int getCellOrdinal(int[] var1);

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append('(');
            for (int i = 0; i < this.modulos.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(this.modulos[i]);
            }
            buf.append(')');
            return buf.toString();
        }
    }

    public static class Generator {
        public static Modulos create(Axis[] axes) {
            switch (axes.length) {
                case 0: {
                    return new Zero(axes);
                }
                case 1: {
                    return new One(axes);
                }
                case 2: {
                    return new Two(axes);
                }
                case 3: {
                    return new Three(axes);
                }
            }
            return new Many(axes);
        }

        public static Modulos createMany(Axis[] axes) {
            return new Many(axes);
        }

        public static Modulos createMany(int[] lengths) {
            return new Many(lengths);
        }
    }
}

