/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import nickyb.sqleonardo.common.gui.Toolbar;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.Preferences;
import nickyb.sqleonardo.environment.ctrl.CommandEditor;
import nickyb.sqleonardo.environment.ctrl.editor.DialogCommand;
import nickyb.sqleonardo.environment.ctrl.editor.DialogFindReplace;
import nickyb.sqleonardo.environment.ctrl.editor.SQLStyledDocument;
import nickyb.sqleonardo.environment.mdi.ClientQueryBuilder;
import nickyb.sqleonardo.environment.mdi.MDIActions;
import nickyb.sqleonardo.environment.mdi.MDIClient;
import nickyb.sqleonardo.environment.mdi.MDIMenubar;
import nickyb.sqleonardo.environment.mdi._ConnectionListener;
import nickyb.sqleonardo.querybuilder.DiagramLayout;
import nickyb.sqleonardo.querybuilder.QueryModel;
import nickyb.sqleonardo.querybuilder.syntax.SQLParser;

public class ClientCommandEditor
extends MDIClient
implements _ConnectionListener {
    public static final String DEFAULT_TITLE = "command editor";
    private CommandEditor control = new CommandEditor();
    private JMenuItem[] m_actions;
    private Toolbar toolbar;
    private JComboBox cbx;
    private JCheckBox cbxLimit;
    private JTextField txtLimit;
    private DialogFindReplace dlg;

    public ClientCommandEditor() {
        super(DEFAULT_TITLE);
        this.setComponentCenter(this.control);
        this.control.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.createToolbar();
        this.initMenuActions();
        InternalFrameAdapter ifl = new InternalFrameAdapter(){

            public void internalFrameDeactivated(InternalFrameEvent e) {
                if (ClientCommandEditor.this.dlg != null) {
                    ClientCommandEditor.this.dlg.setVisible(false);
                }
            }
        };
        this.addInternalFrameListener(ifl);
        Application.window.addListener(this);
    }

    private void createToolbar() {
        this.cbx = new JComboBox<Object>(ConnectionAssistant.getHandlers().toArray());
        this.cbxLimit = new JCheckBox("limit rows:", true);
        this.cbxLimit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientCommandEditor.this.txtLimit.setEnabled(ClientCommandEditor.this.cbxLimit.isSelected());
            }
        });
        this.txtLimit = new JTextField("100"){

            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 75;
                return dim;
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.toolbar = new Toolbar(0);
        this.toolbar.add(new ActionOpen());
        this.toolbar.add(new ActionSave());
        this.toolbar.addSeparator();
        this.toolbar.add(new ActionShowFindReplace());
        this.toolbar.addSeparator();
        this.toolbar.add(this.control.getActionMap().get("start-task"));
        this.toolbar.add(this.control.getActionMap().get("stop-task"));
        this.toolbar.addSeparator();
        this.toolbar.add(this.cbxLimit);
        this.toolbar.add(this.txtLimit);
        this.toolbar.addSeparator();
        this.toolbar.add(new JLabel("use connection: "));
        this.toolbar.add(this.cbx);
        this.setComponentEast(this.toolbar);
    }

    private void initMenuActions() {
        this.m_actions = new JMenuItem[]{MDIMenubar.createItem(new ActionCommand()), null, MDIMenubar.createItem(new ActionClearInput()), MDIMenubar.createItem(new ActionClearOutput()), null, MDIMenubar.createItem(new ActionReverseSyntax())};
    }

    public final void dispose() {
        String limit = this.txtLimit.getText().trim();
        if (limit == null || limit.length() == 0) {
            limit = "0";
        }
        Preferences.set("editor.limit.rows", new Integer(limit));
        Preferences.set("editor.limit.enabled", new Boolean(this.cbxLimit.isSelected()));
        super.dispose();
    }

    public final CommandEditor getControl() {
        return this.control;
    }

    public JMenuItem[] getMenuActions() {
        return this.m_actions;
    }

    public Toolbar getSubToolbar() {
        return this.toolbar;
    }

    public final String getName() {
        return DEFAULT_TITLE;
    }

    protected void setPreferences() {
        this.cbxLimit.setSelected(Preferences.getBoolean("editor.limit.enabled", true));
        this.txtLimit.setText(String.valueOf(Preferences.getInteger("editor.limit.rows", 100)));
    }

    public int getLimitRows() {
        String limit = this.txtLimit.getText().trim();
        if (limit == null || limit.length() == 0) {
            limit = "0";
        }
        return this.cbxLimit.isSelected() ? Integer.valueOf(limit) : 0;
    }

    public void onConnectionClosed(String keycah) {
        this.cbx.removeItem(keycah);
    }

    public void onConnectionOpened(String keycah) {
        this.cbx.addItem(keycah);
    }

    public String getActiveConnection() {
        return this.cbx.getSelectedIndex() == -1 ? null : this.cbx.getSelectedItem().toString();
    }

    public void setActiveConnection(String keycah) {
        this.cbx.setSelectedItem(keycah);
    }

    private class ActionShowFindReplace
    extends AbstractAction {
        ActionShowFindReplace() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.012"));
            this.putValue("ShortDescription", "find/replace...");
            this.putValue("Name", "find/replace...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientCommandEditor.this.dlg == null) {
                ClientCommandEditor.this.dlg = new DialogFindReplace(ClientCommandEditor.this.getControl().getRequestArea());
            }
            ClientCommandEditor.this.dlg.setVisible(true);
        }
    }

    private class ActionReverseSyntax
    extends AbstractAction {
        ActionReverseSyntax() {
            this.putValue("Name", "reverse syntax");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientCommandEditor.this.getActiveConnection() == null) {
                Application.alert("SQLeonardo", "No connection!");
                return;
            }
            String sql = ClientCommandEditor.this.control.getSelectedText();
            if (Text.isEmpty(sql)) {
                Application.alert("SQLeonardo", "Nothing selected!");
                return;
            }
            try {
                ConnectionHandler ch;
                ArrayList schemas;
                QueryModel qm = SQLParser.toQueryModel(sql);
                if (!Preferences.getBoolean("querybuilder.use-schema") && (schemas = (ArrayList)(ch = ConnectionAssistant.getHandler(ClientCommandEditor.this.getActiveConnection())).getObject("$schema_names")).size() > 0) {
                    Object schema = JOptionPane.showInputDialog(Application.window, "schema:", "SQLeonardo", -1, null, schemas.toArray(), null);
                    if (schema == null) {
                        return;
                    }
                    qm.setSchema(schema.toString());
                }
                DiagramLayout dl = new DiagramLayout();
                dl.setQueryModel(qm);
                ClientQueryBuilder cqb = new ClientQueryBuilder(ClientCommandEditor.this.getActiveConnection());
                Application.window.add(cqb);
                cqb.setDiagramLayout(dl);
            }
            catch (IOException e) {
                Application.println(e, true);
            }
        }
    }

    private class ActionSave
    extends MDIActions.AbstractBase {
        private ActionSave() {
            this.setIcon("icon.121");
            this.setTooltip("save");
        }

        public void actionPerformed(ActionEvent ae) {
            String currentDirectory = Preferences.getString("lastDirectory", System.getProperty("user.home"));
            JFileChooser fc = new JFileChooser(currentDirectory);
            fc.setFileSelectionMode(0);
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".sql");
                }

                public String getDescription() {
                    return "script files (*.sql)";
                }
            });
            if (fc.showSaveDialog(Application.window) == 0) {
                Preferences.set("lastDirectory", fc.getCurrentDirectory().toString());
                String filename = fc.getSelectedFile().toString();
                if (fc.getFileFilter().getDescription().endsWith("(*.sql)") && !filename.endsWith(".sql")) {
                    filename = filename + ".sql";
                }
                this.save(filename);
            }
        }

        private void save(String filename) {
            try {
                SQLStyledDocument doc = ClientCommandEditor.this.control.getDocument();
                FileWriter out = new FileWriter(filename);
                out.write(doc.getText(0, doc.getLength()));
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (BadLocationException ble) {
                Application.println(ble, false);
            }
            catch (IOException ioe) {
                Application.println(ioe, false);
            }
        }
    }

    private class ActionOpen
    extends MDIActions.AbstractBase {
        private ActionOpen() {
            this.setIcon("icon.120");
            this.setTooltip("open");
        }

        public void actionPerformed(ActionEvent ae) {
            String currentDirectory = Preferences.getString("lastDirectory", System.getProperty("user.home"));
            JFileChooser fc = new JFileChooser(currentDirectory);
            fc.setFileSelectionMode(0);
            fc.setMultiSelectionEnabled(true);
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".sql");
                }

                public String getDescription() {
                    return "script files (*.sql)";
                }
            });
            if (fc.showOpenDialog(Application.window) == 0) {
                Preferences.set("lastDirectory", fc.getCurrentDirectory().toString());
                SQLStyledDocument doc = new SQLStyledDocument();
                for (int i = 0; i < fc.getSelectedFiles().length; ++i) {
                    String filename = fc.getSelectedFiles()[i].toString();
                    try {
                        this.load(doc, filename);
                        doc.insertString(doc.getLength(), "\n", null);
                        continue;
                    }
                    catch (BadLocationException ble) {
                        Application.println(ble, false);
                        continue;
                    }
                    catch (IOException ioe) {
                        Application.println(ioe, false);
                    }
                }
                ClientCommandEditor.this.control.setDocument(doc);
            }
        }

        private void load(SQLStyledDocument doc, String filename) throws IOException, BadLocationException {
            int nch;
            FileReader in = new FileReader(filename);
            char[] buff = new char[4096];
            while ((nch = ((Reader)in).read(buff, 0, buff.length)) != -1) {
                doc.insertString(doc.getLength(), new String(buff, 0, nch), null);
            }
            ((Reader)in).close();
        }
    }

    private class ActionClearOutput
    extends AbstractAction {
        ActionClearOutput() {
            this.putValue("Name", "clear response area");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
        }

        public void actionPerformed(ActionEvent ae) {
            ClientCommandEditor.this.control.clearResponse();
            ClientCommandEditor.this.control.transferFocus();
        }
    }

    private class ActionClearInput
    extends AbstractAction {
        ActionClearInput() {
            this.putValue("Name", "clear request area");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 2));
        }

        public void actionPerformed(ActionEvent ae) {
            ClientCommandEditor.this.control.setDocument(new SQLStyledDocument());
            ClientCommandEditor.this.control.transferFocus();
        }
    }

    private class ActionCommand
    extends AbstractAction {
        ActionCommand() {
            this.putValue("Name", "new command...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientCommandEditor.this.getActiveConnection() != null) {
                new DialogCommand(ClientCommandEditor.this.getActiveConnection(), null).setVisible(true);
            } else {
                Application.alert("SQLeonardo", "No connection!");
            }
        }
    }
}

