/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.DateTimeCalc;
import mondrian.calc.DimensionCalc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.HierarchyCalc;
import mondrian.calc.IntegerCalc;
import mondrian.calc.IterCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.MemberIterCalc;
import mondrian.calc.MemberListCalc;
import mondrian.calc.ParameterSlot;
import mondrian.calc.ResultStyle;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.TupleIterCalc;
import mondrian.calc.TupleListCalc;
import mondrian.calc.impl.AbstractBooleanCalc;
import mondrian.calc.impl.AbstractHierarchyCalc;
import mondrian.calc.impl.AbstractIntegerCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.calc.impl.AbstractMemberIterCalc;
import mondrian.calc.impl.AbstractTupleIterCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.calc.impl.IterableMemberListCalc;
import mondrian.calc.impl.IterableTupleListCalc;
import mondrian.calc.impl.MemberValueCalc;
import mondrian.calc.impl.TupleValueCalc;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Parameter;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.CastFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.HierarchyCurrentMemberFunDef;
import mondrian.olap.fun.HierarchyDimensionFunDef;
import mondrian.olap.fun.LevelHierarchyFunDef;
import mondrian.olap.fun.MemberHierarchyFunDef;
import mondrian.olap.fun.MemberLevelFunDef;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NullType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractExpCompiler
implements ExpCompiler {
    private final Evaluator evaluator;
    private final Validator validator;
    private final Map<Parameter, ParameterSlotImpl> parameterSlots = new HashMap<Parameter, ParameterSlotImpl>();
    private List<ResultStyle> resultStyles;

    public AbstractExpCompiler(Evaluator evaluator, Validator validator) {
        this(evaluator, validator, ResultStyle.ANY_LIST);
    }

    public AbstractExpCompiler(Evaluator evaluator, Validator validator, List<ResultStyle> resultStyles) {
        this.evaluator = evaluator;
        this.validator = validator;
        this.resultStyles = resultStyles == null ? ResultStyle.ANY_LIST : resultStyles;
    }

    @Override
    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public Validator getValidator() {
        return this.validator;
    }

    @Override
    public Calc compile(Exp exp) {
        return exp.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Calc compileAs(Exp exp, Type resultType, List<ResultStyle> preferredResultTypes) {
        assert (preferredResultTypes != null);
        int substitutions = 0;
        if (Util.Retrowoven) {
            ArrayList<ResultStyle> tmp = new ArrayList<ResultStyle>(preferredResultTypes.size());
            for (ResultStyle preferredResultType : preferredResultTypes) {
                if (preferredResultType == ResultStyle.ITERABLE) {
                    preferredResultType = ResultStyle.LIST;
                    ++substitutions;
                }
                tmp.add(preferredResultType);
            }
            preferredResultTypes = tmp;
        }
        List<ResultStyle> save = this.resultStyles;
        try {
            Calc calc;
            this.resultStyles = preferredResultTypes;
            if (resultType != null && resultType != exp.getType()) {
                Object i$;
                if (resultType instanceof MemberType) {
                    i$ = this.compileMember(exp);
                    return i$;
                }
                if (resultType instanceof LevelType) {
                    i$ = this.compileLevel(exp);
                    return i$;
                }
                if (resultType instanceof HierarchyType) {
                    i$ = this.compileHierarchy(exp);
                    return i$;
                }
                if (resultType instanceof DimensionType) {
                    i$ = this.compileDimension(exp);
                    return i$;
                }
            }
            Calc calc2 = this.compile(exp);
            if (substitutions > 0) {
                if (calc2 == null) {
                    this.resultStyles = Collections.singletonList(ResultStyle.ITERABLE);
                    calc = this.compile(exp);
                    return calc;
                }
                if (calc2 instanceof IterCalc) {
                    calc = calc2;
                    return calc;
                }
                assert (calc2 instanceof ListCalc);
                if (((SetType)calc2.getType()).getArity() == 1) {
                    calc = this.toIter((MemberListCalc)calc2);
                    return calc;
                }
                calc = this.toIter((TupleListCalc)calc2);
                return calc;
            }
            calc = calc2;
            return calc;
        }
        finally {
            this.resultStyles = save;
        }
    }

    @Override
    public MemberCalc compileMember(Exp exp) {
        Type type = exp.getType();
        if (type instanceof DimensionType) {
            DimensionCalc dimensionCalc = this.compileDimension(exp);
            return new DimensionCurrentMemberCalc((Exp)new DummyExp(TypeUtil.toMemberType(type)), dimensionCalc);
        }
        if (type instanceof HierarchyType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return new HierarchyCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(TypeUtil.toMemberType(type)), hierarchyCalc);
        }
        if (type instanceof NullType) {
            throw MondrianResource.instance().NullNotSupported.ex();
        }
        assert (type instanceof MemberType);
        return (MemberCalc)this.compile(exp);
    }

    @Override
    public LevelCalc compileLevel(Exp exp) {
        Type type = exp.getType();
        if (type instanceof MemberType) {
            MemberCalc memberCalc = this.compileMember(exp);
            return new MemberLevelFunDef.CalcImpl((Exp)new DummyExp(LevelType.forType(type)), memberCalc);
        }
        assert (type instanceof LevelType);
        return (LevelCalc)this.compile(exp);
    }

    @Override
    public DimensionCalc compileDimension(Exp exp) {
        Type type = exp.getType();
        if (type instanceof HierarchyType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return new HierarchyDimensionFunDef.CalcImpl((Exp)new DummyExp(new DimensionType(type.getDimension())), hierarchyCalc);
        }
        assert (type instanceof DimensionType) : type;
        return (DimensionCalc)this.compile(exp);
    }

    @Override
    public HierarchyCalc compileHierarchy(Exp exp) {
        Type type = exp.getType();
        if (type instanceof DimensionType) {
            Hierarchy hierarchy;
            Dimension dimension = type.getDimension();
            if (dimension != null && (hierarchy = FunUtil.getDimensionDefaultHierarchy(dimension)) != null) {
                return (HierarchyCalc)ConstantCalc.constantHierarchy(hierarchy);
            }
            DimensionCalc dimensionCalc = this.compileDimension(exp);
            return new DimensionHierarchyCalc((Exp)new DummyExp(HierarchyType.forType(type)), dimensionCalc);
        }
        if (type instanceof MemberType) {
            MemberCalc memberCalc = this.compileMember(exp);
            return new MemberHierarchyFunDef.CalcImpl((Exp)new DummyExp(HierarchyType.forType(type)), memberCalc);
        }
        if (type instanceof LevelType) {
            LevelCalc levelCalc = this.compileLevel(exp);
            return new LevelHierarchyFunDef.CalcImpl((Exp)new DummyExp(HierarchyType.forType(type)), levelCalc);
        }
        assert (type instanceof HierarchyType);
        return (HierarchyCalc)this.compile(exp);
    }

    @Override
    public IntegerCalc compileInteger(Exp exp) {
        Calc calc = this.compileScalar(exp, false);
        Type type = calc.getType();
        if (type instanceof DecimalType && ((DecimalType)type).getScale() == 0) {
            return (IntegerCalc)calc;
        }
        if (type instanceof NumericType) {
            if (calc instanceof ConstantCalc) {
                ConstantCalc constantCalc = (ConstantCalc)calc;
                return new ConstantCalc(new DecimalType(Integer.MAX_VALUE, 0), constantCalc.evaluateInteger(null));
            }
            if (calc instanceof DoubleCalc) {
                final DoubleCalc doubleCalc = (DoubleCalc)calc;
                return new AbstractIntegerCalc(exp, new Calc[]{doubleCalc}){

                    public int evaluateInteger(Evaluator evaluator) {
                        return (int)doubleCalc.evaluateDouble(evaluator);
                    }
                };
            }
        }
        return (IntegerCalc)calc;
    }

    @Override
    public StringCalc compileString(Exp exp) {
        return (StringCalc)this.compile(exp);
    }

    @Override
    public DateTimeCalc compileDateTime(Exp exp) {
        return (DateTimeCalc)this.compile(exp);
    }

    @Override
    public ListCalc compileList(Exp exp) {
        return this.compileList(exp, false);
    }

    @Override
    public ListCalc compileList(Exp exp, boolean mutable) {
        List<ResultStyle> resultStyleList = mutable ? ResultStyle.MUTABLELIST_ONLY : ResultStyle.LIST_ONLY;
        Calc calc = this.compileAs(exp, null, resultStyleList);
        if (calc instanceof ListCalc) {
            return (ListCalc)calc;
        }
        if (calc == null) {
            calc = this.compileAs(exp, null, ResultStyle.ITERABLE_ANY);
            assert (calc != null);
        }
        if (calc instanceof IterCalc) {
            if (((SetType)calc.getType()).getArity() == 1) {
                return this.toList((MemberIterCalc)calc);
            }
            return this.toList((TupleIterCalc)calc);
        }
        throw Util.newInternal("Cannot convert calc to list: " + calc);
    }

    public MemberListCalc toList(MemberIterCalc calc) {
        return new IterableMemberListCalc(calc);
    }

    public TupleListCalc toList(TupleIterCalc calc) {
        return new IterableTupleListCalc(calc);
    }

    @Override
    public IterCalc compileIter(Exp exp) {
        Calc calc = this.compileAs(exp, null, ResultStyle.ITERABLE_ONLY);
        if (calc == null) {
            calc = this.compileAs(exp, null, ResultStyle.ANY_ONLY);
            assert (calc != null);
        }
        if (calc instanceof IterCalc) {
            return (IterCalc)calc;
        }
        if (((SetType)calc.getType()).getArity() == 1) {
            return this.toIter((MemberListCalc)calc);
        }
        return this.toIter((TupleListCalc)calc);
    }

    public MemberIterCalc toIter(MemberListCalc memberListCalc) {
        return new MemberListIterCalc(memberListCalc);
    }

    public TupleIterCalc toIter(TupleListCalc tupleListCalc) {
        return new TupleListIterCalc(tupleListCalc);
    }

    @Override
    public BooleanCalc compileBoolean(Exp exp) {
        Calc calc = this.compileScalar(exp, false);
        if (calc instanceof BooleanCalc) {
            Object o;
            if (calc instanceof ConstantCalc && !((o = calc.evaluate(null)) instanceof Boolean)) {
                return ConstantCalc.constantBoolean(CastFunDef.toBoolean(o, new BooleanType()));
            }
            return (BooleanCalc)calc;
        }
        if (calc instanceof DoubleCalc) {
            final DoubleCalc doubleCalc = (DoubleCalc)calc;
            return new AbstractBooleanCalc(exp, new Calc[]{doubleCalc}){

                public boolean evaluateBoolean(Evaluator evaluator) {
                    return doubleCalc.evaluateDouble(evaluator) != 0.0;
                }
            };
        }
        if (calc instanceof IntegerCalc) {
            final IntegerCalc integerCalc = (IntegerCalc)calc;
            return new AbstractBooleanCalc(exp, new Calc[]{integerCalc}){

                public boolean evaluateBoolean(Evaluator evaluator) {
                    return integerCalc.evaluateInteger(evaluator) != 0;
                }
            };
        }
        return (BooleanCalc)calc;
    }

    @Override
    public DoubleCalc compileDouble(Exp exp) {
        DoubleCalc calc = (DoubleCalc)this.compileScalar(exp, false);
        if (calc instanceof ConstantCalc && !(calc.evaluate(null) instanceof Double)) {
            return ConstantCalc.constantDouble(calc.evaluateDouble(null));
        }
        return calc;
    }

    @Override
    public TupleCalc compileTuple(Exp exp) {
        return (TupleCalc)this.compile(exp);
    }

    @Override
    public Calc compileScalar(Exp exp, boolean specific) {
        Type type = exp.getType();
        if (type instanceof MemberType) {
            MemberType memberType = (MemberType)type;
            MemberCalc calc = this.compileMember(exp);
            return new MemberValueCalc(new DummyExp(memberType.getValueType()), new MemberCalc[]{calc});
        }
        if (type instanceof DimensionType) {
            DimensionCalc dimensionCalc = this.compileDimension(exp);
            MemberType memberType = MemberType.forType(type);
            DimensionCurrentMemberCalc dimensionCurrentMemberCalc = new DimensionCurrentMemberCalc((Exp)new DummyExp(memberType), dimensionCalc);
            return new MemberValueCalc(new DummyExp(memberType.getValueType()), new MemberCalc[]{dimensionCurrentMemberCalc});
        }
        if (type instanceof HierarchyType) {
            HierarchyType hierarchyType = (HierarchyType)type;
            MemberType memberType = MemberType.forHierarchy(hierarchyType.getHierarchy());
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            HierarchyCurrentMemberFunDef.CalcImpl hierarchyCurrentMemberCalc = new HierarchyCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(memberType), hierarchyCalc);
            return new MemberValueCalc(new DummyExp(memberType.getValueType()), new MemberCalc[]{hierarchyCurrentMemberCalc});
        }
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            TupleCalc tupleCalc = this.compileTuple(exp);
            TupleValueCalc scalarCalc = new TupleValueCalc(new DummyExp(tupleType.getValueType()), tupleCalc);
            return scalarCalc.optimize();
        }
        if (type instanceof ScalarType) {
            if (specific) {
                if (type instanceof BooleanType) {
                    return this.compileBoolean(exp);
                }
                if (type instanceof NumericType) {
                    return this.compileDouble(exp);
                }
                if (type instanceof StringType) {
                    return this.compileString(exp);
                }
                return this.compile(exp);
            }
            return this.compile(exp);
        }
        return this.compile(exp);
    }

    @Override
    public ParameterSlot registerParameter(Parameter parameter) {
        ParameterSlot slot = this.parameterSlots.get(parameter);
        if (slot != null) {
            return slot;
        }
        int index = this.parameterSlots.size();
        ParameterSlotImpl slot2 = new ParameterSlotImpl(parameter, index);
        this.parameterSlots.put(parameter, slot2);
        slot2.value = parameter.getValue();
        Calc calc = parameter.getDefaultExp().accept(this);
        slot2.setDefaultValueCalc(calc);
        return slot2;
    }

    @Override
    public List<ResultStyle> getAcceptableResultStyles() {
        return this.resultStyles;
    }

    public static class DimensionCurrentMemberCalc
    extends AbstractMemberCalc {
        private final DimensionCalc dimensionCalc;

        public DimensionCurrentMemberCalc(Exp exp, DimensionCalc dimensionCalc) {
            super(exp, new Calc[]{dimensionCalc});
            this.dimensionCalc = dimensionCalc;
        }

        protected String getName() {
            return "CurrentMember";
        }

        public Member evaluateMember(Evaluator evaluator) {
            Dimension dimension = this.dimensionCalc.evaluateDimension(evaluator);
            return evaluator.getContext(dimension);
        }

        public boolean dependsOn(Dimension dimension) {
            return this.dimensionCalc.getType().usesDimension(dimension, true);
        }
    }

    private static class DimensionHierarchyCalc
    extends AbstractHierarchyCalc {
        private final DimensionCalc dimensionCalc;

        protected DimensionHierarchyCalc(Exp exp, DimensionCalc dimensionCalc) {
            super(exp, new Calc[]{dimensionCalc});
            this.dimensionCalc = dimensionCalc;
        }

        public Hierarchy evaluateHierarchy(Evaluator evaluator) {
            Dimension dimension = this.dimensionCalc.evaluateDimension(evaluator);
            Hierarchy hierarchy = FunUtil.getDimensionDefaultHierarchy(dimension);
            if (hierarchy != null) {
                return hierarchy;
            }
            throw FunUtil.newEvalException(MondrianResource.instance().CannotImplicitlyConvertDimensionToHierarchy.ex(dimension.getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TupleListIterCalc
    extends AbstractTupleIterCalc {
        private final TupleListCalc tupleListCalc;

        public TupleListIterCalc(TupleListCalc tupleListCalc) {
            super(new DummyExp(tupleListCalc.getType()), new Calc[]{tupleListCalc});
            this.tupleListCalc = tupleListCalc;
        }

        @Override
        public Iterable<Member[]> evaluateTupleIterable(Evaluator evaluator) {
            return this.tupleListCalc.evaluateTupleList(evaluator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberListIterCalc
    extends AbstractMemberIterCalc {
        private final MemberListCalc memberListCalc;

        public MemberListIterCalc(MemberListCalc memberListCalc) {
            super(new DummyExp(memberListCalc.getType()), new Calc[]{memberListCalc});
            this.memberListCalc = memberListCalc;
        }

        @Override
        public Iterable<Member> evaluateMemberIterable(Evaluator evaluator) {
            return this.memberListCalc.evaluateMemberList(evaluator);
        }
    }

    private static class ParameterSlotImpl
    implements ParameterSlot {
        private final Parameter parameter;
        private final int index;
        private Calc defaultValueCalc;
        private Object value;
        private Object cachedDefaultValue;

        public ParameterSlotImpl(Parameter parameter, int index) {
            this.parameter = parameter;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public Calc getDefaultValueCalc() {
            return this.defaultValueCalc;
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        private void setDefaultValueCalc(Calc calc) {
            this.defaultValueCalc = calc;
        }

        public void setParameterValue(Object value) {
            this.value = value;
        }

        public Object getParameterValue() {
            return this.value;
        }

        public void setCachedDefaultValue(Object value) {
            this.cachedDefaultValue = value;
        }

        public Object getCachedDefaultValue() {
            return this.cachedDefaultValue;
        }
    }
}

