/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.subreport;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public final class SubreportSelectionVisualPanel extends JPanel {

    private SubreportSelectionWizardPanel panel = null;
            
    /** Creates new form SubreportSelectionVisualPanel */
    public SubreportSelectionVisualPanel(SubreportSelectionWizardPanel panel) {
        initComponents();
        this.panel = panel;
        jTextFieldReportName.getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent e) {
                getPanel().fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                getPanel().fireChangeEvent();
            }

            public void changedUpdate(DocumentEvent e) {
                getPanel().fireChangeEvent();
            }
        });
    }

    @Override
    public String getName() {
        return I18n.getString("SubreportSelectionVisualPanel.Label.Name");
    }

    
    public int getSelectedSubreportType()
    {
        if (jRadioButton1.isSelected()) return 0;
        if (jRadioButton2.isSelected()) return 1;
        if (jRadioButton3.isSelected()) return 2;
        
        return 0;
    }
    
    public String getSelectedReportName()
    {
        return jTextFieldReportName.getText();
    }
    
    
    /**
     * Check if the form is well filled.
     * If there is an error, throw an exception.
     * The exception message is displayed in the wizard.
     * 
     * @throws java.lang.IllegalArgumentException
     */
    public void validateForm() throws java.lang.IllegalArgumentException
    {
        if (jRadioButton2.isSelected())
        {
            String fname = jTextFieldReportName.getText();
            File f = new File(fname);
            if (fname.trim().length() == 0 || !f.exists())
            {
                throw new IllegalArgumentException(I18n.getString("SubreportSelectionVisualPanel.Exception.ReportInvalid"));
            }
            //throw new IllegalArgumentException("Invalid report specified.");
        }
    }

    public boolean canFinish() {
        return jRadioButton3.isSelected();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();
        jPanel1 = new javax.swing.JPanel();
        jTextFieldReportName = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        jRadioButton3 = new javax.swing.JRadioButton();

        setLayout(new java.awt.GridBagLayout());

        buttonGroup1.add(jRadioButton1);
        jRadioButton1.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButton1, I18n.getString("SubreportSelectionVisualPanel.RadioButton.NewReport")); // NOI18N
        jRadioButton1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButton1StateChanged(evt);
            }
        });
        jRadioButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        add(jRadioButton1, gridBagConstraints);

        buttonGroup1.add(jRadioButton2);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButton2, I18n.getString("SubreportSelectionVisualPanel.RadioButton.UseExisRep")); // NOI18N
        jRadioButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton2ActionPerformed(evt);
            }
        });
        jRadioButton2.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButton2StateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(20, 20, 0, 0);
        add(jRadioButton2, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jTextFieldReportName.setPreferredSize(new java.awt.Dimension(300, 20));
        jTextFieldReportName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldReportNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jTextFieldReportName, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jButton1, I18n.getString("Global.Button.Browse")); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        jPanel1.add(jButton1, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 50, 0, 20);
        add(jPanel1, gridBagConstraints);

        buttonGroup1.add(jRadioButton3);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButton3, I18n.getString("SubreportSelectionVisualPanel.RadioButton.SubrElem")); // NOI18N
        jRadioButton3.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButton3StateChanged(evt);
            }
        });
        jRadioButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(20, 20, 0, 0);
        add(jRadioButton3, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jRadioButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton1ActionPerformed
        
    }//GEN-LAST:event_jRadioButton1ActionPerformed

    private void jRadioButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton2ActionPerformed
    }//GEN-LAST:event_jRadioButton2ActionPerformed

    private void jRadioButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton3ActionPerformed
    }//GEN-LAST:event_jRadioButton3ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        
        // select a jrxml file (or a jasper file...)
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileFilter(new FileFilter() {

            @Override
            public boolean accept(File f) {
                if (f.isDirectory() ||
                    f.getName().toLowerCase().endsWith(".jrxml") ||
                    f.getName().toLowerCase().endsWith(".jasper"))
                {
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Jasper and JRXML files (.jasper, .jrxml)";
            }
        });

        String dir = IReportManager.getPreferences().get("subreports_default_dir", null);
        File dirFile = Misc.findStartingDirectory();

        if (dir != null)
        {
            File f = new File(dir);
            if (f.exists())
            {
                dirFile = f;
            }
        }
        
        fileChooser.setCurrentDirectory(dirFile);

        int status = fileChooser.showOpenDialog(this);
        if (status == JFileChooser.APPROVE_OPTION) {
             File selectedFile = fileChooser.getSelectedFile();
             jTextFieldReportName.setText(selectedFile.getPath());
             if (selectedFile.exists())
             {
                IReportManager.getPreferences().put("subreports_default_dir", selectedFile.getParent());
             }
        }
        
        // Open the file in the directory of the selected report...
        
        
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jRadioButton1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButton1StateChanged
        getPanel().updateWizardPanels();
        getPanel().fireChangeEvent();
    }//GEN-LAST:event_jRadioButton1StateChanged

    private void jRadioButton2StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButton2StateChanged
        getPanel().updateWizardPanels();
        getPanel().fireChangeEvent();
    }//GEN-LAST:event_jRadioButton2StateChanged

    private void jRadioButton3StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButton3StateChanged
        getPanel().updateWizardPanels();
        getPanel().fireChangeEvent();
    }//GEN-LAST:event_jRadioButton3StateChanged

    private void jTextFieldReportNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldReportNameActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldReportNameActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JRadioButton jRadioButton3;
    private javax.swing.JTextField jTextFieldReportName;
    // End of variables declaration//GEN-END:variables

    public SubreportSelectionWizardPanel getPanel() {
        return panel;
    }

    public void setPanel(SubreportSelectionWizardPanel panel) {
        this.panel = panel;
    }
}

