@ECHO OFF
ECHO Simple batch file to compile isapnp using Borland C/C++ 3.1 (Turbo C/C++ 3.0)
ECHO Set CC prior to executing to bcc or tcc, eg set CC=bcc or set CC=tcc
ECHO you should include INCLUDE directories if needed (-I c:\bc\include)
ECHO NOTE: all *.obj and *.lib files are removed before compile is attempted!
ECHO You may safely ignore the warnings about parameter/value never used.
ECHO .
ECHO Press ctrl-C to cancel or
pause

set CC=nwsc
set AA=nwsa
REM set NWSLIB=c:\cvswork\nwsos\lib
REM set NWSINC=c:\cvswork\nwsos\include


REM tlib (and possibly other tools) can't handle a dash in name

REM change to src directory (or copy makeDOSr.bat to src dir & comment out CD)
CD src

if %CC%!==! goto nocompiler

REM set CFLAGS=-DHAVE_CONFIG_H -ml
set INCLUDES=-i=%NWSINC% -i=../include

set CFLAGS=-d:HAVE_CONFIG_H
set AFLAGS=-s -pl -l -coff

REM JIvV
set NLOPT=-nostub -subsystem:smart -m -libpath:%NWSLIB% -dosseg -order:_TEXT,_DATA,CONST,_BSS,_STACK startup.obj baseimp.lib
REM #JR}h
set NWSL=nwsl


ECHO Removing any object, library, map, and executable (exe) files in current directory 
del *.obj
del *.asm
del *.lib
del *.map
del *.exe

ECHO Compiling...
REM split into multiple compiles due to command line limits
%CC% %INCLUDES% %CFLAGS% callback.c 
%CC% %INCLUDES% %CFLAGS% cardinfo.c 
%CC% %INCLUDES% %CFLAGS% getopt.c 
%CC% %INCLUDES% %CFLAGS% getopt1.c 
%CC% %INCLUDES% %CFLAGS% iopl.c
%CC% %INCLUDES% %CFLAGS% mysnprtf.c 
%CC% %INCLUDES% %CFLAGS% isapnp.c 
%CC% %INCLUDES% %CFLAGS% pnp_acce.c 
%CC% %INCLUDES% %CFLAGS% pnpdump.c
%CC% %INCLUDES% %CFLAGS% pnp_sele.c 
%CC% %INCLUDES% %CFLAGS% realtime.c 
%CC% %INCLUDES% %CFLAGS% release.c 
%CC% %INCLUDES% %CFLAGS% res_acce.c
%CC% %INCLUDES% %CFLAGS% resource.c 
REM %CC% %INCLUDES% -pdd %CFLAGS% isapnp_m.c > isapnp_m.c.txt
%CC% %INCLUDES% %CFLAGS% isapnp_m.c
%CC% %INCLUDES% %CFLAGS% pnpdumpm.c

%CC% %INCLUDES% %CFLAGS% strdup.c
%CC% %INCLUDES% %CFLAGS% usleep.c

%AA% %AFLAGS% callback.asm 
%AA% %AFLAGS% cardinfo.asm 
%AA% %AFLAGS% getopt.asm 
%AA% %AFLAGS% getopt1.asm 
%AA% %AFLAGS% iopl.asm
%AA% %AFLAGS% mysnprtf.asm 
%AA% %AFLAGS% isapnp.asm 
%AA% %AFLAGS% pnp_acce.asm 
%AA% %AFLAGS% pnpdump.asm
%AA% %AFLAGS% pnp_sele.asm 
%AA% %AFLAGS% realtime.asm 
%AA% %AFLAGS% release.asm 
%AA% %AFLAGS% res_acce.asm
%AA% %AFLAGS% resource.asm 
%AA% %AFLAGS% isapnp_m.asm  
%AA% %AFLAGS% pnpdumpm.asm

%AA% %AFLAGS% strdup.asm
%AA% %AFLAGS% usleep.asm

%AA% %AFLAGS% asm/aintr.asm

ECHO Making initial lib (all obj files common to isapnp and pnpdump)
REM provides the library and useful for splitting into multiple command lines
nwslib -c isapnp.lib +callback.obj +iopl.obj +pnp_acce.obj +res_acce.obj +realtime.obj +cardinfo.obj +pnp_sele.obj +resource.obj +mysnprtf.obj +release.obj +getopt.obj +getopt1.obj +isapnp_m.obj +strdup.obj +usleep.obj +asm/aintr.obj
REM tlib isapnp.lib /C +callback.obj +iopl.obj +pnp_acce.obj +res_acce.obj +realtime.obj
REM nwslib isapnp.lib +cardinfo.obj +pnp_sele.obj +resource.obj +mysnprtf.obj +release.obj

REM tlib isapnp.lib /C +cardinfo.obj +pnp_sele.obj +resource.obj +mysnprtf.obj +release.obj
REM nwslib isapnp.lib +getopt.obj +getopt1.obj
REM tlib isapnp.lib /C +getopt.obj +getopt1.obj
REM copy isapnp.lib pnpdump.lib > nul

ECHO Making isapnp.lib  (libisapnp.a)
REM nwslib isapnp.lib +isapnp_m.obj +strdup.obj +usleep.obj
REM tlib isapnp.lib /C +isapnp_m.obj 
del isapnp.bak

ECHO Making pnpdump.lib  (libpnpdump.a)
nwslib -c pnpdump.lib +pnpdumpm.obj
REM tlib pnpdump.lib /C +pnpdumpm.obj
del pnpdump.bak


ECHO Linking executables (isapnp.exe and pnpdump.exe)
%NWSL% %NLOPT% -fe:isapnp.exe isapnp.obj nwsos.lib widget.lib isapnp.lib
%NWSL% %NLOPT% -fe:pnpdump.exe pnpdump.obj nwsos.lib widget.lib pnpdump.lib isapnp.lib

:cleanup
del *.obj

goto done

:nocompiler
ECHO you must set CC prior to executing this batch file.

:done
ECHO done

REM change back to original directory (comment out if compile.bat in src)
CD ..
