/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /cvsroot/oss-nwsos/nezumi/ports/isapnptools/src/isapnp_m.c,v 1.4 2005/06/02 16:11:00 syassy Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


// nwsos
#include <malloc.h>
#include "strdup.h"
#include "usleep.h"

/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)


#define yywrap() 1
#define YY_SKIP_YYWRAP
typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 91
#define YY_END_OF_BUFFER 92
static yyconst short int yy_accept[431] =
    {   0,
       87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,   92,   89,   87,   88,   86,    1,    2,   89,
       89,   89,   89,   89,   89,   29,   89,   33,   89,   89,
       89,   89,   89,   89,   56,   89,   58,   89,   89,   89,
       89,   65,   89,   89,   89,   89,   72,   89,   89,   75,
       89,   89,   78,   89,   84,   89,   19,   43,   28,   27,

       32,   31,   46,   44,   45,   48,   47,   50,   49,   42,
       41,   52,   51,   55,   54,   54,   83,   82,   89,   87,
       88,   86,   21,   20,   89,   89,   89,   26,   87,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   35,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   45,   47,   49,   51,   54,    0,    0,   90,
       87,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   30,   40,   37,   38,   36,
        0,   39,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,   53,    0,
        0,    0,    0,    0,    0,    0,    0,   17,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   57,    0,    0,
       63,    0,    0,    0,   71,    0,    0,   74,    0,   76,
       77,   81,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    3,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   60,   60,
       64,    0,   62,   62,    0,   67,   67,    0,    0,    0,
        0,    0,   80,   80,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,   34,    0,    0,    0,   70,    0,
       69,   69,    0,    0,   85,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   15,    0,    0,
        0,    0,   59,   61,   66,    0,    0,   79,    0,    0,
       22,    0,    0,    0,    0,    0,    0,    5,    0,    0,
        0,    0,    0,    0,    0,    6,    0,   68,    0,   73,
       25,    0,    0,   23,    0,   24,    0,    0,    0,   12,
        0,   14,   14,    4,    0,    0,    0,    9,    9,    0,
        0,    6,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   11,   11,   18,    0,    0,   13,

        0,    0,    8,    0,    0,    0,   15,    0,   10,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    7,    0,    0,   16,    0,    7,    0,    0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    1,    1,    1,    1,    6,
        7,    8,    9,    1,   10,    1,   11,   12,   13,   13,
       13,   13,   13,   13,   13,   13,   13,    1,    1,    1,
        1,    1,    1,   14,   16,   17,   18,   19,   20,   21,
       22,   23,   24,   14,   25,   26,   27,   28,   29,   30,
       31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
       14,   15,   14,   14,   14,    1,   16,   17,   18,   19,

       20,   21,   22,   23,   24,   14,   25,   26,   27,   28,
       29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
       39,   40,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[41] =
    {   0,
        1,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    3,    3,    4,    4,    5,    5,    5,    5,    5,
        5,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4
    } ;

static yyconst short int yy_base[453] =
    {   0,
        0,    5,   10,    0,   17,   28,   53,    0,   34,   46,
       84,    0,  111,  140,   45,   66,   86,   91,  115,  119,
       63,  157,  148,  169,  175,  183,  189,  195,  201,  207,
      213,  225,  237,  249,  261,  273,  285,  323,  361,  373,
      385,  397,  291,  297,   92,  137,  303,  309,  315,  330,
      338,  345,  834,  835,  831,  835,  835,  835,  835,   11,
      812,  101,  811,  810,  813,  835,  809,  835,  809,  799,
       77,  805,  808,  803,  835,  802,  835,  805,  797,  799,
      794,  835,  801,  787,  795,  784,  835,  790,  792,  835,
      779,  790,  835,    3,  835,  780,  835,  835,  835,  835,

      835,  835,  835,  835,   13,  835,   99,  835,  118,  835,
      835,  835,  153,  835,  209,  156,  835,  835,  805,  221,
      835,  804,  835,  835,  779,   42,  785,  835,  802,  775,
      774,  784,  780,  771,  769,  781,  764,  771,  233,  760,
      777,  758,  835,  764,  763,  767,  768,  754,  766,  765,
      744,  750,  763,  761,  750,  763,  758,  746,  756,  755,
      749,  754,  221,  245,  247,  257,  259,    0,  769,  835,
      279,  755,  334,  739,  742,  747,  357,  732,  738,  736,
      738,  744,   21,  728,  381,  271,  835,  835,  835,  835,
      741,  835,  735,  739,  740,  732,  736,  735,  734,  728,

      732,  723,  725,  393,  724,  723,  727,  726,    0,  405,
      409,  729,  728,  411,  413,   33,  415,  309,  721,  708,
      709,  724,  709,  709,  716,  715,  417,  835,  441,  699,
      835,  449,  453,  420,  835,  689,  690,  835,  456,  369,
      835,  835,  461,  468,  473,  699,  696,  673,  672,  477,
      682,  679,  479,  676,  673,  664,  659,  835,  651,  637,
      622,  626,  621,  614,  623,  436,  646,  483,  471,  412,
      835,  489,  475,  423,  505,  477,  491,  503,   47,  509,
      629,  521,  513,  515,  527,    1,  614,  609,  620,  601,
      581,  560,  551,  547,  541,  556,  545,  538,  515,  487,

      475,  471,  461,  468,  835,    0,    0,    0,  835,  529,
      526,  531,  441,    0,  835,  444,  421,  421,  421,  425,
      405,  415,  401,  369,  355,  338,  333,  543,  324,  322,
      334,  321,    0,    0,    0,    0,  545,    0,  318,  307,
      835,  295,  293,  283,  275,  271,  269,  835,  557,  259,
      550,  239,  221,  569,  209,  547,  221,    0,  575,  542,
      835,  201,  195,  835,  183,  835,  177,  560,  581,  835,
      178,  578,  583,  835,  173,  169,  595,  587,  589,  601,
      603,  835,  148,  161,  159,  157,  607,    0,  134,    0,
      145,  123,    0,  609,  605,  607,  835,    0,  103,    0,

       95,  105,    0,    0,    0,   86,  835,   75,    0,    0,
       84,   56,    0,   54,   47,    0,  624,    3,  630,   46,
      625,  139,  835,  636,  611,  632,  323,  357,  643,  835,
      658,  663,  668,  671,  676,  679,  682,  685,  688,  691,
      695,  697,  700,  703,  705,  708,  711,  714,  717,  720,
      725,  730
    } ;

static yyconst short int yy_def[453] =
    {   0,
      431,  431,  431,    3,  431,  431,  431,    7,  431,  431,
      431,   11,   11,   11,   11,   11,   11,   11,   11,   11,
      431,  431,  431,  431,  431,  431,  431,  431,  431,  431,
      431,  431,  431,  431,  431,  431,  431,  431,  431,  431,
      431,  431,  431,  431,  432,  432,  431,  431,  431,  431,
      431,  431,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,

      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  433,  433,
      430,  433,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  434,  433,  430,
      433,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,

      430,  430,  430,  430,  430,  430,  430,  430,  434,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  435,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,

      430,  430,  430,  435,  430,  436,  437,  438,  430,  430,
      430,  430,  430,  439,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  436,  437,  438,  440,  430,  439,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  440,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  441,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  441,  442,  430,  443,
      430,  430,  444,  430,  430,  430,  430,  445,  430,  443,

      430,  430,  444,  446,  447,  430,  430,  430,  446,  448,
      430,  430,  449,  430,  430,  450,  430,  430,  430,  451,
      430,  451,  430,  452,  430,  430,  451,  451,  452,    0,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430
    } ;

static yyconst short int yy_nxt[876] =
    {   0,
      430,   55,   56,  430,   57,   58,   55,   56,  430,   57,
       58,   55,   56,  421,   57,  430,   59,  430,   55,   56,
      315,   57,  160,   66,  163,  163,  315,   60,   61,   55,
       56,  161,   57,   62,   66,   55,   56,  224,   57,  130,
       75,   63,   67,  131,  225,   64,   65,   55,   56,  423,
       57,   87,   75,   67,   55,   56,  256,   57,  257,   68,
      424,   54,   88,   76,   55,   56,  407,   57,   69,   95,
      173,   70,   87,  174,   89,   76,   71,   54,  309,   72,
       73,  309,   54,   88,   74,   55,   56,  417,   57,   96,
       77,  415,   90,  120,  121,   89,  122,   90,   54,  414,

       78,   79,   54,   54,  142,  143,  412,   54,   54,   91,
      164,  164,  411,   80,   91,   92,   81,   82,   54,  133,
       92,   93,  134,   54,  408,   93,  407,   83,   54,  165,
      165,   54,   54,  135,  406,   54,   54,   84,  120,  121,
       85,  122,  423,   54,   94,   86,   82,   54,   94,   55,
       56,   54,   57,  424,   97,  402,   83,   54,   55,   56,
      401,   57,  399,   95,  166,  166,   84,  167,  167,   85,
       55,   56,   54,   57,   86,   97,   55,   56,  366,   57,
      364,   98,  361,   96,   55,   56,  397,   57,  392,   98,
       55,   56,  391,   57,   99,  100,   55,   56,  389,   57,

       99,  100,   55,   56,  386,   57,  101,  102,   55,   56,
      385,   57,  101,  102,   55,   56,  341,   57,  103,  104,
      167,  167,  171,  170,  105,  105,   55,   56,  384,   57,
      103,  104,  163,  163,  185,  185,  105,  105,   55,   56,
      383,   57,  106,   98,  186,  186,  168,  380,  107,  107,
       55,   56,  376,   57,  106,   98,  164,  164,  165,  165,
      107,  107,   55,   56,  375,   57,  108,   98,  166,  166,
      167,  167,  109,  109,   55,   56,  374,   57,  108,   98,
      171,  170,  186,  186,  109,  109,   55,   56,  368,   57,
      110,   98,   55,   56,  367,   57,  117,  118,   55,   56,

      366,   57,  117,  118,   55,   56,  365,   57,  123,  124,
       55,   56,  111,   57,  123,  124,   55,   56,  364,   57,
      218,  218,  363,  111,   55,   56,  423,   57,  110,   98,
      362,   55,   56,  125,   57,  211,  211,  424,  126,   55,
       56,  127,   57,  361,  128,  357,   55,   56,  125,   57,
      111,  128,  356,  126,  212,  355,  127,  354,  217,  217,
      423,  111,   55,   56,  350,   57,  112,   98,  218,  218,
      213,  424,  113,  113,   55,   56,  349,   57,  112,   98,
      240,  240,  185,  185,  113,  113,   55,   56,  348,   57,
      114,   98,  186,  186,  239,  239,  115,  116,   55,   56,

      347,   57,  114,   98,  240,  240,  245,  245,  115,  116,
      211,  211,  250,  250,  253,  253,  217,  217,  266,  266,
      267,  278,  278,  270,  270,  246,  218,  218,  346,  212,
      345,  251,  344,  254,  274,  274,  279,  266,  266,  267,
      343,  247,  268,  268,  342,  213,  341,  252,  340,  255,
      272,  272,  269,  270,  275,  275,  279,  239,  239,  339,
      273,  274,  282,  282,  276,  277,  337,  240,  240,  285,
      285,  305,  283,  284,  245,  245,  286,  286,  250,  250,
      253,  253,  270,  270,  268,  268,  274,  274,  277,  277,
      272,  272,  332,  246,  269,  270,  331,  251,  330,  254,

      273,  274,  277,  277,  278,  278,  275,  275,  306,  247,
      310,  310,  307,  252,  308,  255,  276,  277,  329,  279,
      311,  312,  282,  282,  284,  284,  284,  284,  285,  285,
      310,  310,  283,  284,  328,  286,  286,  312,  312,  279,
      311,  312,  312,  312,  351,  351,  359,  359,  381,  381,
      314,  351,  351,  360,  360,  327,  360,  360,  369,  369,
      352,  387,  387,  336,  370,  326,  371,  352,  372,  373,
      377,  377,  353,  325,  382,  324,  359,  359,  323,  353,
      378,  379,  369,  369,  322,  382,  360,  360,  370,  373,
      373,  321,  372,  373,  373,  373,  377,  377,  379,  379,

      379,  379,  394,  394,  381,  381,  378,  379,  387,  387,
      394,  394,  395,  396,  320,  390,  396,  396,  396,  396,
      395,  396,  426,  426,  393,  419,  419,  420,  319,  425,
      382,  419,  419,  420,  425,  318,  426,  426,  422,  428,
      317,  382,  404,  426,  426,  422,  428,  316,  313,  305,
      429,  303,  302,  301,  300,  299,  298,  429,   54,   54,
       54,   54,   54,  119,  119,  119,  119,  119,  169,  169,
      169,  169,  169,  209,  297,  209,  304,  304,  304,  304,
      304,  333,  296,  333,  334,  295,  334,  335,  294,  335,
      338,  293,  338,  358,  292,  358,  388,  291,  388,  388,

      398,  398,  400,  290,  400,  403,  289,  403,  405,  405,
      409,  288,  409,  410,  287,  410,  413,  281,  413,  416,
      280,  416,  418,  271,  418,  422,  422,  422,  422,  422,
      427,  427,  427,  427,  427,  265,  264,  263,  262,  261,
      260,  259,  258,  249,  248,  244,  243,  242,  241,  238,
      237,  236,  235,  234,  233,  232,  231,  230,  229,  228,
      227,  226,  223,  222,  221,  220,  219,  216,  215,  214,
      210,  170,  208,  207,  206,  205,  204,  203,  202,  201,
      200,  199,  198,  197,  196,  195,  194,  193,  192,  191,
      190,  189,  188,  187,  184,  183,  182,  181,  180,  179,

      178,  177,  176,  129,  175,  172,  170,  170,  162,  159,
      158,  157,  156,  155,  154,  153,  152,  151,  150,  149,
      148,  147,  146,  145,  144,  141,  140,  139,  138,  137,
      136,  132,  129,  430,   53,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430
    } ;

static yyconst short int yy_chk[876] =
    {   0,
        0,    1,    1,    0,    1,    1,    2,    2,    0,    2,
        2,    3,    3,  418,    3,    0,    3,    0,    5,    5,
      286,    5,   94,    5,  105,  105,  286,    3,    3,    6,
        6,   94,    6,    3,    6,    9,    9,  183,    9,   60,
        9,    3,    5,   60,  183,    3,    3,   10,   10,  420,
       10,   15,   10,    6,    7,    7,  216,    7,  216,    7,
      420,   15,   15,    9,   21,   21,  415,   21,    7,   21,
      126,    7,   16,  126,   15,   10,    7,   15,  279,    7,
        7,  279,   16,   16,    7,   11,   11,  414,   11,   21,
       11,  412,   17,   45,   45,   16,   45,   18,   16,  411,

       11,   11,   17,   17,   71,   71,  408,   18,   18,   17,
      107,  107,  406,   11,   18,   17,   11,   13,   17,   62,
       18,   19,   62,   18,  402,   20,  401,   13,   13,  109,
      109,   19,   19,   62,  399,   20,   20,   13,   46,   46,
       13,   46,  422,   13,   19,   13,   14,   19,   20,   23,
       23,   20,   23,  422,   23,  392,   14,   14,   22,   22,
      391,   22,  389,   22,  113,  113,   14,  116,  116,   14,
       24,   24,   14,   24,   14,   24,   25,   25,  386,   25,
      385,   25,  384,   22,   26,   26,  383,   26,  376,   26,
       27,   27,  375,   27,   27,   27,   28,   28,  371,   28,

       28,   28,   29,   29,  367,   29,   29,   29,   30,   30,
      365,   30,   30,   30,   31,   31,  363,   31,   31,   31,
      115,  115,  120,  120,   31,   31,   32,   32,  362,   32,
       32,   32,  163,  163,  139,  139,   32,   32,   33,   33,
      357,   33,   33,   33,  139,  139,  115,  355,   33,   33,
       34,   34,  353,   34,   34,   34,  164,  164,  165,  165,
       34,   34,   35,   35,  352,   35,   35,   35,  166,  166,
      167,  167,   35,   35,   36,   36,  350,   36,   36,   36,
      171,  171,  186,  186,   36,   36,   37,   37,  347,   37,
       37,   37,   43,   43,  346,   43,   43,   43,   44,   44,

      345,   44,   44,   44,   47,   47,  344,   47,   47,   47,
       48,   48,   37,   48,   48,   48,   49,   49,  343,   49,
      218,  218,  342,   37,   38,   38,  427,   38,   38,   38,
      340,   50,   50,   49,   50,  173,  173,  427,   49,   51,
       51,   49,   51,  339,   51,  332,   52,   52,   50,   52,
       38,   52,  331,   50,  173,  330,   50,  329,  177,  177,
      428,   38,   39,   39,  327,   39,   39,   39,  177,  177,
      173,  428,   39,   39,   40,   40,  326,   40,   40,   40,
      240,  240,  185,  185,   40,   40,   41,   41,  325,   41,
       41,   41,  185,  185,  204,  204,   41,   41,   42,   42,

      324,   42,   42,   42,  204,  204,  210,  210,   42,   42,
      211,  211,  214,  214,  215,  215,  217,  217,  227,  227,
      227,  234,  234,  270,  270,  210,  217,  217,  323,  211,
      322,  214,  321,  215,  274,  274,  234,  266,  266,  266,
      320,  210,  229,  229,  319,  211,  318,  214,  317,  215,
      232,  232,  229,  229,  233,  233,  234,  239,  239,  316,
      232,  232,  243,  243,  233,  233,  313,  239,  239,  244,
      244,  304,  243,  243,  245,  245,  244,  244,  250,  250,
      253,  253,  269,  269,  268,  268,  273,  273,  276,  276,
      272,  272,  303,  245,  268,  268,  302,  250,  301,  253,

      272,  272,  277,  277,  278,  278,  275,  275,  269,  245,
      280,  280,  273,  250,  276,  253,  275,  275,  300,  278,
      280,  280,  282,  282,  283,  283,  284,  284,  285,  285,
      310,  310,  282,  282,  299,  285,  285,  311,  311,  278,
      310,  310,  312,  312,  328,  328,  337,  337,  356,  356,
      283,  351,  351,  360,  360,  298,  337,  337,  349,  349,
      328,  368,  368,  311,  349,  297,  349,  351,  349,  349,
      354,  354,  328,  296,  356,  295,  359,  359,  294,  351,
      354,  354,  369,  369,  293,  356,  359,  359,  369,  372,
      372,  292,  369,  369,  373,  373,  377,  377,  378,  378,

      379,  379,  380,  380,  381,  381,  377,  377,  387,  387,
      394,  394,  380,  380,  291,  372,  395,  395,  396,  396,
      394,  394,  425,  425,  378,  417,  417,  417,  290,  421,
      381,  419,  419,  419,  421,  289,  421,  421,  424,  424,
      288,  381,  395,  426,  426,  429,  429,  287,  281,  267,
      424,  265,  264,  263,  262,  261,  260,  429,  431,  431,
      431,  431,  431,  432,  432,  432,  432,  432,  433,  433,
      433,  433,  433,  434,  259,  434,  435,  435,  435,  435,
      435,  436,  257,  436,  437,  256,  437,  438,  255,  438,
      439,  254,  439,  440,  252,  440,  441,  251,  441,  441,

      442,  442,  443,  249,  443,  444,  248,  444,  445,  445,
      446,  247,  446,  447,  246,  447,  448,  237,  448,  449,
      236,  449,  450,  230,  450,  451,  451,  451,  451,  451,
      452,  452,  452,  452,  452,  226,  225,  224,  223,  222,
      221,  220,  219,  213,  212,  208,  207,  206,  205,  203,
      202,  201,  200,  199,  198,  197,  196,  195,  194,  193,
      191,  184,  182,  181,  180,  179,  178,  176,  175,  174,
      172,  169,  162,  161,  160,  159,  158,  157,  156,  155,
      154,  153,  152,  151,  150,  149,  148,  147,  146,  145,
      144,  142,  141,  140,  138,  137,  136,  135,  134,  133,

      132,  131,  130,  129,  127,  125,  122,  119,   96,   92,
       91,   89,   88,   86,   85,   84,   83,   81,   80,   79,
       78,   76,   74,   73,   72,   70,   69,   67,   65,   64,
       63,   61,   55,   53,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
      430,  430,  430,  430,  430
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
// #line 1 "isapnp_main.l"
#define INITIAL 0
// #line 3 "isapnp_main.l"
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_GETOPT_LONG
#include <getopt.h>
#else
/* If not in library, use our own version */
#include "getopt.h"
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <time.h>
#include <isapnp/release.h>
#include <isapnp/errenum.h>
#ifdef HAVE_SFN
#include <isapnp/callback.h>
#include <isapnp/res_acce.h>
#else
#include <isapnp/callbacks.h>
#include <isapnp/res-access.h>
#endif
#include <isapnp/resource.h>

/*
 * Define this if you always want board configuration output
 * (normally you add the (NAME "..") keyword before (ACT .)
 *
 */
/* #define ALWAYSREPORTACTIVATION */

#undef RELEASE_ALWAYSREPACT
#ifdef ALWAYSREPORTACTIVATION
#define RELEASE_ALWAYSREPACT " -DALWAYSREPORTACTIVATION"
#else
#define RELEASE_ALWAYSREPACT ""
#endif

#include <isapnp/iopl.h>
#include <isapnp/pnp.h>

static char rcsid[] = "$Id: isapnp_m.c,v 1.4 2005/06/02 16:11:00 syassy Exp $";

#ifdef REALTIME
#include <isapnp/realtime.h>
static long l_realtime_timeout = 5L;
#else
#define delaynus(x) usleep(x)
#endif /* REALTIME */

static int ignorecrc = 0;
static int debug = 0; /* debugging information (independent of verbosity) */

/*
 * verbosity: The higher, the more gets printed
 * 0 - absolutely nothing
 * 1 - PEEKs
 * 2 - configuration confirmation on ACT
 * 3 - board identification on IDENTIFY
 */
static int verbosity = 3;

static char *filename; /* For error reports */
static int linenumber = 1; /* For error reports */
static int sent_key = 0;
static char * identifyformat = "Board %b has Identity %8 %7 %6 %5 %4 %3 %2 %1 %0:  %v Serial No %s [checksum %8]\n";

/*
 * The scanner produces a list of actions, in the form of a function
 * pointer and a string argument
 */
typedef struct action
{
	int (*fn)(char *);
	char *name;
	char *arg;
	int linenum;
	int jumponerror;
} ACTION, *ACTIONPTR;

#define ADDACTIONS 100

static ACTION *actions = (ACTION *)0;
static int maxactions = 0;
static int nextaction = 0;
static int configureaction = 0; /* Backwards reference to skip missing boards */

static int parseerror = 0;

#ifndef HAVE_STRNCASECMP
static int strncasecmp(char *str1, char *str2, unsigned length)
{
  char *buffer1, *buffer2;
  int  counter, return_value;

  /* Allocate space for temp buffer */
  if((buffer1 = malloc(strlen(str1)+1)) == (char *)0) {
    perror("Allocating spare memory");
    exit(1);
  }
  else {
    (void)strcpy(buffer1, str1);
  }
  if((buffer2 = malloc(strlen(str2)+1)) == (char *)0) {
    perror("Allocating spare memory");
    exit(1);
  }
  else {
    (void)strcpy(buffer2, str2);
  }

  /* Decase letters to lower case */
  for(counter = 0 ; counter < strlen(str1) ; counter++)
    if(str1[counter] >= 'a')
      buffer1[counter] = (char)('A' + (str1[counter]-'a'));
  for(counter = 0 ; counter < strlen(str2) ; counter++)
    if(str2[counter] >= 'a')
      buffer2[counter] = (char)('A' + (str2[counter]-'a'));

  /* Now calculate the return value */
  return_value = strncmp(str1, str2, length);

  /* Free up the space */
  (void)free(str1);
  (void)free(str2);

  /* Now give the return value */
  return(return_value);
}
#endif /* !HAVE_STRNCASECMP */

#ifdef _OS2_
void *yy_flex_alloc(int size) 
{
  void *ptr;

  /* Allocate the space */
  if((ptr = malloc(size)) == (void *)0) {
    perror("Allocating Flex Buffer");
    exit(1);
  }

  /* Return the pointer */
  return(ptr);
}
void *yy_flex_realloc(void *ptr, int size)
{
  void *nptr;

  /* Reallocate space */
  if((nptr = realloc(ptr, size)) == (void *)0) {
    perror("ReAllocating Flex Buffer");
    exit(1);
  }

  /* Return the new pointer */
  return(nptr);
}
void yy_flex_free(void *ptr){(void)free(ptr);}
#endif /* _OS2_ */

static char *keyword = 0;

#define IORESCHECK (-1)
#define NOARG (-2)

static void
Warning(const char *str,...)
{
	va_list ap;
	fprintf(stderr, "%s:%d -- Warning - ", filename, linenumber);
	va_start(ap, str);
	vfprintf(stderr, str, ap);
	va_end(ap);
	fputc('\n', stderr);
}

/* Print Fatal of Warning message according to the flag, and return the flag */
static int
WarningOrFatal(int flag, const char *str,...)
{
	va_list ap;
	if(flag)
		fprintf(stderr, "%s:%d -- Fatal - ", filename, linenumber);
	else
		fprintf(stderr, "%s:%d -- Warning - ", filename, linenumber);
	va_start(ap, str);
	vfprintf(stderr, str, ap);
	va_end(ap);
	fputc('\n', stderr);
	return flag;
}

static void
banner(FILE *fp)
{
	fprintf(fp, 
			"%s\n"
			"Release %s\n"
			"\n"
			"This is free software, see the sources for details.\n"
			"This software has NO WARRANTY, use at your OWN RISK\n"
			"\n"
			"For details of the configuration file format, see isapnp.conf(5)\n"
			"For explanations of error messages, see isapnp(8)\n"
			"\n"
			"For latest information and FAQ on isapnp and pnpdump see:\n"
			"http://www.roestock.demon.co.uk/isapnptools/\n"
			"\n"
			"Compiler flags: %s%s\n"
			"\n",
			rcsid,
			libtoolsver,
			libcompilerflags,
			RELEASE_ALWAYSREPACT
		);
}

static void 
usage(char *program_name)
{
	banner(stderr);
	fprintf(stderr,
			"Usage: %s [OPTIONS] configfile\n\n"
			"   -h, --help            show a help summary to stderr\n"
#ifdef REALTIME
			" -t t, --max-realtime=t  maximum real-time priority execution is t seconds\n"
#endif
			"   -v, --version         print the isapnptools version number on stderr\n"
			"\n"
			"   configfile            contains the instructions to configure the boards,\n"
			"                         use - for stdin, see isapnp.conf(5)\n"
			, program_name);
	exit(0);
}

static void
getkeyword(int len)
{
	/* If the keyword wasn't used, free it */
	if(keyword)
		free(keyword);
	/* Save the keyword for errors, could have no gap to argument, if included */
	keyword = (char *)malloc(len + (size_t)1);
	strncpy(keyword, yytext, len);
	keyword[len] = 0;
}

static int
addaction(int (*fn)(char*), int skip)
{
	char *sptr = yytext+skip;
	/* Make sure there is some room */
	if(nextaction == maxactions)
	{
		maxactions += ADDACTIONS;
		actions = (ACTION *)realloc((void *)actions, sizeof(ACTION) * maxactions);
		if(!actions)
		{
			/* This is, like, fatal */
			fprintf(stderr, "%s:%d -- Fatal - Unable to allocate memory for action list processing\n", filename, linenumber);
			parseerror = 1;
			return 0;
		}
	}
	actions[nextaction].fn = fn;
	/* Jumponerror means have method to recover execution flow */
	actions[nextaction].jumponerror = 0;
	if(skip == IORESCHECK)
	{
		actions[nextaction].name = "<IORESCHECK>";
		actions[nextaction].arg = "";
		/* Save linenumber, even though we don't know what it is of ! */
		actions[nextaction].linenum = linenumber;
	}
	else
	{
		if(skip > 0)
			getkeyword(skip);
		/* Save the action name for errors, and show we've taken it */
		if(keyword)
		{
			actions[nextaction].name = keyword;
			keyword = 0;
		}
		else
			actions[nextaction].name = "";
		/* Save linenumber of keyword */
		actions[nextaction].linenum = linenumber;
		if(skip != NOARG)
		{
			/* Skip leading whitespace to argument, counting lines */
			while((*sptr) && isspace(*sptr))
			{
				if(*sptr == '\n')
					linenumber++;
				sptr++;
			}
			/* Now store a copy for the action word to process */
			if(*sptr)
				actions[nextaction].arg = strdup(sptr);
			else
				actions[nextaction].arg = "";
		}
		else
			actions[nextaction].arg = "";
	}
	nextaction++;
	return 1;
}

static int
IgnoreCRC(char *s)
{
	ignorecrc = 1;
	return 0;
}

static int
Read_Port(char *s)
{
	/* Read decimal or hex number */
	read_port = (int)strtol(s, (char**)NULL, 0);
	if((read_port < MIN_READ_ADDR)||(read_port > MAX_READ_ADDR))
	{
		fprintf(stderr, "Port address %s (0x%04x) out of range 0x203..0x3ff\n", s, read_port);
		return 1;
	}
	read_port |= 3;
	if(!allocate_resource(IOport_TAG, read_port, 1, "READPORT"))
	{
		fprintf(stderr, "Read port 0x%04X cannot be allocated - resource conflict (see %s)\n", read_port, conflict_source);
		return 1;
	}
	return 0;
}

static int
checkreadport(void)
{
	if(!read_port)
	{
		fprintf(stderr, "READPORT not set\n");
		return(1);
	}
	return(0);
}

static int
SetVerbosity(char *s)
{
	/* Read decimal or hex number */
	verbosity = (int)strtol(s, (char**)NULL, 0);
	return 0;
}

static unsigned char serial_identifier2[NUM_CARDS+1][IDENT_LEN];
static char *boardid[NUM_CARDS+1];
static unsigned long serno[NUM_CARDS+1];

static int do_isapnp_isolate(void);
static char * devidstr(unsigned char, unsigned char, unsigned char, unsigned char);
static char * sernostr(unsigned long serno);

static char initdata[INIT_LENGTH] = INITDATA;

static void
send_key(void)
{
	int i;
	CONFIGCONTROL;
	WRITE_DATA(CONFIG_WAIT_FOR_KEY);
	ADDRESS(0);
	ADDRESS(0);
	for(i = 0; i < INIT_LENGTH; i++)
		ADDRESS(initdata[i]);
	delaynus(2000L);
	sent_key = 1;
}

static int
Isolate(char *s)
{
	int i;

	send_key();
	/* Reset the cards */
	CONFIGCONTROL;
	if(toupper(*s) == 'C') /* CLEAR */
		WRITE_DATA(CONFIG_RESET_DRV);
	else /* PRESERVE */
		WRITE_DATA(CONFIG_RESET_CSN | CONFIG_WAIT_FOR_KEY);
	delaynus(2000L);
	/* Send the key again */
	send_key();
	if(boards_found)
	{
		Warning("ISOLATE called twice, or after CSN - clearing board count");
		boards_found = 0;
	}
	/* All cards now isolated, read the first one */
	if(read_port) /* Port specified */
	{
		do_isapnp_isolate();
	}
	else
	{
		for(read_port = START_READ_ADDR; read_port <= MAX_READ_ADDR; read_port += READ_ADDR_STEP)
		{
			if(debug)
				printf("Trying port address %04x\n", read_port);
			if(!allocate_resource(IOport_TAG, read_port, 1, "READPORT"))
			{
				fprintf(stderr, "Read port %04X cannot be allocated - resource conflict (see %s)\n", read_port, conflict_source);
				continue;
			}
			if(do_isapnp_isolate())
				break;
			/* Failed, so release the resource */
			deallocate_resource(IOport_TAG, read_port, 1);
			/*
			 * There is an argument that says don't release the resource in that
			 * there is obviously something there which is enabled, but we might
			 * be expecting it to be there as we want to read its settings.
			 */
			/* Reset the cards */
			CONFIGCONTROL;
			WRITE_DATA(CONFIG_RESET_DRV);
			delaynus(2000L);
			/* Send the key again */
			send_key();
		}
	}
	if(!boards_found)
		return 1; /* Error */
	if(debug)
	{
		printf("Board %d has serial identifier", boards_found);
		for(i = IDENT_LEN; i-- ; )
			printf(" %02x", serial_identifier2[boards_found][i]);
		printf(" (%s/%s)\n", boardid[boards_found], sernostr(serno[boards_found]));
	}
	while(do_isapnp_isolate())
	{
		if(debug)
		{
			printf("Board %d has serial identifier", boards_found);
			for(i = IDENT_LEN; i--; )
				printf(" %02x", serial_identifier2[boards_found][i]);
			printf(" (%s/%s)\n", boardid[boards_found], sernostr(serno[boards_found]));
		}
	}
	return 0;
}

static int
do_isapnp_isolate(void)
{
	int csum;
	int i;
	int index;
	int newbit;
	int goodaddress = 0;
	int nextboard = boards_found + 1;
	unsigned char c1, c2;
	csum = 0x6a;
	Wake(0);
	SetRdPort(read_port);
	delaynus(1000L);
	SERIALISOLATION;
	delaynus(1000L);
	for(index = 0; index < IDENT_LEN - 1; index++)
	{
		for(i = 0; i < 8; i++)
		{
			newbit = 0x00;
			/* Two reads per identifier bit */
			delaynus(250L);
			c1 = READ_DATA;
			delaynus(250L);
			c2 = READ_DATA;
			if(c1 == 0x55)
			{
				if(c2 == 0xAA)
				{
					goodaddress = 1;
					newbit = 0x80;
				}
				else
				{
					goodaddress = 0;
				}
			}
			serial_identifier2[nextboard][index] >>= 1;
			serial_identifier2[nextboard][index] |= newbit;
			/* Update checksum */
			if(((csum >> 1) ^ csum) & 1)
				newbit ^= 0x80;
			csum >>= 1;
			csum |= newbit;
		}
		/*
		printf("%02x ", serial_identifier2[nextboard][index]);
		*/
	}
	/*
	printf("csum is %02x\n", csum);
	*/
	for(i = 0; i < 8; i++)
	{
		newbit = 0x00;
		/* Two reads per identifier bit */
		delaynus(250L);
		c1 = READ_DATA;
		delaynus(250L);
		c2 = READ_DATA;
		if(c1 == 0x55)
		{
			if(c2 == 0xAA)
			{
				goodaddress = 1;
				newbit = 0x80;
			}
		}
		serial_identifier2[nextboard][index] >>= 1;
		serial_identifier2[nextboard][index] |= newbit;
	}
	if(goodaddress && (ignorecrc || (serial_identifier2[nextboard][8] == csum)))
	{
		boardid[nextboard] = strdup(devidstr(serial_identifier2[nextboard][0],
				serial_identifier2[nextboard][1], serial_identifier2[nextboard][2],
				serial_identifier2[nextboard][3])); 
		serno[nextboard] = serial_identifier2[nextboard][7] << 24;
		serno[nextboard] |= serial_identifier2[nextboard][6] << 16;
		serno[nextboard] |= serial_identifier2[nextboard][5] << 8;
		serno[nextboard] |= serial_identifier2[nextboard][4];
		boards_found = nextboard;
		CARDSELECTNUMBER;
		WRITE_DATA(nextboard);
		return(1);
	}
	/*
	else
	{
		printf("csum = %02x\n", csum);
	}
	*/
	return(0);
}

static char *
devidstr(unsigned char d1, unsigned char d2, unsigned char d3, unsigned char d4)
{
	static char resstr[] = "PNP0000";
	if(d1 & 0x80)
		return("-------");
	sprintf(resstr, "%c%c%c%x%x%x%x", 'A' + (d1 >> 2) - 1, 'A' + (((d1 & 3) << 3) | (d2 >> 5)) - 1,
	       'A' + (d2 & 0x1f) - 1, d3 >> 4, d3 & 0x0f, d4 >> 4, d4 & 0x0f);
	return resstr;
}

static char *
sernostr(unsigned long serno)
{
	static char serstr[] = "4294967294"; /* 2^32 - 2 is the max possible */
	if(serno == 0xffffffffUL)
		return "-1";
	sprintf(serstr, "%lu", serno);
	return serstr;
}

static int
ident(int csn)
{
	int i;
	unsigned char id[IDENT_LEN];
	char *fptr;
	if((csn < 1)||(csn > boards_found))
		return(1);
	fflush(stdout);
	if(checkreadport())
		return(1);
	Wake(csn);
	delaynus(250L);
	for(i = 0; i < IDENT_LEN; i++)
	{
		if(statuswait())
			return(1);
		id[i] = RESOURCEDATA;
	}
	strcpy(boardid[csn],devidstr(id[0],id[1],id[2],id[3]));
	serno[csn] = (unsigned long) id[4] + (id[5] << 8) +  (id[6] << 16) + (id[7] << 24);
	/* Display result according to format string */
	if(verbosity >= 3)
	{
		for(fptr = identifyformat; *fptr; fptr++)
		{
			switch(*fptr)
			{
			case '%':
			{
				fptr++;
				switch(*fptr)
				{
				case 'b': /* Board */ printf("%d", csn); break;
				case 'v': /* Vendor Id */ printf("%s", boardid[csn]); break;
				case 's': /* Serial number */ printf("%s", sernostr(serno[csn])); break;
				default:
					if(((i = *fptr - '0') >= 0)&&(i < 9))
						printf("%02x", id[i]);
					else
						putchar(*fptr);
					break;
				}
				break;
			}
			case '\\':
			{
				fptr++;
				switch(*fptr)
				{
				case 't': putchar('\t'); break;
				case 'n': putchar('\n'); break;
				default:  putchar(*fptr); break;
				}
				break;
			}
			default:
				putchar(*fptr);
				break;
			}
		}
		fflush(stdout);
	}
	return(0);
}

static int
Identify(char *s)
{
	int err = 0;
	int csn;
	if(*s == '*')
	{
		for(csn = 1; (!err) && (csn <= boards_found); csn++)
			err |= ident(csn);
	}
	else
	{
		csn = (int)strtol(s, (char**)NULL, 0);
		err = ident(csn);
	}
	return err;
}

static int
IdentifyFormat(char *s)
{
	identifyformat = strdup(s+1);                 /* Flex rule guarantees this removes leading " */
	identifyformat[strlen(identifyformat)-1] = 0; /* Flex rule guarantees this removes trailing " */
	return 0;
}

static int
WaitForKey(char *s)
{
	CONFIGCONTROL;
	WRITE_DATA(CONFIG_WAIT_FOR_KEY);
	return 0;
}

static int csn;

static int
SelectCSN(char *s)
{
	if(!sent_key)
		send_key();
	csn = (unsigned int)strtol(s, (char**)NULL, 0);
	/* Check it's sensible, and we won't have array problems */
	if((csn < 1)||(csn > NUM_CARDS))
		return 1;
	if(csn > boards_found)
	{
		for(boards_found++; csn >= boards_found; boards_found++)
			boardid[boards_found] = strdup("-------");
		boards_found = csn;
	}
	if(checkreadport())
		return(1);
	Wake(csn);
	return 0;
}

static int
SelectIdent(char *s)
{
	unsigned long sn;
	if(s[8] == '#')
	{
		/* Specify nth card, rather than serial number */
		sn = (unsigned int)strtol(s+9, (char**)NULL, 0);
		for(csn = 1; csn <= boards_found; csn++)
			if((strncasecmp(s, boardid[csn], 7) == 0)&&(!(--sn)))
				break;
	}
	else
	{
		if(s[8] == '-') /* For the special case -1 */
			sn = (unsigned long)strtol(s+8, (char**)NULL, 0);
		else
			sn = strtoul(s+8, (char**)NULL, 0);
		for(csn = 1; csn <= boards_found; csn++)
			if((serno[csn] == sn)&&(strncasecmp(s, boardid[csn], 7) == 0))
				break;
	}
	if((csn < 1)||(csn > boards_found))
	{
		if(verbosity >= 3)
			printf("Board %s not found - skipping\n", s);
		return(1);
	}
	if(debug)
		printf("Found board %s as Card Select Number %d\n", s, csn);
	if(checkreadport())
		return(1);
	Wake(csn);
	return 0;
}

/*
 * Misc global register setting
 */

static int verifyld = 1;
static int LogDev;
static char *LDName = (char *)0;

#ifdef ALWAYSREPORTACTIVATION
#define DEFNAMELEN (7+1+10+5+1) /* Vendor/Serno[LD] */
static char LDdefname[DEFNAMELEN];
#endif

/* Store logical device settings for confirmation printout */
#define NOOFIODESCS 8
#define IONOTASSIGNED -1
static int LDios[NOOFIODESCS];
#define NOOFINTDESCS 2
#define INTNOTASSIGNED 0
static int LDints[NOOFINTDESCS];
#define NOOFDMADESCS 2
#define DMANOTASSIGNED 4
static int LDdmas[NOOFDMADESCS];

static int
SetLogicalDevice(char *s)
{
	int retval;
	int i;
	LogDev = (int)strtol(s, (char**)NULL, 0);
	LOGICALDEVICENUMBER;
	WRITE_DATA(LogDev);
#ifdef ALWAYSREPORTACTIVATION
	sprintf(LDdefname, "%s/%s[%d]", boardid[csn], sernostr(serno[csn]), LogDev);
	LDName = LDdefname;
#else
	LDName = 0;
#endif
	for(i = 0; i < NOOFIODESCS; i++)
		LDios[i] = IONOTASSIGNED;
	for(i = 0; i < NOOFINTDESCS; i++)
		LDints[i] = INTNOTASSIGNED;
	for(i = 0; i < NOOFDMADESCS; i++)
		LDdmas[i] = DMANOTASSIGNED;
	retval = (verifyld)&&(READ_DATA != LogDev);
	if(retval)
		fprintf(stderr, "LD setting verify failed, this may not be a problem\n"
			"Try adding (VERIFYLD N) to the top of your script\n");
	return retval;
}

static int
VerifyLD(char *s)
{
	while((*s)&&(isspace(*s)))
		s++;
	if((*s)&&(toupper(*s) == 'N'))
		verifyld = 0;
	else
		verifyld = 1;
	return 0;
}

static int
SetLDName(char *s)
{
	char *d;
	while((*s)&&(isspace(*s)))
		s++;
	if(*s == '"')
		s++;
	LDName = d = s;
	/* Process string removing escapes */
	while((*s)&&(*s != '"'))
	{
		if(*s == '\\')
		{
			s++;
			switch(*s)
			{
			case 0: break;
			case 'n': *d++ = '\n'; break;
			case 't': *d++ = '\t'; break;
			case 'f': *d++ = '\f'; break;
			case 'a': *d++ = '\a'; break;
			default:  *d++ = *s;   break;
			}
			s++;
			continue;
		}
		*d++ = *s++;
	}
	*d = 0;
	return 0;
}

/*
 * Register address, etc, for peek and poke
 */
#define MAXNAMELEN 16
#define MAXREGSIZE 8 /* MemReg */

static int Reg = 0;
static int RegSize = 0;
static char RegName[MAXNAMELEN] = {0};

static int
Activate(char *s)
{
	ACTIVATE;
	if(toupper(*s) == 'Y')
		WRITE_DATA(1);
	else
		WRITE_DATA(0);
	if((verbosity >= 2)&&(LDName))
	{
		int ios = 0;
		int i;
		printf("%s:", LDName);
		for(i = 0; i < NOOFIODESCS; i++)
			if(LDios[i] != IONOTASSIGNED)
				ios++;
		if(ios)
		{
			printf(" Port%s", ios > 1 ? "s" : "");
			for(i = 0; i < NOOFIODESCS; i++)
				if(LDios[i] != IONOTASSIGNED)
					printf(" 0x%X", LDios[i]);
			putchar(';');
		}
		for(i = 0; i < NOOFINTDESCS; i++)
			if(LDints[i] != INTNOTASSIGNED)
				printf(" IRQ%d", LDints[i]);
		for(i = 0; i < NOOFDMADESCS; i++)
			if(LDdmas[i] != DMANOTASSIGNED)
				printf(" DMA%d", LDdmas[i]);
		printf(" --- %s\n", toupper(*s) == 'Y' ? "Enabled OK" : "Disabled");
		fflush(stdout);
	}
	return 0;
}

static int
SelectAct(char *s)
{
	Reg = 0x30;
	RegSize = 1;
	strcpy(RegName, "ACT  ");
	return 0;
}

/*
 * Interrupt resource setting
 */

static int INTReg = 0;
static int IRQConflictIsFatal = 0;

static int
SelectINTReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n >= NOOFINTDESCS))
		return 1;
	INTReg = n;
	Reg = 0x70 + (n << 1);
	RegSize = 2;
	strcpy(RegName, "INT 0");
	RegName[4] = n + '0';
	return 0;
}

static int
SetIRQLine(char *s)
{
	int n;
	int retval = 0;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 15))
		return 1;
	if(n == 2)
	{
		Warning("IRQ2 is not a valid selection, changing it to IRQ9 (See clarifications 4.6.2)");
		n = 9;
	}
	if(!allocate_resource(IRQ_TAG, n, 1, filename))
		retval = WarningOrFatal(IRQConflictIsFatal, "resource conflict allocating IRQ%d (see %s)", n, conflict_source);
	ADDRESS(0x70 + (INTReg << 1));
	WRITE_DATA(n);
	LDints[INTReg] = n;
	return retval;
}

static int
SetIRQMode(char *s)
{
	int n = 0;
	if(*s++ == '+')
		n |= 2;
	if(toupper(*s) == 'L')
		n |= 1;
	ADDRESS(0x71 + (INTReg << 1));
	WRITE_DATA(n);
	return 0;
}

static int
SetIRQConflict(char *s)
{
	if(toupper(*s) == 'F')
		IRQConflictIsFatal = 1;
	else
		IRQConflictIsFatal = 0;
	return 0;
}

/*
 * I/O resource setting
 */

static int IOReg = 0;
static int IOSize = 0;
static int IOConflictIsFatal = 0;
static int IORangeCheck = 0;

static int
SelectIOReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n >= NOOFIODESCS))
		return 1;
	IOReg = n;
	IOSize = 0; /* Need to know if user specifies a size */
	IORangeCheck = 0; /* Only do if user requests it */
	Reg = 0x60 + (n << 1);
	RegSize = 2;
	strcpy(RegName, "IO  0");
	RegName[4] = n + '0';
	return 0;
}

static int
SetIOBaseReg(char *s)
{
	unsigned long n;
	n = strtol(s, (char**)NULL, 0);
	if(n > 0xffff)
		return 1;
	ADDRESS(0x60 + (IOReg << 1));
	WRITE_DATA(((unsigned char)(n >> 8)));
	ADDRESS(0x61 + (IOReg << 1));
	WRITE_DATA(((unsigned char)(n & 0xff)));
	LDios[IOReg] = (int)n;
	return 0;
}

static int
SetIOSize(char *s)
{
	long n;
	n = strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 0xffff))
		return 1;
	IOSize = (int)n;
	return 0;
}

static int
IOCheck(char *s)
{
	/*
	 * Record fact that check requested, but don't do it
	 * unless we can get resources etc
	 */
	IORangeCheck = 1;
	return 0;
}

/*
 * Called after BASE and SIZE known
 */

static int
CheckIOResource(char *s)
{
	int IOBase = LDios[IOReg];
	int size = IOSize ? IOSize : 8; /* Think of a number for the size, if none given */
	int retval = 0;
	if((IOBase != IONOTASSIGNED) && !allocate_resource(IOport_TAG, IOBase, size, filename))
		retval = WarningOrFatal(IOConflictIsFatal, "resource conflict allocating %d bytes of IO at %X (see %s)", size, IOBase, conflict_source);
	if(IORangeCheck)
	{
		/* Check if device is activated */
		ADDRESS(0x30);
		if(READ_DATA)
			retval = WarningOrFatal(1, "IO range check attempted while device activated");
		else
		{
			int checkisbad = 0;
			int iop;
			int maxaddr = IOBase + size;
			/* This will only work if the device is not activated, but we've checked that */
			ADDRESS(0x31);
			WRITE_DATA(2);
			for(iop = IOBase; iop < maxaddr; iop++)
			{
				if(READ_IOPORT(iop) != 0xaa)
				{
					checkisbad = 1;
					break;
				}
			}
			if(!checkisbad)
			{
				WRITE_DATA(3);
				for(iop = IOBase; iop < maxaddr; iop++)
				{
					if(READ_IOPORT(iop) != 0x55)
					{
						checkisbad = 1;
						break;
					}
				}
			}
			WRITE_DATA(0);
			if(checkisbad)
				retval = WarningOrFatal(1, "IO range check failed for %d bytes of IO at %X", size, IOBase);
		}
	}
	return retval;
}

static int
SetIOConflict(char *s)
{
	if(toupper(*s) == 'F')
		IOConflictIsFatal = 1;
	else
		IOConflictIsFatal = 0;
	return 0;
}

/*
 * DMA resource setting
 */

static int DMAReg = 0;
static int DMAConflictIsFatal = 0;

static int
SelectDMAReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n >= NOOFDMADESCS))
		return 1;
	DMAReg = n;
	Reg = 0x74 + n;
	RegSize = 1;
	strcpy(RegName, "DMA 0");
	RegName[4] = n + '0';
	return 0;
}

static int
SetDMAChannelReg(char *s)
{
	int n;
	int retval = 0;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 7))
		return 1;
	if(!allocate_resource(DMA_TAG, n, 1, filename))
		retval = WarningOrFatal(DMAConflictIsFatal, "resource conflict allocating DMA%d (see %s)", n, conflict_source);
	ADDRESS(0x74 + DMAReg);
	WRITE_DATA(n);
	LDdmas[DMAReg] = n;
	return retval;
}

static int
SetDMAConflict(char *s)
{
	if(toupper(*s) == 'F')
		DMAConflictIsFatal = 1;
	else
		DMAConflictIsFatal = 0;
	return 0;
}

/*
 * Memory resource setting stuff
 */

static int MemReg = 0;
static int MEMConflictIsFatal = 0;

static int
SelectMemReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 3))
		return 1;
	MemReg = n;
	Reg = 0x40 + (n << 3);
	RegSize = 8;
	strcpy(RegName, "MEM 0");
	RegName[4] = n + '0';
	return 0;
}

static int
SetMemBaseReg(char *s)
{
	unsigned long n;
	int retval = 0;
	n = strtoul(s, (char**)NULL, 0);
	/* Specify as absolute address, check for bits not programable */
	if(n & 0xff0000ff)
		return 1;
	if(!allocate_resource(MemRange_TAG, n, 8192, filename)) /* Think of a number for the size */
		retval = WarningOrFatal(MEMConflictIsFatal, "resource conflict allocating Memory at %lX (see %s)", n, conflict_source);
	ADDRESS(0x40 + (MemReg << 3));
	WRITE_DATA(n >> 16);
	ADDRESS(0x41 + (MemReg << 3));
	WRITE_DATA((n >> 8) & 0xff);
	return retval;
}

/*
 * Modes [wb][ru]
 * w = 16 bit
 * b = 8 bit
 * r = upper is range length
 * u = upper is upper limit
 * Note that R/U is a read only bit, so verify
 */
static int
SetMemModeReg(char *s)
{
	int n = 0;
	if(toupper(*s) == 'W')
		n |= 2;
	s++;
	if(toupper(*s) == 'U')
		n |= 1;
	ADDRESS(0x42 + (MemReg << 3));
	WRITE_DATA(n);
	if((READ_DATA ^ n) & 3)	/* Verify */
		return 1;
	return 0;
}

static int
SetMemUpperReg(char *s)
{
	unsigned long n;
	n = strtoul(s, (char**)NULL, 0);
	/* Specify as absolute address, check for bits not programable */
	if(n & 0xff0000ff)
		return 1;
	ADDRESS(0x43 + (MemReg << 3));
	WRITE_DATA(n >> 16);
	ADDRESS(0x44 + (MemReg << 3));
	WRITE_DATA((n >> 8) & 0xff);
	return 0;
}

static int
SetMEMConflict(char *s)
{
	if(toupper(*s) == 'F')
		MEMConflictIsFatal = 1;
	else
		MEMConflictIsFatal = 0;
	return 0;
}

/*
 * General purpose logical device peek and poke
 */

static int
SelectReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	if((n < 0)||(n > 0xff))
		return 1;
	Reg = n;
	RegSize = 1;
	strcpy(RegName, "-REG-");
	return 0;
}

static int
PokeReg(char *s)
{
	int n;
	n = (int)strtol(s, (char**)NULL, 0);
	/* Can only poke bytes */
	if(RegSize > 1)
	{
		fprintf(stderr, "Can only poke bytes\n");
		return(1);
	}
	if((n < 0)||(n > 0xff))
		return 1;
	ADDRESS(Reg);
	WRITE_DATA(n);
	return 0;
}

/*
 * Peek will work for named stuff too
 */
static int
PeekReg(char *s)
{
	int i;
	int data[MAXREGSIZE];
	ADDRESS(Reg);
	data[0] = READ_DATA;
	if(verbosity >= 1)
		printf("Peek(%s/%s)[%u][0x%02x](%s) is 0x%02X", boardid[csn], sernostr(serno[csn]), LogDev, Reg, RegName, data[0]);
	for(i = 1; i < RegSize; i++)
	{
		ADDRESS(Reg + i);
		data[i] = READ_DATA;
		if(verbosity >= 1)
			printf("%02X", data[i]);
	}
	printf(", (%d", data[0]);
	for(i = 1; i < RegSize; i++)
	{
		ADDRESS(Reg + i);
		if(verbosity >= 1)
			printf(",%d", data[i]);
	}
	if(verbosity >= 1)
		printf(")\n");
	return 0;
}

static void
printgot(void)
{
	if(debug) printf("Got %s\n", yytext);
}

#define ONDEBUG() /*if (debug) */printgot()
#define ADDACTION(x, y) if(!addaction(x, y)) yyterminate()
/*
# LD n      = Logical device, ie write to reg 7
# IO n      = IO descriptor n
# MEM n     = MEM descriptor n (24bit descriptors only for ISA)
# DMA n     = DMA descriptor n
# REG n     = Select register n
# POKE n    = Poke a value
# PEEK      = Read a value and print on stdout
# BASE n    = IO/Mem address n
# UPPER n   = Mem upper address/range n
# INT n     = Interrupt req n
# IRQ n     = Interrupt level n
# MODE      = IRQ line levels etc/Memory width etc
# CHANNEL n = DMA channel
# ACT       = Activate

(IGNORECRC)
(READPORT 0x207)
(ISOLATE3
(CSN 1 (LD 0 (REG 0x42 (POKE 0x00) (PEEK))))
(CONFIGURE DFX0000/1493 (LD 0 (REG 0x42 (POKE 0x00) (PEEK))))
(CONFIGURE DFX0000/1493 (LD 0 (MEM 0 (BASE 0x400000) (MODE wu) (UPPER 0x800000)) (DMA 0 (CHANNEL 1))))
(CONFIGURE DFX0000/1493 (LD 0 (IO 0 (BASE 0x3e8)) (INT 0 (IRQ 12 (MODE +E))) (ACT Y)))
(WAITFORKEY)
*/
#define YY_NO_UNPUT 1
#define LEVEL1 1

#define LEVEL2 2

#define LEVEL3 3

#define LEVEL4ACT 4

#define LEVEL4IO 5

#define LEVEL4MEM 6

#define LEVEL4DMA 7

#define LEVEL4INT 8

#define LEVEL4REG 9

#define LEVEL5INT 10

#define NOMORE 11

#define NOMLEVEL3 12

#define CONFIG 13

#define LOGDEV 14

#define IOSET 15

#define MEMSET 16

#define DMASET 17

#define ACTSET 18

#define INTSET 19

#define REGSET 20

#define IRQSET 21

#define PEARSHAPED 22

#define CONFLICT 23

#define CONFLICT2 24

#define CONFLICT2RET 25

// #line 2072 "lex.yy.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
		if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else { \
		if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" ); \
	}
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	/* register */yy_state_type yy_current_state;
	/* register */char *yy_cp;
				  char *yy_bp;
	/* register */int yy_act;

// #line 1358 "isapnp_main.l"


// #line 2226 "lex.yy.c"

	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}
		
	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;
		
		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		// debug 
//		printf( "debug1(%c)(%x):%c\ndebug2(%x):%s\n", yy_hold_char, yy_hold_char, yy_hold_char, yy_c_buf_p, yy_c_buf_p );

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
		// debuf
//		printf( "yy_start:%d\n", yy_start );

yy_match:
		do
			{
			/* register */YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				// debug
//				printf( "yy_current_state:%d, yy_def[]:%d\n", yy_current_state, yy_def[yy_current_state] );

				yy_current_state = (int) yy_def[yy_current_state];
				// debug
//				printf( "yy_current_state<-def[]:%d\n", yy_current_state );
				if ( yy_current_state >= 431 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];

			// debug
//			printf( "yy_current_state:%d, yy_c:%d\n", yy_current_state, yy_c );
//			printf( "yy_base[yy_current_state]:%d\n",yy_base[yy_current_state] );

			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 835 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		// debug
//		printf( "yy_current_state:%d, yy_act:%d\n", yy_act, yy_current_state );
		
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
// #line 1360 "isapnp_main.l"
BEGIN(LEVEL1);
	YY_BREAK
case 2:
YY_RULE_SETUP
// #line 1362 "isapnp_main.l"
BEGIN(INITIAL);
	YY_BREAK
case 3:
YY_RULE_SETUP
// #line 1363 "isapnp_main.l"
BEGIN(NOMORE); debug = 1; banner(stdout); ONDEBUG();
	YY_BREAK
case 4:
YY_RULE_SETUP
// #line 1364 "isapnp_main.l"
BEGIN(NOMORE); ADDACTION(IgnoreCRC, 9); ONDEBUG();
	YY_BREAK
case 5:
YY_RULE_SETUP
// #line 1365 "isapnp_main.l"
BEGIN(CONFLICT); ONDEBUG();
	YY_BREAK
case 6:
YY_RULE_SETUP
// #line 1366 "isapnp_main.l"
BEGIN(NOMORE); ADDACTION(VerifyLD, 8); ONDEBUG();
	YY_BREAK
case 7:
YY_RULE_SETUP
// #line 1367 "isapnp_main.l"
BEGIN(NOMORE); ADDACTION(IdentifyFormat, 15); ONDEBUG();
	YY_BREAK
case 8:
// #line 1369 "isapnp_main.l"
case 9:
YY_RULE_SETUP
// #line 1369 "isapnp_main.l"
{ BEGIN(NOMORE); ADDACTION(Read_Port, 8); ONDEBUG(); }
	YY_BREAK
case 10:
// #line 1371 "isapnp_main.l"
case 11:
YY_RULE_SETUP
// #line 1371 "isapnp_main.l"
{ BEGIN(NOMORE); ADDACTION(SetVerbosity, 9); ONDEBUG(); }
	YY_BREAK
case 12:
// #line 1373 "isapnp_main.l"
case 13:
// #line 1374 "isapnp_main.l"
case 14:
YY_RULE_SETUP
// #line 1374 "isapnp_main.l"
{ BEGIN(NOMORE); ADDACTION(Identify, 8); ONDEBUG(); }
	YY_BREAK
case 15:
YY_RULE_SETUP
// #line 1375 "isapnp_main.l"
BEGIN(NOMORE); ADDACTION(Isolate, 7); ONDEBUG();
	YY_BREAK
case 16:
YY_RULE_SETUP
// #line 1376 "isapnp_main.l"
BEGIN(CONFIG); configureaction = nextaction; ADDACTION(SelectIdent, 9); ONDEBUG();
	YY_BREAK
case 17:
YY_RULE_SETUP
// #line 1377 "isapnp_main.l"
BEGIN(CONFIG); configureaction = nextaction; ADDACTION(SelectCSN, 3); ONDEBUG();
	YY_BREAK
case 18:
YY_RULE_SETUP
// #line 1378 "isapnp_main.l"
BEGIN(NOMORE); ADDACTION(WaitForKey, 10); ONDEBUG();
	YY_BREAK
case 19:
YY_RULE_SETUP
// #line 1380 "isapnp_main.l"
BEGIN(INITIAL);
	YY_BREAK
case 20:
YY_RULE_SETUP
// #line 1382 "isapnp_main.l"
BEGIN(INITIAL);
	YY_BREAK
case 21:
YY_RULE_SETUP
// #line 1383 "isapnp_main.l"
BEGIN(CONFLICT2);
	YY_BREAK
case 22:
YY_RULE_SETUP
// #line 1385 "isapnp_main.l"
BEGIN(CONFLICT2RET); ADDACTION(SetIOConflict, 2); ONDEBUG();
	YY_BREAK
case 23:
YY_RULE_SETUP
// #line 1386 "isapnp_main.l"
BEGIN(CONFLICT2RET); ADDACTION(SetIRQConflict, 3); ONDEBUG();
	YY_BREAK
case 24:
YY_RULE_SETUP
// #line 1387 "isapnp_main.l"
BEGIN(CONFLICT2RET); ADDACTION(SetMEMConflict, 3); ONDEBUG();
	YY_BREAK
case 25:
YY_RULE_SETUP
// #line 1388 "isapnp_main.l"
BEGIN(CONFLICT2RET); ADDACTION(SetDMAConflict, 3); ONDEBUG();
	YY_BREAK
case 26:
YY_RULE_SETUP
// #line 1390 "isapnp_main.l"
BEGIN(CONFLICT);
	YY_BREAK
case 27:
YY_RULE_SETUP
// #line 1392 "isapnp_main.l"
BEGIN(INITIAL); actions[configureaction].jumponerror = nextaction;
	YY_BREAK
case 28:
YY_RULE_SETUP
// #line 1393 "isapnp_main.l"
BEGIN(LEVEL2);
	YY_BREAK
case 29:
YY_RULE_SETUP
// #line 1395 "isapnp_main.l"
BEGIN(CONFIG);
	YY_BREAK
case 30:
YY_RULE_SETUP
// #line 1396 "isapnp_main.l"
BEGIN(LOGDEV); ADDACTION(SetLogicalDevice, 2); ONDEBUG();
	YY_BREAK
case 31:
YY_RULE_SETUP
// #line 1398 "isapnp_main.l"
BEGIN(CONFIG);
	YY_BREAK
case 32:
YY_RULE_SETUP
// #line 1399 "isapnp_main.l"
BEGIN(LEVEL3);
	YY_BREAK
case 33:
YY_RULE_SETUP
// #line 1401 "isapnp_main.l"
BEGIN(LOGDEV);
	YY_BREAK
case 34:
YY_RULE_SETUP
// #line 1402 "isapnp_main.l"
ADDACTION(SetLDName, 4); ONDEBUG();
	YY_BREAK
case 35:
YY_RULE_SETUP
// #line 1403 "isapnp_main.l"
BEGIN(IOSET);  getkeyword(2); ONDEBUG();
	YY_BREAK
case 36:
YY_RULE_SETUP
// #line 1404 "isapnp_main.l"
BEGIN(MEMSET); getkeyword(3); ONDEBUG();
	YY_BREAK
case 37:
YY_RULE_SETUP
// #line 1405 "isapnp_main.l"
BEGIN(DMASET); getkeyword(3); ONDEBUG();
	YY_BREAK
case 38:
YY_RULE_SETUP
// #line 1406 "isapnp_main.l"
BEGIN(INTSET); getkeyword(3); ONDEBUG();
	YY_BREAK
case 39:
YY_RULE_SETUP
// #line 1407 "isapnp_main.l"
BEGIN(REGSET); getkeyword(3); ONDEBUG();
	YY_BREAK
case 40:
YY_RULE_SETUP
// #line 1408 "isapnp_main.l"
BEGIN(ACTSET); getkeyword(3); ONDEBUG();
	YY_BREAK
case 41:
YY_RULE_SETUP
// #line 1410 "isapnp_main.l"
BEGIN(NOMLEVEL3); ADDACTION(Activate, 0); ONDEBUG();
	YY_BREAK
case 42:
YY_RULE_SETUP
// #line 1411 "isapnp_main.l"
BEGIN(LEVEL4ACT); ADDACTION(SelectAct, NOARG);
	YY_BREAK
case 43:
YY_RULE_SETUP
// #line 1413 "isapnp_main.l"
BEGIN(LOGDEV);
	YY_BREAK
case 44:
YY_RULE_SETUP
// #line 1415 "isapnp_main.l"
ADDACTION(CheckIOResource, IORESCHECK); BEGIN(LOGDEV);
	YY_BREAK
case 45:
YY_RULE_SETUP
// #line 1416 "isapnp_main.l"
ADDACTION(SelectIOReg, 0); ONDEBUG();
	YY_BREAK
case 46:
YY_RULE_SETUP
// #line 1417 "isapnp_main.l"
BEGIN(LEVEL4IO);
	YY_BREAK
case 47:
YY_RULE_SETUP
// #line 1419 "isapnp_main.l"
ADDACTION(SelectMemReg, 0); ONDEBUG();
	YY_BREAK
case 48:
YY_RULE_SETUP
// #line 1420 "isapnp_main.l"
BEGIN(LEVEL4MEM);
	YY_BREAK
case 49:
YY_RULE_SETUP
// #line 1422 "isapnp_main.l"
ADDACTION(SelectDMAReg, 0); ONDEBUG();
	YY_BREAK
case 50:
YY_RULE_SETUP
// #line 1423 "isapnp_main.l"
BEGIN(LEVEL4DMA);
	YY_BREAK
case 51:
YY_RULE_SETUP
// #line 1425 "isapnp_main.l"
ADDACTION(SelectINTReg, 0); ONDEBUG();
	YY_BREAK
case 52:
YY_RULE_SETUP
// #line 1426 "isapnp_main.l"
BEGIN(LEVEL4INT);
	YY_BREAK
case 53:
// #line 1429 "isapnp_main.l"
case 54:
YY_RULE_SETUP
// #line 1429 "isapnp_main.l"
ADDACTION(SelectReg, 0); ONDEBUG();
	YY_BREAK
case 55:
YY_RULE_SETUP
// #line 1430 "isapnp_main.l"
BEGIN(LEVEL4REG);
	YY_BREAK
case 56:
YY_RULE_SETUP
// #line 1432 "isapnp_main.l"
BEGIN(ACTSET);
	YY_BREAK
case 57:
YY_RULE_SETUP
// #line 1433 "isapnp_main.l"
ADDACTION(PeekReg, 4); ONDEBUG();
	YY_BREAK
case 58:
YY_RULE_SETUP
// #line 1435 "isapnp_main.l"
BEGIN(IOSET);
	YY_BREAK
case 59:
// #line 1437 "isapnp_main.l"
case 60:
YY_RULE_SETUP
// #line 1437 "isapnp_main.l"
ADDACTION(SetIOBaseReg, 4); ONDEBUG();
	YY_BREAK
case 61:
// #line 1439 "isapnp_main.l"
case 62:
YY_RULE_SETUP
// #line 1439 "isapnp_main.l"
ADDACTION(SetIOSize, 4); ONDEBUG();
	YY_BREAK
case 63:
YY_RULE_SETUP
// #line 1440 "isapnp_main.l"
ADDACTION(PeekReg, 4); ONDEBUG();
	YY_BREAK
case 64:
YY_RULE_SETUP
// #line 1441 "isapnp_main.l"
ADDACTION(IOCheck, 5); ONDEBUG();
	YY_BREAK
case 65:
YY_RULE_SETUP
// #line 1443 "isapnp_main.l"
BEGIN(MEMSET);
	YY_BREAK
case 66:
// #line 1445 "isapnp_main.l"
case 67:
YY_RULE_SETUP
// #line 1445 "isapnp_main.l"
ADDACTION(SetMemBaseReg, 4); ONDEBUG();
	YY_BREAK
case 68:
// #line 1447 "isapnp_main.l"
case 69:
YY_RULE_SETUP
// #line 1447 "isapnp_main.l"
ADDACTION(SetMemUpperReg, 5); ONDEBUG();
	YY_BREAK
case 70:
YY_RULE_SETUP
// #line 1448 "isapnp_main.l"
ADDACTION(SetMemModeReg, 4); ONDEBUG();
	YY_BREAK
case 71:
YY_RULE_SETUP
// #line 1449 "isapnp_main.l"
ADDACTION(PeekReg, 4); ONDEBUG();
	YY_BREAK
case 72:
YY_RULE_SETUP
// #line 1451 "isapnp_main.l"
BEGIN(DMASET);
	YY_BREAK
case 73:
YY_RULE_SETUP
// #line 1452 "isapnp_main.l"
ADDACTION(SetDMAChannelReg, 7); ONDEBUG();
	YY_BREAK
case 74:
YY_RULE_SETUP
// #line 1453 "isapnp_main.l"
ADDACTION(PeekReg, 4); ONDEBUG();
	YY_BREAK
case 75:
YY_RULE_SETUP
// #line 1455 "isapnp_main.l"
BEGIN(INTSET);
	YY_BREAK
case 76:
YY_RULE_SETUP
// #line 1456 "isapnp_main.l"
BEGIN(IRQSET); ADDACTION(SetIRQLine, 3); ONDEBUG();
	YY_BREAK
case 77:
YY_RULE_SETUP
// #line 1457 "isapnp_main.l"
ADDACTION(PeekReg, 4); ONDEBUG();
	YY_BREAK
case 78:
YY_RULE_SETUP
// #line 1459 "isapnp_main.l"
BEGIN(REGSET);
	YY_BREAK
case 79:
// #line 1461 "isapnp_main.l"
case 80:
YY_RULE_SETUP
// #line 1461 "isapnp_main.l"
ADDACTION(PokeReg, 4); ONDEBUG();
	YY_BREAK
case 81:
YY_RULE_SETUP
// #line 1462 "isapnp_main.l"
ADDACTION(PeekReg, 4); ONDEBUG();
	YY_BREAK
case 82:
YY_RULE_SETUP
// #line 1464 "isapnp_main.l"
BEGIN(INTSET);
	YY_BREAK
case 83:
YY_RULE_SETUP
// #line 1465 "isapnp_main.l"
BEGIN(LEVEL5INT);
	YY_BREAK
case 84:
YY_RULE_SETUP
// #line 1467 "isapnp_main.l"
BEGIN(IRQSET);
	YY_BREAK
case 85:
YY_RULE_SETUP
// #line 1468 "isapnp_main.l"
ADDACTION(SetIRQMode, 4); ONDEBUG();
	YY_BREAK
case 86:
YY_RULE_SETUP
// #line 1470 "isapnp_main.l"
{ /* Swallow comment to eol */ /* register */int c; while(((c = input()) != '\n') && (c != EOF)) ; linenumber++; }
	YY_BREAK
case 87:
YY_RULE_SETUP
// #line 1471 "isapnp_main.l"
/* Swallow whitespace */
	YY_BREAK
case 88:
YY_RULE_SETUP
// #line 1472 "isapnp_main.l"
{ linenumber++; /* Count these */ }
	YY_BREAK
case 89:
YY_RULE_SETUP
// #line 1473 "isapnp_main.l"
BEGIN(PEARSHAPED); fprintf(stderr, "Don't know what to do with %s", yytext); parseerror = 1;
	YY_BREAK
case 90:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
// #line 1475 "isapnp_main.l"
fprintf(stderr, "%s on or around line %d\n", yytext, linenumber); yyterminate();
	YY_BREAK
case 91:
YY_RULE_SETUP
// #line 1477 "isapnp_main.l"
ECHO;
	YY_BREAK
// #line 2737 "lex.yy.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(LEVEL1):
case YY_STATE_EOF(LEVEL2):
case YY_STATE_EOF(LEVEL3):
case YY_STATE_EOF(LEVEL4ACT):
case YY_STATE_EOF(LEVEL4IO):
case YY_STATE_EOF(LEVEL4MEM):
case YY_STATE_EOF(LEVEL4DMA):
case YY_STATE_EOF(LEVEL4INT):
case YY_STATE_EOF(LEVEL4REG):
case YY_STATE_EOF(LEVEL5INT):
case YY_STATE_EOF(NOMORE):
case YY_STATE_EOF(NOMLEVEL3):
case YY_STATE_EOF(CONFIG):
case YY_STATE_EOF(LOGDEV):
case YY_STATE_EOF(IOSET):
case YY_STATE_EOF(MEMSET):
case YY_STATE_EOF(DMASET):
case YY_STATE_EOF(ACTSET):
case YY_STATE_EOF(INTSET):
case YY_STATE_EOF(REGSET):
case YY_STATE_EOF(IRQSET):
case YY_STATE_EOF(PEARSHAPED):
case YY_STATE_EOF(CONFLICT):
case YY_STATE_EOF(CONFLICT2):
case YY_STATE_EOF(CONFLICT2RET):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else {
				int retval_yy_get_next_buffer = 0;		// nwsos
				retval_yy_get_next_buffer = yy_get_next_buffer();
				// debug
//				printf( "cu me?\n" );
//				printf( "retval_yy_get_next_buffer:%d\n", retval_yy_get_next_buffer );
				
				switch ( /* yy_get_next_buffer()*/ retval_yy_get_next_buffer )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;
				// debug
//				printf( "yy_amount_of_matched_text:%d\n", yy_amount_of_matched_text );

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

//static int yy_get_next_buffer()
static int yy_get_next_buffer YY_PROTO(( void ))
	{
	/* register */char *dest = yy_current_buffer->yy_ch_buf;
	/* register */char *source = yytext_ptr;
	/* register */int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );
		// debug
//		printf( "yy_current_buffer->yy_ch_buf:%x\n", yy_current_buffer->yy_ch_buf );
//		printf( "yy_current_buffer->yy_ch_buf[%d]:%x\n", number_to_move, yy_current_buffer->yy_ch_buf[number_to_move] );
//		printf( "&yy_current_buffer->yy_ch_buf[%d]:%x\n", number_to_move, &yy_current_buffer->yy_ch_buf[number_to_move] );
//		printf( "yy_n_chars:%d\n", yy_n_chars );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];
	
	// debug
//	printf( "yytext_ptr:%x, ret_val:%d\n", yytext_ptr, ret_val );

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state YY_PROTO(( void ))
	{
	/* register */yy_state_type yy_current_state;
	/* register */char *yy_cp;

	yy_current_state = yy_start;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		/* register */YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 431 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	/* register */int yy_is_jam;
	/* register */char *yy_cp = yy_c_buf_p;

	/* register */YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 431 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 430);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, /* register */char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
/* register */char *yy_bp;
#endif
	{
	/* register */char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		/* register */int number_to_move = yy_n_chars + 2;
		/* register */char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		/* register */char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input YY_PROTO(( void ))
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int ret_yy_get_next_buffer = 0;		//nwsos
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			// debug
//			printf( "cu me @input()?\n" );
			switch ( /* yy_get_next_buffer() */ ret_yy_get_next_buffer )	// nwsos
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					
					//debug
//					printf( "yy_c_buf_p:%x, yytext_ptr:%x, offset:%x\n", yy_c_buf_p, yytext_ptr, offset );
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;

	// debug
//	printf("debug input:%c\n", c );

	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
// nwsos
//	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
	b->yy_is_interactive = file ? 0 : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	/* register */int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	/* register */int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
// #line 1477 "isapnp_main.l"


int
isapnp_main(int argc, char **argv)
{
	int i;
	char *program = argv[0];
	int retval;

	/* Process command line options */
	const struct option longopts[] =
	{
		{"help", no_argument, NULL, 'h'},
#ifdef REALTIME
		{"max-realtime", required_argument, NULL, 't'},
#endif
		{"version", no_argument, NULL, 'v'},
		{0, 0, 0, 0},
	};
	int opt;

	while ((opt = getopt_long(argc, argv, "t:vh", longopts, NULL)) != EOF)
	{
		switch (opt)
		{
		case 'h':
			usage(program);
			break;
#ifdef REALTIME
		case 't':
			l_realtime_timeout = atol(optarg);
			break;
#else
		case 't':
			fprintf(stderr, "Realtime support not compiled in - option ignored\n");
			break;
#endif
		case 'v':
			fprintf(stderr, "Version: isapnp from %s-%s\n", PACKAGE, VERSION);
			exit(0);
			break;
		case '?':
#if 1
			fprintf(stderr, "unrecognized option.\n");
#endif
			usage(program);
			return 1;
		case ':':
#if 1
			fprintf(stderr, "missing parameter.\n");
#endif
			usage(program);
			return 1;
		default:
			fprintf(stderr,
					"?? getopt returned character code 0x%x ('%c').\n",
					opt, opt);
			return 1;
		}

	}
	argc -= optind - 1;
	argv += optind - 1;

	if(argc != 2)
	{
		usage(program);
		exit(1);
	}

	/* Initialize callbacks */
	callbacks_init(normal_fatal_error_callback,
		       normal_non_fatal_error_callback,
		       null_progress_report_callback);

	read_port = 0;	/* Flag we haven't set it yet */

	/* Open configuration file: '-' is stdin */
	filename = argv[1];
	if(strcmp(filename, "-") != 0)
		yyin = fopen(filename, "r");
	else
		yyin = stdin;
	/* Check we have open configuration file before doing anything else */
	if(!yyin)
	{
		fprintf(stderr, "Unable to open configuration file '%s' - ", filename);
		perror("");
		exit(1);
	}
	if(acquire_pnp_io_privileges() != 0)
	{	
		perror("Unable to get io permission for WRITE_DATA");
		exit(1);
	}
	retval = 0;
	/* Read in resource allocations */
	alloc_system_resources();
	yylex();
	if(parseerror)
	{
		fprintf(stderr, "%s:%d -- Fatal - Error occurred parsing config file --- no action taken\n", filename, linenumber);
		retval = 1;
	}
	else
	{
#ifdef REALTIME
		setroundrobin(l_realtime_timeout);
#endif /* REALTIME */
		for(i = 0; i < nextaction; i++)
		{
			if(debug)
				printf("Executing %s %s\n", actions[i].name, actions[i].arg);
			linenumber = actions[i].linenum;
			if(actions[i].fn(actions[i].arg))
			{
				fflush(stdout); /* Make sure peeks etc output first */
				if(actions[i].jumponerror)
				{
					i = actions[i].jumponerror - 1; /* To compensate for the ++ */
					continue;
				}
				fprintf(stderr, "%s:%d -- Fatal - Error occurred executing request '%s %s' --- further action aborted\n", filename, linenumber, actions[i].name, actions[i].arg);
				retval = 1;
				break;
			}
		}
	}
	/* Release resources */
	if (relinquish_pnp_io_privileges() != 0) {
		perror("Unable to release io permission for WRITE_DATA");
		exit(1);
	}
	return retval;
}
