      program main
      use indata
      use kernel_params
      implicit real*8(a-h,o-z)

      character*99 name
      real*8,allocatable::z(:)
      integer,allocatable::qt(:)
      real*8 probA,probB,dist,Kernel,Kernel_s
      character*50 input_file,output_file,model_file
      integer read_line_df,read_line_sf

c     argments
      if (iargc() .eq. 3) then
        call getarg(1,input_file)
        call getarg(2,model_file)
        call getarg(3,output_file)
      else
        write(*,*) 'usage: SVMpred  input_file  model_file  output_file'
        stop
      end if

      is_sparse=0; bin_format=0
c     reading model   NN(# of data) MM(# of descriptor)
      open(10,file=model_file,status='old',action='read')
      read(10,*) NN,MM,is_sparse,bin_format
      read(10,*) Cost,gamma,u1,u2,u3
      read(10,*) probA,probB
      read(10,*) b
      close(10)
      allocate (y(NN),x(MM,NN),alpha(NN))
      allocate (pt(MM,NN),nd(NN))
      if (is_sparse .eq. 0) then
        if (bin_format .eq. 0) then
          call read_model_df(model_file,y,alpha,x)
        else if (bin_format .eq. 1) then
          call read_model_dfb(model_file,y,alpha,x)
        end if
        allocate (z(MM))
      else if (is_sparse .eq. 1) then
        if (bin_format .eq. 0) then
          call read_model_sf(model_file,y,alpha,x,pt,nd,MM,imax)
        else if (bin_format .eq. 1) then
          call read_model_sfb(model_file,y,alpha,x,pt,nd,imax)
        end if
        allocate (z(imax),qt(imax))
      end if
      
      call file_open(input_file)
      open(12,file=output_file,action='write')

c     the loop of the input data
      do while (.true.)
        name=''
        if (is_sparse .eq. 0) then
          i=read_line_df(name,z)
        else if (is_sparse .eq. 1) then
          i=read_line_sf(name,z,qt,md)
        end if
        if (i == 0) then
          goto 9999
        end if

        dist=0.d0
        if (is_sparse .eq. 0) then
!$omp parallel do schedule(dynamic) reduction(+:dist)
          do i=1,NN
            dist=dist+alpha(i)*y(i)*Kernel(MM,x(1,i),z(1))
          end do
        else if (is_sparse .eq. 1) then
!$omp parallel do schedule(dynamic) reduction(+:dist)
          do i=1,NN
            dist=dist+alpha(i)*y(i)
     &           *Kernel_s(MM,x(1,i),pt(1,i),nd(i)
     &           ,imax,z(1),qt(1),md,imax)
          end do
        end if
        dist=dist+b

        f=dist*probA+probB
        if (f .ge. 0.d0) then
          prob=exp(-f)/(1.d0+exp(-f))
        else
          prob=1.d0/(1.d0+exp(f))
        end if
        write(12,'(A,F16.10,F16.10)') trim(name),dist,prob
        
      end do
 9999 continue
      close(12)
      call file_close()

      end

