      subroutine parse_option(input_file,model_file,Nq0,NB,rq,MAXitr,
     &     tolerance,eps)
      use indata
      use kernel_params
      implicit real*8(a-h,o-z)

      real*8  tolerance,eps,rq
      integer MAXitr,Nq0,Nq,vKKT
      character*99 arg,input_file,model_file

c     set default parameters
      Cost=10.d0
      gamma=0.01d0; u1=0; u2=0; u3=0;
      tolerance=1.d-3
      eps=1.d-9
      MAXitr=999999
      rq=1.d0
      Nq0=500
      NB=1
      is_sparse=0
      bin_format=0

      if (iargc() .lt. 2) then
        call print_usage()
      end if

      i=1
      do while (i .le. iargc())
        call getarg(i, arg)
        if (index(arg,"-") .ne. 0) then
          if (arg .eq. "-s") then
            is_sparse=1
          else if (arg .eq. "-b") then
            bin_format=1
          else
            i=i+1
            if (arg .eq. "-c") then
              call getarg(i, arg)
              read(arg,*) Cost
            else if (arg .eq. "-g") then
              call getarg(i, arg)
              read(arg,*) gamma
            else if (arg .eq. "-u1") then
              call getarg(i, arg)
              read(arg,*) u1
            else if (arg .eq. "-u2") then
              call getarg(i, arg)
              read(arg,*) u2
            else if (arg .eq. "-u3") then
              call getarg(i, arg)
              read(arg,*) u3
            else if (arg .eq. "-q")then
              call getarg(i, arg)
              read(arg,*) Nq0
            else if (arg .eq. "-v") then
              call getarg(i, arg)
              read(arg,*) NB
            else if (arg .eq. "-rq") then
              call getarg(i, arg)
              read(arg,*) rq
            else if (arg .eq. "-imax") then
              call getarg(i, arg)
              read(arg,*) MAXitr
            else if (arg .eq. "-tol") then
              call getarg(i, arg)
              read(arg,*) tolerance
            else if (arg .eq. "-eps") then
              call getarg(i, arg)
              read(arg,*) eps
            end if
          end if
        else
          exit
        end if
        i=i+1
      end do

      if (i+1 .ne. iargc()) then
        call print_usage()
      end if

      call getarg(i,input_file)
      call getarg(i+1,model_file)

      end

c
      subroutine print_usage()

      write(*,*) 
     &     'usage: SVMlearn [options]  input_file  model_file'
      write(*,*) 'options:'
      write(*,*) 
     &     '-s : When input_file is sparse format, use this option.'
      write(*,*) 
     &     '-b : write model file in binary format.'
      write(*,*) 
     &     '-c cost : the parameter C of C-SVC (default 10)'
      write(*,*)
     &     '-g gamma : gamma in RBF kernel function'
     &     ,' (default 0.01)'
      write(*,*)
     &     '-u1, -u2, -u3 : parameters for user defined kernel'
     &     ,' (default 0)'
      write(*,*) 
     &     '-q Nq : 4*Nq is the sampling number of alphas'
     &     ,' (default 500)'
      write(*,*) 
     &     '-v n : n-fold cross validation mode (default 1)'
      write(*,*) 
     &     '-rq rq : damping factor of Nq (default 1)'
      write(*,*) 
     &     '-imax imax : maximum number of iterations'
     &     ,' (default 999999)'
      write(*,*) 
     &     '-tol tolerance : tolerance of KKT criteria'
     &     ,' (default 0.001)'
      write(*,*) 
     &     '-eps eps : the alpha below eps is regarded as zero'
     &     ,' (default 1.d-9)'
      
      stop
      end
      
