<?php
/*
	p2 - StrCtl -- 񑀍NX
*/

if (!extension_loaded('mbstring')) {
	include_once './jcode/jcode_wrapper.php';
}

class StrCtl{

	function p2SJIStoEUC($str)
	{
		if (extension_loaded('mbstring')) {
			$str = mb_convert_encoding($str, 'EUC-JP', 'SJIS-win');
		} else {
			$str = jcode_convert_encoding($str, 'euc', 'sjis');
		}
		return $str;
	}

	function p2EUCtoSJIS($str)
	{
		if (extension_loaded('mbstring')) {
			$str = mb_convert_encoding($str, 'SJIS-win', 'EUC-JP');
		} else {
			$str = jcode_convert_encoding($str, 'sjis', 'euc');
		}
		return $str;
	}

	function p2SJIStoUTF($str)
	{
		if (extension_loaded('mbstring')) {
			$str = mb_convert_encoding($str, 'UTF-8', 'SJIS-win');
		} else {
			$str = jcode_convert_encoding($str, 'utf8', 'sjis');
		}
		return $str;
	}

	function p2UTFtoSJIS($str)
	{
		if (extension_loaded('mbstring')) {
			$str = mb_convert_encoding($str, 'SJIS-win', 'UTF-8');
		} else {
			$str = jcode_convert_encoding($str, 'sjis', 'utf8');
		}
		return $str;
	}


	/**
	 * tH[瑗Ă[h}b`֐ɓK
	 *
	 * @return string $word_fm Kp^[BSJISŕԂB
	 */
	function wordForMatch($word, $method = '')
	{
		$word_fm = $word;
		if ($method != 'just') {
			if (P2_MBREGEX_AVAILABLE == 1) {
				$word_fm = mb_ereg_replace('@', ' ', $word_fm);
			} else {
				$word_fm = str_replace('@', ' ', $word_fm);
			}
		}
		$word_fm = trim($word);
		$word_fm = htmlspecialchars($word_fm, ENT_NOQUOTES);
		if (in_array($method, array('and', 'or', 'just'))) {
			// preg_quote()2oCgڂ0x5B("[")"["ȂǂϊĂ܂̂
			// UTF-8ɂĂ琳K\̓ꕶGXP[v
			$word_fm = StrCtl::p2SJIStoUTF($word_fm);
			if (P2_MBREGEX_AVAILABLE == 1) {
				$word_fm = preg_quote($word_fm);
			} else {
				$word_fm = preg_quote($word_fm, '/');
			}
			$word_fm = StrCtl::p2UTFtoSJIS($word_fm);
		} else {
			if (P2_MBREGEX_AVAILABLE == 0) {
				$word_fm = str_replace('/', '\/', $word_fm);
			}
		}
		return $word_fm;
	}

	/**
	 * }`oCgΉ̐K\}b`\bh
	 *
	 * @param string $pattern }b`BSJISœĂB
	 * @param string $target ΏەBSJISœĂB
	 */
	function filterMatch($pattern, &$target)
	{	
		// HTMLvfɃ}b`Ȃ߂̔ےǂ݃p^[t
		$pattern = '(' . $pattern . ')(?![^<]*>)';

		if (P2_MBREGEX_AVAILABLE == 1) {
			$result = @mb_eregi($pattern, $target);
		} else {
			// UTF-8ɕϊĂ珈
			$pattern_utf8 = '/' . StrCtl::p2SJIStoUTF($pattern) . '/iu';
			$target_utf8 = StrCtl::p2SJIStoUTF($target);
			$result = @preg_match($pattern_utf8, $target_utf8);
			//$result = StrCtl::p2UTFtoSJIS($result);
		}
		if ($result) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * }`oCgΉ̃}[LO
	 *
	 * @param string $pattern }b`BSJISœĂB
	 * @param string $target uΏەBSJISœĂB
	 */
	function filterMarking($pattern, &$target, $marker = '<b class="filtering">\\1</b>')
	{
		// HTMLvfɃ}b`Ȃ߂̔ےǂ݃p^[t
		$pattern = '(' . $pattern . ')(?![^<]*>)';

		if (P2_MBREGEX_AVAILABLE == 1) {
			$result = @mb_eregi_replace($pattern, $marker, $target);
		} else {
			// UTF-8ɕϊĂ珈
			$pattern_utf8 = '/' . StrCtl::p2SJIStoUTF($pattern) . '/iu';
			$target_utf8 = StrCtl::p2SJIStoUTF($target);
			$result = @preg_replace($pattern_utf8, $marker, $target_utf8);
			$result = StrCtl::p2UTFtoSJIS($result);
		}

		if (!$result) {
			return $target;
		}
		return $result;
	}
}

?>