/*
 * Decompiled with CFR 0.152.
 */
package com.cwbp.pb;

import com.cwbp.pb.ArgTable;
import com.cwbp.pb.DomRead;
import com.cwbp.pb.HostCollection;
import com.cwbp.pb.Packet;
import com.cwbp.pb.mainThread;
import com.cwbp.pb.pbReceiver;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

public class pbRChannelDom
extends pbReceiver {
    int[][][] data = null;
    HostCollection srcIgnoreHostsTCP;
    HostCollection dstIgnoreHostsTCP;
    HostCollection srcIgnoreHostsUDP;
    HostCollection dstIgnoreHostsUDP;
    static MidiChannel channel = null;
    private boolean playing = false;
    int duration = 128;
    int vel = 64;
    public static final int MusicBox = 10;
    public static final int TubularBells = 14;
    public static final int TinkleBell = 112;
    public static final int TelephoneRing = 124;
    static int inst = 112;
    static int basePitch = 64;
    static int widthPitch = 32;

    public void init(mainThread mainThread2, ArgTable argTable) {
        block3: {
            try {
                this.thread = mainThread2;
                String string = (String)argTable.get("-x");
                DomRead domRead = new DomRead();
                domRead.read(string);
                this.set(domRead);
                this.thread.setFilter(domRead.getFilter());
                this.thread.setPromiscuous(domRead.getPromiscuous());
                Synthesizer synthesizer = MidiSystem.getSynthesizer();
                synthesizer.open();
                Soundbank soundbank = synthesizer.getDefaultSoundbank();
                Instrument[] instrumentArray = synthesizer.getDefaultSoundbank().getInstruments();
                synthesizer.loadInstrument(instrumentArray[0]);
                channel = synthesizer.getChannels()[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (channel == null) break block3;
                channel.allNotesOff();
            }
        }
        if (channel != null) {
            System.out.println("MIDI Channel found");
            return;
        }
        System.out.println("MIDI Initilize ERRO!!!");
    }

    public void set(DomRead domRead) {
        this.data = domRead.getTable();
        if (this.data[0] == null) {
            this.data[0] = new int[3][];
        }
        if (this.data[0][0] == null) {
            this.data[0][0] = new int[]{64, 75, 90};
        }
        if (this.data[0][1] == null) {
            this.data[0][1] = new int[]{64, 64, 64, 128, 128, 128, 128, 256};
        }
        if (this.data[0][2] == null) {
            this.data[0][2] = new int[]{0};
        }
        this.srcIgnoreHostsTCP = domRead.srcIgnoreHostsTCP;
        this.dstIgnoreHostsTCP = domRead.dstIgnoreHostsTCP;
        this.srcIgnoreHostsUDP = domRead.srcIgnoreHostsUDP;
        this.dstIgnoreHostsUDP = domRead.dstIgnoreHostsUDP;
    }

    public void receivePacket(Packet packet) {
        try {
            int[] nArray;
            this.thread.sendLog(packet.toString());
            if (this.playing || packet.data.length == 0) {
                return;
            }
            int n = 0;
            if (packet.getProtocol() == 6) {
                n = packet.getSrcPort();
                if (this.srcIgnoreHostsTCP.check(packet.getSrcIp(), packet.getSrcPort()) || this.dstIgnoreHostsTCP.check(packet.getDstIp(), packet.getDstPort())) {
                    System.out.println("Ignore:" + packet);
                    return;
                }
                if (n > packet.getDstPort()) {
                    n = packet.getDstPort();
                }
                inst = this.data[n %= this.data.length] != null && this.data[n][2] != null ? this.data[n][2][0] : (n + this.data[0][2][0]) % 128;
            } else if (packet.getProtocol() == 6) {
                try {
                    if (this.srcIgnoreHostsTCP.check(packet.getSrcIp(), packet.getSrcPort()) || this.dstIgnoreHostsTCP.check(packet.getDstIp(), packet.getDstPort())) {
                        System.out.println("Ignore:" + packet);
                        return;
                    }
                    n = packet.getSrcPort();
                    if (n > packet.getDstPort()) {
                        n = packet.getDstPort();
                    }
                    inst = this.data[n %= this.data.length] != null && this.data[n][2] != null ? this.data[n][2][0] : (n + this.data[0][2][0]) % 128;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            this.playing = true;
            int n2 = packet.data[packet.data.length / 2] % widthPitch + basePitch;
            if (packet.data.length > 0) {
                nArray = null;
                if (this.data[n] != null) {
                    nArray = this.data[n][1];
                }
                if (nArray == null) {
                    nArray = this.data[0][1];
                }
                this.duration = nArray[(128 + packet.data[packet.data.length / 2]) % nArray.length];
            }
            if (packet.data.length > 1) {
                nArray = null;
                if (this.data[n] != null) {
                    nArray = this.data[n][0];
                }
                if (nArray == null) {
                    nArray = this.data[0][0];
                }
                this.vel = nArray[(128 + packet.data[packet.data.length / 2 - 1]) % nArray.length];
            }
            if (inst > -1) {
                channel.programChange(inst);
                channel.noteOn(n2, this.vel);
                Thread.currentThread();
                Thread.sleep(this.duration);
                channel.noteOff(n2, this.vel);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.playing = false;
    }
}

