/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.myfaces.portlet.wrapper;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

import javax.servlet.http.HttpServletResponse;

/**
 * This HttpServletResponse is a dummy response to pass it to MyFaces' AddResource.
 * 
 * @author <a href="mailto:shinsuke@yahoo.co.jp">Shinsuke Sugaya</a>
 *
 */
public class HttpServletResponseWrapper extends javax.servlet.http.HttpServletResponseWrapper
{
    /**
     * Dummy writer to store elements, such as &lt;script&gt; and &lt;link&gt;.
     */
    private Writer writer;

    public HttpServletResponseWrapper(HttpServletResponse arg0)
    {
        super(arg0);
        writer = new StringWriter();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.servlet.ServletResponseWrapper#getWriter()
     */
    public PrintWriter getWriter() throws IOException
    {
        return new PrintWriter(writer);
    }

    /**
     * Returns writer to which MyFaces' AddResource stores elements.
     * 
     * @return writer which has elements, such as &lt;script&gt; and &lt;link&gt;
     */
    public StringWriter getStringWriter()
    {
        return (StringWriter) writer;
    }

}
