package jp.sf.pal.blog.portlet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.util.BlogMessaging;

public class BlogViewPortlet extends BlogGenericPortlet
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogViewPortlet.class);

    /* (non-Javadoc)
     * @see jp.sf.pal.blog.portlet.BlogGenericPortlet#processAction(javax.portlet.ActionRequest, javax.portlet.ActionResponse)
     */
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException
    {
        String blogId = request.getParameter(BlogConstants.BLOG_REDIRECT_ID);
        if (log.isDebugEnabled())
        {
            log.debug("processAction(ActionRequest, ActionResponse) -  : blogId=" + blogId);
        }
        if (blogId != null)
        {
            BlogMessaging.publishForView(BlogConstants.BLOG_MESSAGE_ID, new Long(blogId));
        }
        super.processAction(request, response);
    }

}
