/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.servlet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.pal.blog.BlogConstants;

public class BlogRedirectServlet extends HttpServlet
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogRedirectServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
    {
        String blogId = request.getParameter(BlogConstants.BLOG_MESSAGE_ID);
        String url = request.getParameter(BlogConstants.BLOG_URL);
        if (log.isDebugEnabled())
        {
            log.debug("doGet(HttpServletRequest, HttpServletResponse) -  : blogId=" + blogId + ", url=" + url);
        }

        if (blogId != null)
        {
            if (log.isDebugEnabled())
            {
                log.debug("doGet(HttpServletRequest, HttpServletResponse) -  : request.getSession().getId()="
                        + request.getSession().getId());
                for (Enumeration e = request.getSession().getAttributeNames(); e.hasMoreElements();)
                {
                    String key = (String) e.nextElement();
                    Object value = request.getSession().getAttribute(key);
                    log.debug("key = " + key + ", value = " + value);
                }
            }
            //BlogMessaging.publishToAll(BlogConstants.BLOG_MESSAGE_ID, blogId);
            request.getSession().setAttribute(BlogConstants.BLOG_ALL_TOPIC + ":" + BlogConstants.BLOG_MESSAGE_ID,
                    blogId);
            request.getSession().setAttribute(BlogConstants.BLOG_EDIT_TOPIC + ":" + BlogConstants.BLOG_MESSAGE_ID,
                    blogId);
            request.getSession().setAttribute(BlogConstants.BLOG_VIEW_TOPIC + ":" + BlogConstants.BLOG_MESSAGE_ID,
                    blogId);
        }
        else
        {
            log.error("Blog ID is null.");
        }

        if (url != null)
        {
            String redirectUrl = URLDecoder.decode(url, BlogConstants.UTF_8);
            response.sendRedirect(redirectUrl);
        }
        else
        {
            log.error("The given url is null.");
            // TODO
            response.sendError(HttpServletResponse.SC_NOT_FOUND);
        }
    }

}
