/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.NotSerializableException;

import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;

import jp.sf.pal.blog.BlogConstants;

import org.apache.portals.messaging.PortletMessaging;

public class BlogMessaging
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogMessaging.class);

    public static final void publishToAll(String messageName, Object message) throws NotSerializableException,
            ClassCastException
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest)
        {
            if (log.isDebugEnabled())
            {
                log.debug("publishToAll(ExternalContext, String, Object) -  : messageName=" + messageName
                        + ", message=" + message);
            }

            PortletMessaging.publish((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_ALL_TOPIC, messageName, message);
            PortletMessaging.publish((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_VIEW_TOPIC, messageName, message);
            PortletMessaging.publish((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_EDIT_TOPIC, messageName, message);
        }
        else
        {
            throw new ClassCastException(
                    "FacesContext.getCurrentInstance().getExternalContext().getRequest() is not PortletRequest.");
        }
    }

    public static final void publishForEdit(String messageName, Object message) throws NotSerializableException,
            ClassCastException
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest)
        {
            if (log.isDebugEnabled())
            {
                log.debug("publishForEdit(ExternalContext, String, Object) -  : messageName=" + messageName
                        + ", message=" + message);
            }

            PortletMessaging.publish((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_VIEW_TOPIC, messageName, message);
        }
        else
        {
            throw new ClassCastException(
                    "FacesContext.getCurrentInstance().getExternalContext().getRequest() is not PortletRequest.");
        }
    }

    public static final void publishForView(String messageName, Object message) throws NotSerializableException,
            ClassCastException
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest)
        {
            if (log.isDebugEnabled())
            {
                log.debug("publishForView(ExternalContext, String, Object) -  : messageName=" + messageName
                        + ", message=" + message);
            }

            PortletMessaging.publish((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_VIEW_TOPIC, messageName, message);
        }
        else
        {
            throw new ClassCastException(
                    "FacesContext.getCurrentInstance().getExternalContext().getRequest() is not PortletRequest.");
        }
    }

    public static final Object consume(String messageName) throws ClassCastException
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest)
        {
            if (log.isDebugEnabled())
            {
                log.debug("consume(ExternalContext, String) -  : messageName=" + messageName);
            }

            cancelForEdit(messageName);
            cancelForView(messageName);

            return PortletMessaging.consume((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_ALL_TOPIC, messageName);
        }
        else
        {
            throw new ClassCastException(
                    "FacesContext.getCurrentInstance().getExternalContext().getRequest() is not PortletRequest.");
        }
    }

    public static final Object consumeForView(String messageName) throws ClassCastException
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest)
        {
            if (log.isDebugEnabled())
            {
                log.debug("consumeForView(ExternalContext, String) -  : messageName=" + messageName);
            }

            return PortletMessaging.consume((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_VIEW_TOPIC, messageName);
        }
        else
        {
            throw new ClassCastException(
                    "FacesContext.getCurrentInstance().getExternalContext().getRequest() is not PortletRequest.");
        }
    }

    public static final Object consumeForEdit(String messageName) throws ClassCastException
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest)
        {
            if (log.isDebugEnabled())
            {
                log.debug("consumeForEdit(ExternalContext, String) -  : messageName=" + messageName);
            }

            return PortletMessaging.consume((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_EDIT_TOPIC, messageName);
        }
        else
        {
            throw new ClassCastException(
                    "FacesContext.getCurrentInstance().getExternalContext().getRequest() is not PortletRequest.");
        }
    }

    public static final Object receive(String messageName) throws ClassCastException
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest)
        {
            if (log.isDebugEnabled())
            {
                log.debug("receive(ExternalContext, String) -  : messageName=" + messageName);
            }

            return PortletMessaging.receive((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_ALL_TOPIC, messageName);
        }
        else
        {
            throw new ClassCastException(
                    "FacesContext.getCurrentInstance().getExternalContext().getRequest() is not PortletRequest.");
        }
    }

    public static final Object receiveForView(String messageName) throws ClassCastException
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest)
        {
            if (log.isDebugEnabled())
            {
                log.debug("receiveForView(ExternalContext, String) -  : messageName=" + messageName);
            }

            return PortletMessaging.receive((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_VIEW_TOPIC, messageName);
        }
        else
        {
            throw new ClassCastException(
                    "FacesContext.getCurrentInstance().getExternalContext().getRequest() is not PortletRequest.");
        }
    }

    public static final Object receiveForEdit(String messageName) throws ClassCastException
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest)
        {
            if (log.isDebugEnabled())
            {
                log.debug("receiveForEdit(ExternalContext, String) -  : messageName=" + messageName);
            }

            return PortletMessaging.receive((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_EDIT_TOPIC, messageName);
        }
        else
        {
            throw new ClassCastException(
                    "FacesContext.getCurrentInstance().getExternalContext().getRequest() is not PortletRequest.");
        }
    }

    public static final void cancel(String messageName) throws ClassCastException
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest)
        {
            if (log.isDebugEnabled())
            {
                log.debug("cancel(ExternalContext, String) -  : messageName=" + messageName);
            }

            PortletMessaging.cancel((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_ALL_TOPIC, messageName);
            PortletMessaging.cancel((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_VIEW_TOPIC, messageName);
            PortletMessaging.cancel((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_EDIT_TOPIC, messageName);
        }
        else
        {
            throw new ClassCastException(
                    "FacesContext.getCurrentInstance().getExternalContext().getRequest() is not PortletRequest.");
        }
    }

    public static final void cancelForView(String messageName) throws ClassCastException
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest)
        {
            if (log.isDebugEnabled())
            {
                log.debug("cancelForView(ExternalContext, String) -  : messageName=" + messageName);
            }

            PortletMessaging.cancel((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_VIEW_TOPIC, messageName);
        }
        else
        {
            throw new ClassCastException(
                    "FacesContext.getCurrentInstance().getExternalContext().getRequest() is not PortletRequest.");
        }
    }

    public static final void cancelForEdit(String messageName) throws ClassCastException
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest)
        {
            if (log.isDebugEnabled())
            {
                log.debug("cancelForEdit(ExternalContext, String) -  : messageName=" + messageName);
            }

            PortletMessaging.cancel((PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
                    .getRequest(), BlogConstants.BLOG_EDIT_TOPIC, messageName);
        }
        else
        {
            throw new ClassCastException(
                    "FacesContext.getCurrentInstance().getExternalContext().getRequest() is not PortletRequest.");
        }
    }

}
