/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.model;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

import jp.sf.pal.blog.AbstractTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.marevol.utils.hibernate.HibernateUtil;

public class BlogMessageTest extends AbstractTestCase
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogMessageTest.class);

    public static Long testId = null;

    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception
    {
        if (log.isDebugEnabled())
        {
            log.debug("setUp() - start");
        }

        // TODO Auto-generated method stub
        super.setUp();

        if (log.isDebugEnabled())
        {
            log.debug("setUp() - end");
        }
    }

    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public BlogMessageTest(String testName)
    {
        super(testName);
    }

    /**
     * @return the suite of tests being tested
     */
    public static Test suite()
    {
        if (log.isDebugEnabled())
        {
            log.debug("suite() - start");
        }

        TestSuite suite = new TestSuite();
        suite.addTest(new BlogMessageTest("addBlogMessage"));
        suite.addTest(new BlogMessageTest("deleteBlogMessage"));

        if (log.isDebugEnabled())
        {
            log.debug("suite() - end");
        }
        return suite;
    }

    public void addBlogMessage()
    {
        if (log.isDebugEnabled())
        {
            log.debug("addBlogmessage() - start");
        }

        HashMap map = new HashMap();
        map.put(HibernateUtil.WEBAPP_ROOT, getTestFile("src" + File.separator + "webapp"));
        HibernateUtil.init(map);

        HibernateUtil.openSession();
        HibernateUtil.beginTransaction();

        BlogMessage blogMsg = new BlogMessage();
        blogMsg.setOwner("testuser");
        Date now = Calendar.getInstance().getTime();
        blogMsg.setCreatedtime(now);
        blogMsg.setUpdatedtime(now);
        blogMsg.setFormattype("TEXT");
        blogMsg.setTitle("TITLE");
        blogMsg.setMessage("FOO foo Foo!");

        testId = (Long) HibernateUtil.save(blogMsg);

        HibernateUtil.commit();
        HibernateUtil.closeSession();

        assertNotNull(testId);

        if (log.isDebugEnabled())
        {
            log.debug("addBlogmessage() - end");
        }
    }

    public void deleteBlogMessage()
    {
        if (log.isDebugEnabled())
        {
            log.debug("deleteStatistics() - start");
        }

        HashMap map = new HashMap();
        map.put(HibernateUtil.WEBAPP_ROOT, getTestFile("src" + File.separator + "webapp"));
        HibernateUtil.init(map);

        HibernateUtil.openSession();
        HibernateUtil.beginTransaction();

        BlogMessage blogMsg = (BlogMessage) HibernateUtil.get(BlogMessage.class, testId);
        HibernateUtil.delete(blogMsg);

        HibernateUtil.commit();

        assertNull((BlogMessage) HibernateUtil.get(BlogMessage.class, testId));

        HibernateUtil.closeSession();

        if (log.isDebugEnabled())
        {
            log.debug("deleteStatistics() - end");
        }
    }

}
