package jp.sf.pal.yahoosearch.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.marevol.utils.portlet.faces.bean.FacesPortletBean;
import com.marevol.utils.ynd.search.WebSearch;
import com.marevol.utils.ynd.search.model.v1.web.Result;
import com.marevol.utils.ynd.search.model.v1.web.ResultSet;

import java.io.IOException;

public class SearchPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(SearchPageBean.class);

    private SearchSessionBean searchSession;

    private FacesPortletBean facesPortlet;

    private ResultSet resultSet;

    private boolean init = false;

    public String search()
    {
        searchSession.setStartPosition(new Integer(1));
        return null;
    }

    public String previousPage()
    {
        int newPosition = getSearchSession().getStartPosition().intValue()
                - getSearchSession().getMaxResults().intValue();
        getSearchSession().setStartPosition(new Integer(newPosition));
        if (log.isDebugEnabled())
        {
            log.debug("previousPage() -  : getSearchSession().getStartPosition().intValue()=" + getSearchSession().getStartPosition().intValue());
            log.debug("previousPage() -  : getSearchSession().getMaxResults().intValue()=" + getSearchSession().getMaxResults().intValue());
            log.debug("previousPage() -  : newPosition=" + newPosition);
        }
        return null;
    }

    public String nextPage()
    {
        int newPosition = getSearchSession().getStartPosition().intValue()
                + getSearchSession().getMaxResults().intValue();
        getSearchSession().setStartPosition(new Integer(newPosition));
        if (log.isDebugEnabled())
        {
            log.debug("nextPage() -  : getSearchSession().getStartPosition().intValue()=" + getSearchSession().getStartPosition().intValue());
            log.debug("nextPage() -  : getSearchSession().getMaxResults().intValue()=" + getSearchSession().getMaxResults().intValue());
            log.debug("nextPage() -  : newPosition=" + newPosition);
        }
        return null;
    }

    private void init()
    {
        if (init)
        {
            return;
        }
        if (searchSession != null)
        {
            WebSearch yws = new WebSearch();
            try
            {
                resultSet = yws.search(searchSession.getApplicationId(), searchSession.getQuery(), searchSession
                        .getMaxResults().intValue(), searchSession.getStartPosition().intValue());
            }
            catch (IOException e)
            {
                if (facesPortlet != null)
                {
                    facesPortlet.addMsgError("I/O error occurs on search.");
                }
                log.error(e);
            }
            if (resultSet == null)
            {
                resultSet = new ResultSet();
                resultSet.setFirstResultPosition(new Integer(1));
                resultSet.setTotalResultsAvailable(new Integer(0));
                resultSet.setTotalResultsReturned(new Integer(0));
            }
        }
        init = true;
    }

    //Setter and Getter

    public Boolean getPreviousPage()
    {
        init();
        int newPosition = getSearchSession().getStartPosition().intValue()
                - getSearchSession().getMaxResults().intValue();
        if (newPosition > 0)
        {
            return Boolean.TRUE;
        }
        else
        {
            return Boolean.FALSE;
        }
    }

    public Boolean getNextPage()
    {
        init();
        int newPosition = getSearchSession().getStartPosition().intValue()
                + getSearchSession().getMaxResults().intValue();
        if (newPosition < resultSet.getTotalResultsAvailable().intValue())
        {
            return Boolean.TRUE;
        }
        else
        {
            return Boolean.FALSE;
        }
    }

    /**
     * @return Returns the searchSession.
     */
    public SearchSessionBean getSearchSession()
    {
        return searchSession;
    }

    /**
     * @param searchSession The searchSession to set.
     */
    public void setSearchSession(SearchSessionBean searchSession)
    {
        this.searchSession = searchSession;
    }

    public Result[] getResults()
    {
        init();
        if (resultSet != null)
        {
            return resultSet.getResults();
        }
        else
        {
            return null;
        }
    }

    /**
     * @return Returns the facesPortlet.
     */
    public FacesPortletBean getFacesPortlet()
    {
        return facesPortlet;
    }

    /**
     * @param facesPortlet The facesPortlet to set.
     */
    public void setFacesPortlet(FacesPortletBean facesPortlet)
    {
        this.facesPortlet = facesPortlet;
    }

    /**
     * @return Returns the resultSet.
     */
    public ResultSet getResultSet()
    {
        return resultSet;
    }

    /**
     * @param resultSet The resultSet to set.
     */
    public void setResultSet(ResultSet resultSet)
    {
        this.resultSet = resultSet;
    }

}
