/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import java.io.IOException;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.model.BlogComment;

import com.marevol.utils.portlet.faces.PortletPreferencesUtil;

public class BlogCommentTitleViewSessionBean
{

    public BlogCommentTitleViewSessionBean()
    {
        super();
    }

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {
        return new Integer(PortletPreferencesUtil.getValue(BlogConstants.TITLE_VIEW_PAGE_SIZE, Integer
                .toString(BlogConstants.DEFAULT_PAGE_SIZE)));
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer maxResults) throws IOException
    {
        PortletPreferencesUtil.setValue(BlogConstants.TITLE_VIEW_PAGE_SIZE, maxResults.toString());
    }

    /**
     * @return Returns the owner.
     */
    public String getOwner()
    {
        return PortletPreferencesUtil.getValue(BlogConstants.TITLE_VIEW_OWNER, "");
    }

    /**
     * @param owner The owner to set.
     */
    public void setOwner(String owner) throws IOException
    {
        PortletPreferencesUtil.setValue(BlogConstants.TITLE_VIEW_OWNER, owner);
    }

    /**
     * @return Returns the sortColumn.
     */
    public String getSortColumn()
    {
        return PortletPreferencesUtil.getValue(BlogConstants.TITLE_VIEW_SORT_COLUMN, BlogComment.CREATEDTIME);
    }

    /**
     * @param sortColumn The sortColumn to set.
     */
    public void setSortColumn(String sortColumn) throws IOException
    {
        PortletPreferencesUtil.setValue(BlogConstants.TITLE_VIEW_SORT_COLUMN, sortColumn);
    }

    public Boolean getDisplayCreatedtime()
    {
        return new Boolean(PortletPreferencesUtil.getValue(BlogConstants.TITLE_VIEW_DISPLAY_CREATEDTIME,
                BlogConstants.FALSE));
    }

    public void setDisplayCreatedtime(Boolean flag) throws IOException
    {
        PortletPreferencesUtil.setValue(BlogConstants.TITLE_VIEW_DISPLAY_CREATEDTIME, flag.toString());
    }

    //    public Boolean getDisplayUpdatedtime()
    //    {
    //        return new Boolean(PortletPreferencesUtil.getValue(BlogConstants.TITLE_VIEW_DISPLAY_UPDATEDTIME,
    //                BlogConstants.FALSE));
    //    }
    //
    //    public void setDisplayUpdatedtime(Boolean flag) throws IOException
    //    {
    //        PortletPreferencesUtil.setValue(BlogConstants.TITLE_VIEW_DISPLAY_UPDATEDTIME, flag.toString());
    //    }
}
