/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.portlet.faces.PortletPreferencesUtil;
import com.marevol.utils.portlet.faces.PortletResourceBundleUtil;

import java.io.IOException;
import java.util.ArrayList;

import javax.faces.context.FacesContext;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.model.BlogTrackback;

public class BlogTrackbackTitleViewEditPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogTrackbackTitleViewEditPageBean.class);

    private String owner;

    private String sortColumn;

    private Integer pageSize;

    private Object[] displayedItems;

    private BlogTrackbackTitleViewSessionBean trackbackTitleViewSession;

    public String save()
    {
        if (log.isDebugEnabled())
        {
            log.debug("save() - start");
        }

        try
        {
            getTrackbackTitleViewSession().setOwner(owner);
            getTrackbackTitleViewSession().setPageSize(pageSize);
            //            getTitleViewSession().setSortColumn(sortColumn);

            if (displayedItems != null)
            {
                String createdtime = BlogConstants.FALSE;
                //                String updatedtime = BlogConstants.FALSE;
                for (int i = 0; i < displayedItems.length; i++)
                {
                    if (displayedItems[i].equals(BlogTrackback.CREATEDTIME))
                    {
                        createdtime = BlogConstants.TRUE;
                        //                    }
                        //                    else if (displayedItems[i].equals(BlogTrackback.UPDATEDTIME))
                        //                    {
                        //                        updatedtime = BlogConstants.TRUE;
                    }
                }

                if (!getTrackbackTitleViewSession().getDisplayCreatedtime().equals(createdtime))
                {
                    getTrackbackTitleViewSession().setDisplayCreatedtime(new Boolean(createdtime));
                }
                //                if (!getTitleViewSession().getDisplayUpdatedtime().equals(updatedtime))
                //                {
                //                    getTitleViewSession().setDisplayUpdatedtime(new Boolean(updatedtime));
                //                }

                PortletPreferencesUtil.store();

                // i18n
                FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil
                        .getString("blogtrackbacktitleview.UpdatedParameters"));

            }
            else
            {
                // i18n
                FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil
                        .getString("blogtrackbacktitleview.TheSpecifiedItemsAreInvalid"));
                if (log.isDebugEnabled())
                {
                    log.debug("setDisplayedItems(Object[]) - items is null.");
                }
            }

        }
        catch (IOException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil
                    .getString("blogtrackbacktitleview.SystemErrorOccurs"), e.toString());
            log.error(e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("save() - end");
        }
        return null;
    }

    public String reset()
    {
        if (log.isDebugEnabled())
        {
            log.debug("reset() - start");
        }

        try
        {
            getTrackbackTitleViewSession().setOwner(
                    FacesContext.getCurrentInstance().getExternalContext().getRemoteUser());
            getTrackbackTitleViewSession().setPageSize(new Integer(BlogConstants.DEFAULT_PAGE_SIZE));
            getTrackbackTitleViewSession().setSortColumn(BlogTrackback.CREATEDTIME);
            getTrackbackTitleViewSession().setDisplayCreatedtime(new Boolean(BlogConstants.FALSE));
            //            getTitleViewSession().setDisplayUpdatedtime(new Boolean(BlogConstants.FALSE));

            PortletPreferencesUtil.store();

            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil
                    .getString("blogtrackbacktitleview.UpdatedToDefaultParameters"));
        }
        catch (IOException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil
                    .getString("blogtrackbacktitleview.SystemErrorOccurs"), e.toString());
            log.error(e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("reset() - end");
        }
        return null;
    }

    // Setter and Getter

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getPageSize() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getPageSize() - end");
        }
        //        return pageSize;
        return trackbackTitleViewSession.getPageSize();
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer number)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setPageSize(Integer) - start");
        }

        this.pageSize = number;

        if (log.isDebugEnabled())
        {
            log.debug("setPageSize(Integer) - end");
        }
    }

    /**
     * @return Returns the owner.
     */
    public String getOwner()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getOwner() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getOwner() - end");
        }
        //return owner;
        return trackbackTitleViewSession.getOwner();
    }

    /**
     * @param owner The owner to set.
     */
    public void setOwner(String targetUser)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setOwner(String) - start");
        }

        this.owner = targetUser;

        if (log.isDebugEnabled())
        {
            log.debug("setOwner(String) - end");
        }
    }

    /**
     * @return Returns the trackbackTitleViewSession.
     */
    public BlogTrackbackTitleViewSessionBean getTrackbackTitleViewSession()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - end");
        }
        return trackbackTitleViewSession;
    }

    /**
     * @param trackbackTitleViewSession The trackbackTitleViewSession to set.
     */
    public void setTrackbackTitleViewSession(BlogTrackbackTitleViewSessionBean titleViewPortlet)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogTrackbackTitleViewSessionBean) - start");
        }

        this.trackbackTitleViewSession = titleViewPortlet;

        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogTrackbackTitleViewSessionBean) - end");
        }
    }

    /**
     * @return Returns the sortColumn.
     */
    public String getSortColumn()
    {
        return getTrackbackTitleViewSession().getSortColumn();
    }

    /**
     * @param sortColumn The sortColumn to set.
     */
    public void setSortColumn(String sortColumn)
    {
        this.sortColumn = sortColumn;
    }

    public Object[] getDisplayedItems()
    {
        ArrayList items = new ArrayList();
        if (getTrackbackTitleViewSession().getDisplayCreatedtime().booleanValue())
        {
            items.add(BlogTrackback.CREATEDTIME);
        }
        //        if (getTitleViewSession().getDisplayUpdatedtime().booleanValue())
        //        {
        //            items.add(BlogTrackback.UPDATEDTIME);
        //        }
        return items.toArray();
    }

    public void setDisplayedItems(Object[] items)
    {
        displayedItems = items;
    }

}
