/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.model;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

import jp.sf.pal.blog.BlogConstants;

import org.apache.commons.lang.StringUtils;

import com.marevol.utils.faces.util.DateFormatUtil;

/**
 * BlogTrackback generated by hbm2java
 */
public class BlogTrackback implements java.io.Serializable
{

    /**
     * 
     */
    private static final long serialVersionUID = 8745572618691154783L;

    public static final String ID = "id";

    public static final String TITLE = "title";

    public static final String EXCERPT = "excerpt";

    public static final String URL = "url";

    public static final String BLOGNAME = "blogname";

    public static final String CREATEDTIME = "createdtime";

    // Fields    

    private Long id;

    private BlogMessage blogMessage;

    private String title;

    private String excerpt;

    private String url;

    private String blogname;

    private Date createdtime;

    // Constructors

    /** default constructor */
    public BlogTrackback()
    {
    }

    /** constructor with id */
    public BlogTrackback(Long id)
    {
        this.id = id;
    }

    // Property accessors

    /**
     * 
     */
    public Long getId()
    {
        return this.id;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    /**
     * 
     */
    public BlogMessage getBlogMessage()
    {
        return this.blogMessage;
    }

    public void setBlogMessage(BlogMessage blogMessage)
    {
        this.blogMessage = blogMessage;
    }

    /**
     * 
     */
    public String getTitle()
    {
        return this.title;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    /**
     * 
     */
    public String getExcerpt()
    {
        return this.excerpt;
    }

    public void setExcerpt(String excerpt)
    {
        this.excerpt = excerpt;
    }

    /**
     * 
     */
    public String getUrl()
    {
        return this.url;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    /**
     * 
     */
    public String getBlogname()
    {
        return this.blogname;
    }

    public void setBlogname(String blogname)
    {
        this.blogname = blogname;
    }

    /**
     * 
     */
    public Date getCreatedtime()
    {
        return this.createdtime;
    }

    public void setCreatedtime(Date createdtime)
    {
        this.createdtime = createdtime;
    }

    public Boolean getDeleteEnabled()
    {
        String user = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        if (user == null)
        {
            return Boolean.FALSE;
        }

        if (user.equals(getBlogMessage().getOwner()))
        {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;

    }

    public String getFormattedCreatedtime()
    {
        return DateFormatUtil.getMediumFormattedDateTime(getCreatedtime());
    }

    public String getAbbreviatedTitle()
    {
        return getAbbreviatedTitle(BlogConstants.DEFAULT_TITLE_MAX_LENGTH);
    }

    public String getAbbreviatedTitle(int maxLength)
    {
        return StringUtils.abbreviate(getTitle(), maxLength);
    }

    public void setAbbreviatedTitle(String msg)
    {
        setTitle(msg);
    }
}
