/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.lock.UpgradeException;
import org.jboss.logging.Logger;

public class Node
implements Externalizable {
    Object name = null;
    Fqn fqn = null;
    Node parent = null;
    Map children = null;
    final transient Object childrenMutex = new Object();
    Map data = null;
    final transient Object dataMutex = new Object();
    transient IdentityLock lock_ = null;
    public static final int LOCK_TYPE_READ = 1;
    public static final int LOCK_TYPE_WRITE = 2;
    static transient Logger log = Logger.getLogger((Class)(class$org$jboss$cache$Node == null ? (class$org$jboss$cache$Node = Node.class$("org.jboss.cache.Node")) : class$org$jboss$cache$Node));
    transient TreeCache cache;
    protected static final int INDENT = 4;
    public static final transient boolean PRINT_LOCK_DETAILS = Boolean.getBoolean("print_lock_details");
    static /* synthetic */ Class class$org$jboss$cache$Node;

    public Node() {
    }

    public Node(Object child_name, Fqn fqn, Node parent, Map data, TreeCache cache) {
        this.init(child_name, fqn, parent, cache);
        if (data != null) {
            this.data().putAll(data);
        }
    }

    public Node(Object child_name, Fqn fqn, Node parent, Object key, Object value, TreeCache cache) {
        this.init(child_name, fqn, parent, cache);
        this.data().put(key, value);
    }

    protected void init(Object child_name, Fqn fqn, Node parent, TreeCache cache) {
        this.cache = cache;
        this.name = child_name;
        this.fqn = fqn;
        this.parent = parent;
        this.init();
    }

    protected void init() {
        this.lock_ = new IdentityLock(this.cache, this.fqn);
    }

    protected Map initChildren() {
        return new ConcurrentReaderHashMap();
    }

    protected Map initData() {
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map children() {
        Object object = this.childrenMutex;
        synchronized (object) {
            if (this.children == null) {
                this.children = this.initChildren();
            }
            return this.children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map data() {
        Object object = this.dataMutex;
        synchronized (object) {
            if (this.data == null) {
                this.data = this.initData();
            }
            return this.data;
        }
    }

    void setTreeCacheInstance(TreeCache cache) {
        this.cache = cache;
    }

    void setRecursiveTreeCacheInstance(TreeCache cache) {
        this.cache = cache;
        if (this.children != null) {
            Iterator it = this.children.keySet().iterator();
            while (it.hasNext()) {
                Node nd = (Node)this.children.get(it.next());
                nd.setRecursiveTreeCacheInstance(cache);
            }
        }
    }

    public Object getName() {
        return this.name;
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public Object get(Object key) {
        return this.data == null ? null : this.data.get(key);
    }

    public boolean containsKey(Object key) {
        return this.data == null ? false : this.data.containsKey(key);
    }

    public Node getChild(Object child_name) {
        if (child_name == null) {
            return null;
        }
        return this.children == null ? null : (Node)this.children.get(child_name);
    }

    public Node getParent() {
        return this.parent;
    }

    public Set getDataKeys() {
        return this.data != null ? this.data.keySet() : null;
    }

    public boolean childExists(Object child_name) {
        if (child_name == null) {
            return false;
        }
        return this.children != null ? this.children.containsKey(child_name) : false;
    }

    boolean isReadLocked() {
        return this.lock_ != null ? this.lock_.isReadLocked() : false;
    }

    boolean isWriteLocked() {
        return this.lock_ != null ? this.lock_.isWriteLocked() : false;
    }

    boolean isLocked() {
        return this.isWriteLocked() || this.isReadLocked();
    }

    public IdentityLock getImmutableLock() {
        return this.lock_;
    }

    public IdentityLock getLock() {
        return this.lock_;
    }

    public Map getChildren() {
        return this.children;
    }

    public Map getData() {
        if (this.data == null) {
            return null;
        }
        return new HashMap(this.data);
    }

    public int numAttributes() {
        return this.data != null ? this.data.size() : 0;
    }

    public boolean hasChild() {
        return this.hasChildren();
    }

    public boolean hasChildren() {
        return this.children != null ? this.children.size() > 0 : false;
    }

    public void put(Map data, boolean erase) {
        if (erase && this.data != null) {
            this.data.clear();
        }
        if (data == null) {
            return;
        }
        this.data().putAll(data);
    }

    public void put(Map data) {
        this.put(data, false);
    }

    public Object put(Object key, Object value) {
        return this.data().put(key, value);
    }

    public Node createChild(Object child_name, Fqn fqn, Node parent) {
        Node child = null;
        if (child_name == null) {
            return null;
        }
        child = (Node)this.children().get(child_name);
        if (child == null) {
            child = new Node(child_name, fqn, parent, null, this.cache);
            this.children.put(child_name, child);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("createChild: fqn=" + fqn + ", child_name=" + child_name));
        }
        return child;
    }

    public Node createChild(Object child_name, Fqn fqn, Node parent, Map data) {
        Node child = null;
        if (child_name == null) {
            return null;
        }
        child = (Node)this.children().get(child_name);
        if (child != null) {
            child.put(data);
        } else {
            child = new Node(child_name, fqn, parent, data, this.cache);
            this.children.put(child_name, child);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("createChild: fqn=" + fqn + ", child_name=" + child_name));
        }
        return child;
    }

    public Node createChild(Object child_name, Fqn fqn, Node parent, Object key, Object value) {
        Node child = null;
        if (child_name == null) {
            return null;
        }
        child = (Node)this.children().get(child_name);
        if (child != null) {
            child.put(key, value);
        } else {
            child = new Node(child_name, fqn, parent, key, value, this.cache);
            this.children.put(child_name, child);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("createChild: fqn=" + fqn + ", child_name=" + child_name));
        }
        return child;
    }

    void addChild(Object child_name, Node n) {
        if (child_name == null) {
            return;
        }
        this.children().put(child_name, n);
    }

    public Object remove(Object key) {
        return this.data != null ? this.data.remove(key) : null;
    }

    public void clear() {
        if (this.data != null) {
            this.data.clear();
            this.data = null;
        }
    }

    public void removeChild(Object child_name) {
        if (this.children != null) {
            this.children.remove(child_name);
            if (log.isTraceEnabled()) {
                log.trace((Object)("removed child " + child_name));
            }
        }
    }

    public void removeAllChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public void print(StringBuffer sb, int indent) {
        this.printIndent(sb, indent);
        sb.append("/").append(this.name);
        if (this.children != null && this.children.size() > 0) {
            Collection values = this.children.values();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                sb.append("\n");
                ((Node)it.next()).print(sb, indent + 4);
            }
        }
    }

    public void printDetails(StringBuffer sb, int indent) {
        this.printIndent(sb, indent);
        sb.append("/").append(this.name);
        sb.append("\n");
        if (this.data != null) {
            Iterator it = this.data.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        if (this.children != null && this.children.size() > 0) {
            Collection values = this.children.values();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                sb.append("\n");
                ((Node)it.next()).printDetails(sb, indent);
            }
        }
    }

    public void printLockInfo(StringBuffer sb, int indent) {
        boolean locked = this.lock_ != null ? this.lock_.isLocked() : false;
        this.printIndent(sb, indent);
        sb.append("/").append(this.name);
        if (locked) {
            sb.append("\t(");
            this.lock_.toString(sb);
            sb.append(")");
        }
        if (this.children != null && this.children.size() > 0) {
            Collection values = this.children.values();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                sb.append("\n");
                ((Node)it.next()).printLockInfo(sb, indent + 4);
            }
        }
    }

    public void printIndent(StringBuffer sb, int indent) {
        if (sb != null) {
            for (int i = 0; i < indent; ++i) {
                sb.append(" ");
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.name != null) {
            sb.append("\nname=" + this.name);
        }
        if (this.fqn != null) {
            sb.append("\nfqn=" + this.fqn);
        }
        if (this.data != null) {
            sb.append("\ndata=" + this.data);
        }
        if (this.lock_ != null) {
            sb.append("\n read locked=").append(this.isReadLocked());
            sb.append("\n write locked=").append(this.isWriteLocked());
        }
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        Node n = new Node(this.name, this.fqn != null ? (Fqn)this.fqn.clone() : null, this.parent != null ? (Node)this.parent.clone() : null, this.data, this.cache);
        n.children = this.children == null ? null : (HashMap)((HashMap)this.children).clone();
        return n;
    }

    public boolean acquire(Object caller, long timeout, int lock_type) throws LockingException, TimeoutException, InterruptedException {
        try {
            if (lock_type == 1) {
                return this.acquireReadLock(caller, timeout);
            }
            return this.acquireWriteLock(caller, timeout);
        }
        catch (UpgradeException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("failure upgrading lock: fqn=" + this.fqn + ", caller=" + caller + ", lock=" + this.lock_.toString(true)));
            }
            throw e;
        }
        catch (LockingException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("failure acquiring lock: fqn=" + this.fqn + ", caller=" + caller + ", lock=" + this.lock_.toString(true)));
            }
            throw e;
        }
        catch (TimeoutException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("failure acquiring lock: fqn=" + this.fqn + ", caller=" + caller + ", lock=" + this.lock_.toString(true)));
            }
            throw e;
        }
    }

    protected boolean acquireReadLock(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        if (log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("acquiring RL: fqn=").append(this.fqn).append(", caller=").append(caller);
            sb.append(", lock=").append(this.lock_.toString(PRINT_LOCK_DETAILS));
            log.trace((Object)sb.toString());
        }
        boolean flag = this.lock_.acquireReadLock(caller, timeout);
        if (log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("acquired RL: fqn=").append(this.fqn).append(", caller=").append(caller);
            sb.append(", lock=").append(this.lock_.toString(PRINT_LOCK_DETAILS));
            log.trace((Object)sb.toString());
        }
        return flag;
    }

    protected boolean acquireWriteLock(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        if (log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("acquiring WL: fqn=").append(this.fqn).append(", caller=").append(caller);
            sb.append(", lock=").append(this.lock_.toString(PRINT_LOCK_DETAILS));
            log.trace((Object)sb.toString());
        }
        boolean flag = this.lock_.acquireWriteLock(caller, timeout);
        if (log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("acquired WL: fqn=").append(this.fqn).append(", caller=").append(caller);
            sb.append(", lock=").append(this.lock_.toString(PRINT_LOCK_DETAILS));
            log.trace((Object)sb.toString());
        }
        return flag;
    }

    public Set acquireAll(Object caller, long timeout, int lock_type) throws LockingException, TimeoutException, InterruptedException {
        LinkedHashSet<IdentityLock> retval = new LinkedHashSet<IdentityLock>();
        boolean acquired = this.acquire(caller, timeout, lock_type);
        if (acquired) {
            retval.add(this.getLock());
        }
        if (this.children != null) {
            Iterator it = this.children.values().iterator();
            while (it.hasNext()) {
                Node tmp = (Node)it.next();
                retval.addAll(tmp.acquireAll(caller, timeout, lock_type));
            }
        }
        return retval;
    }

    public void release(Object caller) {
        this.lock_.release(caller);
    }

    public void releaseForce() {
        this.lock_.releaseForce();
    }

    public void releaseAll(Object owner) {
        if (this.children != null) {
            Iterator it = this.children.values().iterator();
            while (it.hasNext()) {
                Node tmp = (Node)it.next();
                tmp.releaseAll(owner);
            }
        }
        this.release(owner);
    }

    public void releaseAllForce() {
        if (this.children != null) {
            Iterator it = this.children.values().iterator();
            while (it.hasNext()) {
                Node tmp = (Node)it.next();
                tmp.releaseAllForce();
            }
        }
        this.releaseForce();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.fqn);
        out.writeObject(this.parent);
        out.writeObject(this.children);
        out.writeObject(this.data);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readObject();
        this.fqn = (Fqn)in.readObject();
        this.parent = (Node)in.readObject();
        this.children = (Map)in.readObject();
        this.data = (Map)in.readObject();
        this.init();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

