/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.lang.reflect.Method;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

public class MetricsInterceptor
implements Interceptor {
    public MetricsInterceptor() {
        System.out.println("### MetricsInterceptor was created ####");
    }

    public String getName() {
        return "MetricsInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (invocation == null) {
            System.err.println("\n-- MetricsInterceptor: invocation is null !");
            return null;
        }
        try {
            System.out.println("*** MetricsInterceptor: inv=" + invocation);
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            Object[] args = methodInvocation.getArguments();
            Method meth = methodInvocation.getMethod();
            String method_name = meth != null ? meth.getName() : null;
            System.out.println("\n\n-- [MetricsInterceptor]: type=" + invocation.getClass().getName());
            if (method_name != null) {
                System.out.println("-- [MetricsInterceptor]: method_name(" + this.printArgs(args) + ")");
            }
        }
        catch (Throwable t) {
            System.err.println("\n-- [MetricsInterceptor]: error " + t);
            throw t;
        }
        return invocation.invokeNext();
    }

    String printArgs(Object[] args) {
        StringBuffer sb = new StringBuffer();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                sb.append(arg).append(" ");
            }
        }
        return sb.toString();
    }
}

