/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.eviction.AopEvictionPolicy;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.LRUAlgorithm;
import org.jboss.cache.eviction.LRUPolicy;
import org.jboss.cache.eviction.Region;

public class AopLRUPolicy
extends LRUPolicy
implements AopEvictionPolicy {
    public void nodeVisited(Fqn fqn) {
        if (this.isInternalNode(fqn)) {
            return;
        }
        Region region = this.regionManager_.getRegion(fqn.toString());
        region.setVisitedNode(fqn);
        if (!this.isAopNode(fqn)) {
            return;
        }
        this.visitChildrenRecursively(region, fqn);
    }

    protected void visitChildrenRecursively(Region region, Fqn fqn) {
        int size;
        Set set = this.getChildrenNames(fqn);
        int n = size = set == null ? 0 : set.size();
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("nodeVisited(): is an aop node. fqn- " + fqn + " size of children is " + size));
        }
        if (set == null) {
            return;
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object childName = it.next();
            Fqn fqnKid = new Fqn(fqn, childName);
            this.visitChildrenRecursively(region, fqnKid);
            region.setVisitedNode(fqnKid);
        }
    }

    private boolean isAopNode(Fqn fqn) {
        try {
            return this.cache_.peek(fqn, AOPInstance.KEY) != null;
        }
        catch (Exception e) {
            this.log_.warn((Object)("isAopNode(): cache get operation generated exception " + e));
            return false;
        }
    }

    public void nodeAdded(Fqn fqn) {
        if (this.isInternalNode(fqn)) {
            return;
        }
        super.nodeAdded(fqn);
    }

    public void nodeRemoved(Fqn fqn) {
        if (this.isInternalNode(fqn)) {
            return;
        }
        super.nodeRemoved(fqn);
    }

    public void nodeModified(Fqn fqn) {
        super.nodeModified(fqn);
    }

    protected EvictionAlgorithm getEvictionAlgorithm() {
        return new LRUAlgorithm();
    }

    protected boolean isInternalNode(Fqn fqn) {
        String startStr = (String)fqn.get(0);
        return startStr.equals(TreeCacheAop.JBOSS_INTERNAL.get(0));
    }
}

