/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.tests;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.Environment;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.CacheLoader;

public class BdbjeUnitTestCase
extends TestCase {
    private static final String envHome = ".";
    private static final Fqn FQN = new Fqn("key");
    private TreeCache treeCache;
    private CacheLoader loader;
    static /* synthetic */ Class class$org$jboss$cache$tests$BdbjeUnitTestCase;

    public BdbjeUnitTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        File dir = new File(envHome);
        class MyFilter
        implements FileFilter {
            MyFilter() {
            }

            public boolean accept(File file) {
                return file.getName().endsWith(".jdb");
            }
        }
        File[] files = dir.listFiles(new MyFilter());
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isFile() || file.delete()) continue;
                System.err.println("Unable to delete: " + file);
            }
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.loader != null) {
            try {
                this.loader.stop();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            this.loader = null;
        }
        if (this.treeCache != null) {
            try {
                this.treeCache.stopService();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.treeCache = null;
        }
    }

    private void startLoader(boolean transactional, String dbName) throws Exception {
        String configStr;
        this.treeCache = new TreeCache();
        this.treeCache.setClusterName("myCluster");
        if (transactional) {
            this.treeCache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        }
        this.treeCache.startService();
        if (dbName != null) {
            configStr = ".#" + dbName;
        } else {
            configStr = envHome;
            dbName = "myCluster";
        }
        this.instantiateLoader();
        this.loader.setCache(this.treeCache);
        Properties props = new Properties();
        props.setProperty("location", configStr);
        this.loader.setConfig(props);
        this.loader.create();
        this.loader.start();
        Environment env = new Environment(new File(envHome), null);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(transactional);
        Database db = env.openDatabase(null, dbName, dbConfig);
        db.close();
        env.close();
    }

    private void instantiateLoader() throws Exception {
        Class<?> cls = Class.forName("org.jboss.cache.loader.bdbje.BdbjeCacheLoader");
        this.loader = (CacheLoader)cls.newInstance();
    }

    private void stopLoader() throws Exception {
        this.loader.stop();
        this.loader.destroy();
    }

    public void testBasicOperations() throws Exception {
        this.doTestBasicOperations(false);
    }

    public void testBasicOperationsTransactional() throws Exception {
        this.doTestBasicOperations(true);
    }

    private void doTestBasicOperations(boolean transactional) throws Exception {
        this.startLoader(transactional, null);
        this.doPutTests(new Fqn("key"));
        this.doRemoveTests(new Fqn("key"));
        BdbjeUnitTestCase.assertEquals((int)0, (int)this.loader.loadEntireState().length);
        this.doPutTests(new Fqn("key1"));
        this.doPutTests(new Fqn("key3"));
        this.doPutTests(new Fqn("key2"));
        BdbjeUnitTestCase.assertEquals((int)4, (int)this.loader.get(new Fqn("key1")).size());
        BdbjeUnitTestCase.assertEquals((int)4, (int)this.loader.get(new Fqn("key2")).size());
        BdbjeUnitTestCase.assertEquals((int)4, (int)this.loader.get(new Fqn("key3")).size());
        this.doRemoveTests(new Fqn("key2"));
        this.doRemoveTests(new Fqn("key3"));
        this.doRemoveTests(new Fqn("key1"));
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(new Fqn("key1")));
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(new Fqn("key2")));
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(new Fqn("key3")));
        BdbjeUnitTestCase.assertEquals((int)0, (int)this.loader.loadEntireState().length);
        this.stopLoader();
    }

    private void doPutTests(Fqn fqn) throws Exception {
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(fqn) ? 1 : 0) != 0);
        Object oldVal = this.loader.put(fqn, "one", "two");
        BdbjeUnitTestCase.assertNull((Object)oldVal);
        oldVal = this.loader.put(fqn, "three", "four");
        BdbjeUnitTestCase.assertNull((Object)oldVal);
        BdbjeUnitTestCase.assertEquals((Object)"two", (Object)this.loader.get(fqn, "one"));
        BdbjeUnitTestCase.assertEquals((Object)"four", (Object)this.loader.get(fqn, "three"));
        oldVal = this.loader.put(fqn, "one", "xxx");
        BdbjeUnitTestCase.assertEquals((Object)"two", (Object)oldVal);
        oldVal = this.loader.put(fqn, "one", "two");
        BdbjeUnitTestCase.assertEquals((Object)"xxx", (Object)oldVal);
        Map map = this.loader.get(fqn);
        BdbjeUnitTestCase.assertEquals((int)2, (int)map.size());
        BdbjeUnitTestCase.assertEquals((Object)"two", map.get("one"));
        BdbjeUnitTestCase.assertEquals((Object)"four", map.get("three"));
        map.put("five", "six");
        map.put("seven", "eight");
        this.loader.put(fqn, map);
        BdbjeUnitTestCase.assertEquals((Object)"six", (Object)this.loader.get(fqn, "five"));
        BdbjeUnitTestCase.assertEquals((Object)"eight", (Object)this.loader.get(fqn, "seven"));
        BdbjeUnitTestCase.assertEquals((Object)map, (Object)this.loader.get(fqn));
        BdbjeUnitTestCase.assertEquals((int)4, (int)map.size());
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(fqn));
    }

    private void doRemoveTests(Fqn fqn) throws Exception {
        Object oldVal = this.loader.remove(fqn, "one");
        BdbjeUnitTestCase.assertEquals((Object)"two", (Object)oldVal);
        oldVal = this.loader.remove(fqn, "five");
        BdbjeUnitTestCase.assertEquals((Object)"six", (Object)oldVal);
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(fqn, "one"));
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(fqn, "five"));
        BdbjeUnitTestCase.assertEquals((Object)"four", (Object)this.loader.get(fqn, "three"));
        BdbjeUnitTestCase.assertEquals((Object)"eight", (Object)this.loader.get(fqn, "seven"));
        Map map = this.loader.get(fqn);
        BdbjeUnitTestCase.assertEquals((int)2, (int)map.size());
        BdbjeUnitTestCase.assertEquals((Object)"four", map.get("three"));
        BdbjeUnitTestCase.assertEquals((Object)"eight", map.get("seven"));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(fqn));
        this.loader.remove(fqn);
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(fqn, "three"));
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(fqn, "seven"));
        map = this.loader.get(fqn);
        BdbjeUnitTestCase.assertEquals(null, (Object)map);
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(fqn) ? 1 : 0) != 0);
    }

    public void testMultiLevelTree() throws Exception {
        this.startLoader(false, null);
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(new Fqn("key0")) ? 1 : 0) != 0);
        this.loader.put(Fqn.fromString("/key0/level1/level2"), null);
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key0/level1/level2")));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key0/level1")));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key0")));
        this.loader.put(Fqn.fromString("/key0/x/y"), null);
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key0/x/y")));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key0/x")));
        this.loader.remove(Fqn.fromString("/key0/x/y"));
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(Fqn.fromString("/key0/x/y")) ? 1 : 0) != 0);
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key0/x")));
        this.loader.remove(new Fqn("key0"));
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(new Fqn("key0")) ? 1 : 0) != 0);
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(Fqn.fromString("/key0/level1/level2")) ? 1 : 0) != 0);
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(Fqn.fromString("/key0/level1")) ? 1 : 0) != 0);
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(Fqn.fromString("/key0/x")) ? 1 : 0) != 0);
        this.loader.put(new Fqn("key1"), null);
        this.loader.put(new Fqn("key2"), null);
        this.loader.put(new Fqn("key3"), null);
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key1")));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key2")));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key3")));
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(Fqn.fromString("/key3/level1")) ? 1 : 0) != 0);
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(Fqn.fromString("/key3/level1/level2")) ? 1 : 0) != 0);
        this.loader.put(Fqn.fromString("/key3/level1/level2"), null);
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key3/level1/level2")));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key3/level1")));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key1")));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key2")));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key3")));
        this.loader.remove(Fqn.fromString("/key3/level1"));
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(Fqn.fromString("/key3/level1/level2")) ? 1 : 0) != 0);
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(Fqn.fromString("/key3/level1")) ? 1 : 0) != 0);
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key1")));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key2")));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key3")));
        this.loader.remove(new Fqn("key1"));
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(new Fqn("key1")) ? 1 : 0) != 0);
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key2")));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key3")));
        this.loader.remove(new Fqn("key3"));
        BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(new Fqn("key2")));
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(new Fqn("key3")) ? 1 : 0) != 0);
        this.loader.remove(new Fqn("key2"));
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(new Fqn("key0")) ? 1 : 0) != 0);
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(new Fqn("key1")) ? 1 : 0) != 0);
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(new Fqn("key2")) ? 1 : 0) != 0);
        BdbjeUnitTestCase.assertTrue((!this.loader.exists(new Fqn("key3")) ? 1 : 0) != 0);
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(new Fqn("key0")));
        this.loader.put(Fqn.fromString("/key0/level1/level2"), "a", "b");
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(Fqn.fromString("/key0/level1/level2")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(Fqn.fromString("/key0/level1")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(new Fqn("key0")));
        this.loader.put(Fqn.fromString("/key0/x/y"), "a", "b");
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(Fqn.fromString("/key0/x/y")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(Fqn.fromString("/key0/x")));
        this.loader.remove(Fqn.fromString("/key0/x/y"));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(Fqn.fromString("/key0/x/y")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(Fqn.fromString("/key0/x")));
        this.loader.remove(new Fqn("key0"));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(new Fqn("key0")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(Fqn.fromString("/key0/level1/level2")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(Fqn.fromString("/key0/level1")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(Fqn.fromString("/key0/x")));
        this.loader.put(new Fqn("key1"), "a", "b");
        this.loader.put(new Fqn("key2"), "a", "b");
        this.loader.put(new Fqn("key3"), "a", "b");
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(new Fqn("key1")));
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(new Fqn("key2")));
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(new Fqn("key3")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(Fqn.fromString("/key3/level1")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(Fqn.fromString("/key3/level1/level2")));
        this.loader.put(Fqn.fromString("/key3/level1/level2"), "a", "b");
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(Fqn.fromString("/key3/level1/level2")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(Fqn.fromString("/key3/level1")));
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(new Fqn("key1")));
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(new Fqn("key2")));
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(new Fqn("key3")));
        this.loader.remove(Fqn.fromString("/key3/level1"));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(Fqn.fromString("/key3/level1/level2")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(Fqn.fromString("/key3/level1")));
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(new Fqn("key1")));
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(new Fqn("key2")));
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(new Fqn("key3")));
        this.loader.remove(new Fqn("key1"));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(new Fqn("key1")));
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(new Fqn("key2")));
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(new Fqn("key3")));
        this.loader.remove(new Fqn("key3"));
        BdbjeUnitTestCase.assertNotNull((Object)this.loader.get(new Fqn("key2")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(new Fqn("key3")));
        this.loader.remove(new Fqn("key2"));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(new Fqn("key0")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(new Fqn("key1")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(new Fqn("key2")));
        BdbjeUnitTestCase.assertNull((Object)this.loader.get(new Fqn("key3")));
        this.stopLoader();
    }

    public void testGetChildrenNames() throws Exception {
        this.startLoader(false, null);
        this.checkChildren(new Fqn(), null);
        this.checkChildren(Fqn.fromString("/key0"), null);
        this.loader.put(Fqn.fromString("/key0"), null);
        this.checkChildren(new Fqn(), new String[]{"key0"});
        this.loader.put(Fqn.fromString("/key1/x"), null);
        this.checkChildren(new Fqn(), new String[]{"key0", "key1"});
        this.checkChildren(Fqn.fromString("/key1"), new String[]{"x"});
        this.loader.remove(Fqn.fromString("/key1/x"));
        this.checkChildren(new Fqn(), new String[]{"key0", "key1"});
        this.checkChildren(Fqn.fromString("/key0"), null);
        this.checkChildren(Fqn.fromString("/key1"), null);
        this.loader.put(Fqn.fromString("/key0/a"), null);
        this.loader.put(Fqn.fromString("/key0/ab"), null);
        this.loader.put(Fqn.fromString("/key0/abc"), null);
        this.checkChildren(Fqn.fromString("/key0"), new String[]{"a", "ab", "abc"});
        this.loader.put(Fqn.fromString("/key0/xxx"), null);
        this.loader.put(Fqn.fromString("/key0/xx"), null);
        this.loader.put(Fqn.fromString("/key0/x"), null);
        this.checkChildren(Fqn.fromString("/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
        this.loader.put(Fqn.fromString("/key0/a/1"), null);
        this.loader.put(Fqn.fromString("/key0/a/2"), null);
        this.loader.put(Fqn.fromString("/key0/a/2/1"), null);
        this.checkChildren(Fqn.fromString("/key0/a/2"), new String[]{"1"});
        this.checkChildren(Fqn.fromString("/key0/a"), new String[]{"1", "2"});
        this.checkChildren(Fqn.fromString("/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
        this.loader.put(Fqn.fromString("/key0/\u0000"), null);
        this.loader.put(Fqn.fromString("/key0/\u0001"), null);
        this.checkChildren(Fqn.fromString("/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx", "\u0000", "\u0001"});
        this.loader.put(Fqn.fromString("/\u0001"), null);
        this.checkChildren(new Fqn(), new String[]{"key0", "key1", "\u0001"});
        this.loader.put(Fqn.fromString("/\u0001/\u0001"), null);
        this.checkChildren(Fqn.fromString("/\u0001"), new String[]{"\u0001"});
        this.loader.put(Fqn.fromString("/\u0001/\uffff"), null);
        this.checkChildren(Fqn.fromString("/\u0001"), new String[]{"\u0001", "\uffff"});
        this.loader.put(Fqn.fromString("/\u0001/\uffff/\u0001"), null);
        this.checkChildren(Fqn.fromString("/\u0001/\uffff"), new String[]{"\u0001"});
        this.stopLoader();
    }

    private void checkChildren(Fqn fqn, String[] names) throws Exception {
        Set set = this.loader.getChildrenNames(fqn);
        if (names != null) {
            BdbjeUnitTestCase.assertEquals((int)names.length, (int)set.size());
            for (int i = 0; i < names.length; ++i) {
                BdbjeUnitTestCase.assertTrue((boolean)set.contains(names[i]));
            }
        } else {
            BdbjeUnitTestCase.assertNull((Object)set);
        }
    }

    public void testModifications() throws Exception {
        this.doTestModifications(false);
    }

    public void testModificationsTransactional() throws Exception {
        this.doTestModifications(true);
    }

    private void doTestModifications(boolean transactional) throws Exception {
        this.startLoader(transactional, null);
        ArrayList<Modification> list = this.createUpdates();
        this.loader.put(list);
        this.checkModifications(list);
        list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(5);
        mod.setFqn(FQN);
        mod.setKey("one");
        list.add(mod);
        this.loader.put(list);
        this.checkModifications(list);
        list = new ArrayList();
        mod = new Modification();
        mod.setType(4);
        mod.setFqn(FQN);
        list.add(mod);
        this.loader.put(list);
        this.checkModifications(list);
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(FQN));
        this.loader.put(FQN, "one", "two");
        list = new ArrayList();
        mod = new Modification();
        mod.setType(6);
        mod.setFqn(FQN);
        list.add(mod);
        this.loader.put(list);
        this.checkModifications(list);
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(FQN));
        this.stopLoader();
    }

    public void testOnePhaseTransaction() throws Exception {
        this.startLoader(true, null);
        List mods = this.createUpdates();
        this.loader.prepare(null, mods, true);
        this.checkModifications(mods);
        this.stopLoader();
    }

    public void testTwoPhaseTransaction() throws Exception {
        this.startLoader(true, null);
        Object txnKey = new Object();
        List mods = this.createUpdates();
        this.loader.prepare(txnKey, mods, false);
        try {
            this.checkModifications(mods);
            BdbjeUnitTestCase.fail((String)"Expected lock timeout");
        }
        catch (DeadlockException deadlockException) {
            // empty catch block
        }
        this.loader.commit(txnKey);
        this.checkModifications(mods);
        this.stopLoader();
    }

    public void testTransactionRollback() throws Exception {
        this.startLoader(true, null);
        Object txnKey = new Object();
        List mods = this.createUpdates();
        this.loader.prepare(txnKey, mods, false);
        this.loader.rollback(txnKey);
        BdbjeUnitTestCase.assertEquals((int)0, (int)this.loader.loadEntireState().length);
        this.stopLoader();
    }

    private List createUpdates() {
        ArrayList<Modification> list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(1);
        mod.setFqn(FQN);
        mod.setKey("one");
        mod.setValue("two");
        list.add(mod);
        mod = new Modification();
        mod.setType(1);
        mod.setFqn(FQN);
        mod.setKey("three");
        mod.setValue("four");
        list.add(mod);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("five", "six");
        map.put("seven", "eight");
        mod = new Modification();
        mod.setType(2);
        mod.setFqn(FQN);
        mod.setData(map);
        list.add(mod);
        return list;
    }

    private void checkModifications(List list) throws Exception {
        block7: for (int i = 0; i < list.size(); ++i) {
            Modification mod = (Modification)list.get(i);
            Fqn fqn = mod.getFqn();
            switch (mod.getType()) {
                case 1: {
                    BdbjeUnitTestCase.assertEquals((Object)mod.getValue(), (Object)this.loader.get(fqn, mod.getKey()));
                    continue block7;
                }
                case 2: {
                    Map map = mod.getData();
                    Iterator iter = map.keySet().iterator();
                    while (iter.hasNext()) {
                        Object key = iter.next();
                        BdbjeUnitTestCase.assertEquals(map.get(key), (Object)this.loader.get(fqn, key));
                    }
                    continue block7;
                }
                case 5: {
                    BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(fqn, mod.getKey()));
                    continue block7;
                }
                case 6: {
                    BdbjeUnitTestCase.assertTrue((boolean)this.loader.exists(fqn));
                    BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(fqn));
                    continue block7;
                }
                case 4: {
                    BdbjeUnitTestCase.assertTrue((!this.loader.exists(fqn) ? 1 : 0) != 0);
                    BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(fqn));
                    continue block7;
                }
                default: {
                    BdbjeUnitTestCase.fail((String)("unknown type: " + mod));
                }
            }
        }
    }

    public void testBasicExceptions() throws Exception {
        this.instantiateLoader();
        this.checkPreCreateExceptions();
        this.startLoader(false, null);
        this.checkPostCreateExceptions();
        this.loader.put(FQN, "one", "two");
        BdbjeUnitTestCase.assertEquals((Object)"two", (Object)this.loader.get(FQN, "one"));
        this.stopLoader();
        this.checkPreCreateExceptions();
        this.startLoader(false, null);
        this.checkPostCreateExceptions();
        this.loader.put(FQN, "one", "two");
        BdbjeUnitTestCase.assertEquals((Object)"two", (Object)this.loader.get(FQN, "one"));
        this.stopLoader();
        this.checkPreCreateExceptions();
    }

    private void checkPreCreateExceptions() throws Exception {
        this.loader.setCache(new TreeCache());
        this.loader.setConfig(null);
        try {
            this.loader.start();
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        this.loader.setCache(null);
        Properties props = new Properties();
        props.setProperty("location", "xyz");
        this.loader.setConfig(props);
        try {
            this.loader.start();
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        this.loader.setCache(new TreeCache());
        props = new Properties();
        props.setProperty("location", "directory_that_does_not_exist");
        this.loader.setConfig(props);
        try {
            this.loader.start();
            BdbjeUnitTestCase.fail();
        }
        catch (DatabaseException expected) {
            // empty catch block
        }
        try {
            this.loader.put(FQN, "one", "two");
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.put(FQN, new HashMap());
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.put(new ArrayList());
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.get(FQN, "one");
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.get(FQN);
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.remove(FQN);
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.remove(FQN, "one");
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.prepare(new Object(), new ArrayList(), false);
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.commit(new Object());
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.rollback(new Object());
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.loadEntireState();
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.storeEntireState(new byte[0]);
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.loader.stop();
        this.loader.destroy();
    }

    private void checkPostCreateExceptions() throws Exception {
        try {
            this.loader.create();
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.start();
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.loader.put(null, "one", "two");
            BdbjeUnitTestCase.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.loader.put(null, new HashMap());
            BdbjeUnitTestCase.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.loader.put(null);
            BdbjeUnitTestCase.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.loader.get(null, "one");
            BdbjeUnitTestCase.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.loader.get(null);
            BdbjeUnitTestCase.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.loader.remove(null);
            BdbjeUnitTestCase.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.loader.remove(null, "one");
            BdbjeUnitTestCase.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.loader.prepare(null, new ArrayList(), false);
            BdbjeUnitTestCase.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.loader.prepare(new Object(), null, false);
            BdbjeUnitTestCase.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.loader.commit(null);
            BdbjeUnitTestCase.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.loader.rollback(null);
            BdbjeUnitTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testTransactionExceptions() throws Exception {
        List mods = this.createUpdates();
        this.startLoader(false, null);
        try {
            this.loader.prepare(new Object(), mods, false);
            BdbjeUnitTestCase.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        this.stopLoader();
        this.startLoader(true, null);
        try {
            this.loader.commit(new Object());
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.loader.rollback(new Object());
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.loader.storeEntireState(null);
        Object txnKey = new Object();
        this.loader.prepare(txnKey, mods, false);
        this.loader.commit(txnKey);
        try {
            this.loader.commit(txnKey);
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.loader.rollback(txnKey);
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.loader.storeEntireState(null);
        txnKey = new Object();
        this.loader.prepare(txnKey, mods, false);
        this.loader.rollback(txnKey);
        try {
            this.loader.rollback(txnKey);
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.loader.rollback(txnKey);
            BdbjeUnitTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.stopLoader();
    }

    public void testNullKeysAndValues() throws Exception {
        this.startLoader(false, null);
        this.loader.put(FQN, null, "x");
        BdbjeUnitTestCase.assertEquals((Object)"x", (Object)this.loader.get(FQN, null));
        HashMap<String, String> map = this.loader.get(FQN);
        BdbjeUnitTestCase.assertEquals((int)1, (int)map.size());
        BdbjeUnitTestCase.assertEquals((Object)"x", map.get(null));
        this.loader.put(FQN, "y", null);
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(FQN, "y"));
        map = this.loader.get(FQN);
        BdbjeUnitTestCase.assertEquals((int)2, (int)map.size());
        BdbjeUnitTestCase.assertEquals((Object)"x", map.get(null));
        BdbjeUnitTestCase.assertEquals(null, map.get("y"));
        this.loader.remove(FQN, null);
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(FQN, null));
        BdbjeUnitTestCase.assertEquals((int)1, (int)this.loader.get(FQN).size());
        this.loader.remove(FQN, "y");
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(FQN, "y"));
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(FQN));
        map = new HashMap<String, String>();
        map.put(null, null);
        this.loader.put(FQN, map);
        BdbjeUnitTestCase.assertEquals(map, (Object)this.loader.get(FQN));
        this.loader.remove(FQN);
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(FQN));
        map = new HashMap();
        map.put("xyz", null);
        map.put(null, "abc");
        this.loader.put(FQN, map);
        BdbjeUnitTestCase.assertEquals(map, (Object)this.loader.get(FQN));
        this.loader.remove(FQN);
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(FQN));
        this.stopLoader();
    }

    public void testDatabaseName() throws Exception {
        this.startLoader(false, "nonDefaultDbName");
        this.loader.put(FQN, "one", "two");
        BdbjeUnitTestCase.assertEquals((Object)"two", (Object)this.loader.get(FQN, "one"));
        this.stopLoader();
    }

    public void testLoadAndStore() throws Exception {
        this.startLoader(false, null);
        BdbjeUnitTestCase.assertEquals((int)0, (int)this.loader.loadEntireState().length);
        this.loader.storeEntireState(new byte[0]);
        BdbjeUnitTestCase.assertEquals((int)0, (int)this.loader.loadEntireState().length);
        this.loader.storeEntireState(null);
        BdbjeUnitTestCase.assertEquals((int)0, (int)this.loader.loadEntireState().length);
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(FQN));
        Complex c1 = new Complex();
        Complex c2 = new Complex(c1);
        this.loader.put(FQN, new Integer(1), c1);
        this.loader.put(FQN, new Integer(2), c2);
        BdbjeUnitTestCase.assertEquals((Object)c1, (Object)this.loader.get(FQN, new Integer(1)));
        BdbjeUnitTestCase.assertEquals((Object)c2, (Object)this.loader.get(FQN, new Integer(2)));
        BdbjeUnitTestCase.assertEquals((int)2, (int)this.loader.get(FQN).size());
        byte[] state = this.loader.loadEntireState();
        BdbjeUnitTestCase.assertTrue((state.length > 0 ? 1 : 0) != 0);
        this.loader.storeEntireState(null);
        BdbjeUnitTestCase.assertEquals((int)0, (int)this.loader.loadEntireState().length);
        BdbjeUnitTestCase.assertEquals(null, (Object)this.loader.get(FQN));
        this.loader.storeEntireState(state);
        BdbjeUnitTestCase.assertEquals((Object)c1, (Object)this.loader.get(FQN, new Integer(1)));
        BdbjeUnitTestCase.assertEquals((Object)c2, (Object)this.loader.get(FQN, new Integer(2)));
        BdbjeUnitTestCase.assertEquals((int)2, (int)this.loader.get(FQN).size());
        this.stopLoader();
    }

    public static Test suite() throws Exception {
        return new TestSuite(class$org$jboss$cache$tests$BdbjeUnitTestCase == null ? (class$org$jboss$cache$tests$BdbjeUnitTestCase = BdbjeUnitTestCase.class$("org.jboss.cache.tests.BdbjeUnitTestCase")) : class$org$jboss$cache$tests$BdbjeUnitTestCase);
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Test)BdbjeUnitTestCase.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Complex
    implements Serializable {
        Complex nested;

        Complex() {
            this(null);
        }

        Complex(Complex nested) {
            this.nested = nested;
        }

        public boolean equals(Object o) {
            try {
                Complex x = (Complex)o;
                return this.nested != null ? this.nested.equals(x.nested) : x.nested == null;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }
}

