/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.tests;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.transaction.DummyTransactionManager;

public class TreeCacheFunctionalTest
extends TestCase {
    TreeCache cache = null;
    Transaction tx = null;
    final Fqn FQN = Fqn.fromString("/myNode");
    final String KEY = "key";
    final String VALUE = "value";
    Exception ex;
    static /* synthetic */ Class class$org$jboss$cache$tests$TreeCacheFunctionalTest;

    protected void setUp() throws Exception {
        super.setUp();
        this.ex = null;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.cache != null) {
            this.cache.stopService();
            this.cache.destroyService();
            this.cache = null;
        }
        if (this.ex != null) {
            throw this.ex;
        }
    }

    public void testFailFastPut() throws Exception {
        this.cache = new TreeCache();
        this.cache.setCacheMode(1);
        this.cache.startService();
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        this.cache.putFailFast(Fqn.fromString("/a/b/c"), (Object)"key", (Object)"value", 0L);
        this.cache.putFailFast(Fqn.fromString("/a/b/c"), (Object)"key", (Object)"value", 100L);
        this.cache.putFailFast(Fqn.fromString("/1/2/3"), (Object)"key", (Object)"value", 100L);
        this.cache.putFailFast(Fqn.fromString("/1/2/3"), (Object)"key", (Object)"value", 0L);
        System.out.println("cache: " + this.cache.printLockInfo());
    }

    public void testFailFastWith2Transactions() throws Exception, NotSupportedException {
        this.cache = new TreeCache();
        this.cache.setCacheMode(1);
        this.cache.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        this.cache.startService();
        this.tx = this.startTransaction();
        this.cache.put("/a/b/c", (Object)"key", (Object)"value");
        System.out.println("locks before loser: " + this.cache.printLockInfo());
        class Loser
        extends Thread {
            Loser() {
            }

            public void run() {
                Transaction trans = null;
                try {
                    trans = TreeCacheFunctionalTest.this.startTransaction();
                    TreeCacheFunctionalTest.this.cache.putFailFast(Fqn.fromString("/a/b/c"), (Object)"key", (Object)"value", 500L);
                    Assert.fail((String)"this should fail as /a/b/c is held by another thread");
                }
                catch (TimeoutException timeoutEx) {
                    System.out.println("got TimeoutException (as expected)");
                }
                catch (Exception e) {
                    TreeCacheFunctionalTest.this.ex = e;
                }
            }
        }
        Loser loser = new Loser();
        loser.start();
        loser.join();
        this.tx.commit();
    }

    Transaction startTransaction() throws SystemException, NotSupportedException {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tmptx = mgr.getTransaction();
        return tmptx;
    }

    public static Test suite() {
        return new TestSuite(class$org$jboss$cache$tests$TreeCacheFunctionalTest == null ? (class$org$jboss$cache$tests$TreeCacheFunctionalTest = TreeCacheFunctionalTest.class$("org.jboss.cache.tests.TreeCacheFunctionalTest")) : class$org$jboss$cache$tests$TreeCacheFunctionalTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

