/*
 * Decompiled with CFR 0.152.
 */
package net.sf.swarmcache;

import java.io.Serializable;
import net.sf.swarmcache.CacheNotification;
import net.sf.swarmcache.Communicator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.blocks.NotificationBus;

public class JavaGroupsCommunicator
extends Communicator
implements NotificationBus.Consumer {
    Log log = LogFactory.getLog(this.getClass());
    public static final String BUS_NAME = "CacheBus";
    public static final String CHANNEL_PROPERTIES = "multi.cache.properties";
    private NotificationBus bus;

    public JavaGroupsCommunicator(String properties) {
        this.log.info((Object)("Starting a JavaGroups Communicator..." + properties));
        this.setGroupName(BUS_NAME);
        try {
            this.bus = properties == null ? new NotificationBus(this.getGroupName()) : new NotificationBus(this.getGroupName(), properties);
            this.bus.start();
            this.bus.getChannel().setOpt(3, (Object)new Boolean(false));
            this.bus.getChannel().setOpt(5, (Object)new Boolean(true));
            this.bus.setConsumer((NotificationBus.Consumer)this);
            this.log.info((Object)"... finished starting new JavaGroups Communicator.");
        }
        catch (Exception e) {
            this.log.error((Object)"There was a problem initiating the cache notification bus: ");
            e.printStackTrace();
        }
    }

    public void shutDown() {
        this.bus.stop();
    }

    protected void finalize() throws Throwable {
        this.shutDown();
    }

    protected final void send(CacheNotification notification) {
        this.bus.sendNotification((Serializable)notification);
    }

    public Serializable getCache() {
        return null;
    }

    public void handleNotification(Serializable object) {
        this.log.debug((Object)("Received cache notification: " + object));
        CacheNotification notification = (CacheNotification)object;
        this.receive(notification);
    }

    public void memberJoined(Address who) {
        this.log.info((Object)("A host has joined the cache notification bus: " + who + "."));
    }

    public void memberLeft(Address who) {
        this.log.info((Object)("A host has left the cache notification bus: " + who + "."));
    }
}

