/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.selectOneCountry;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.apache.myfaces.custom.selectOneCountry.SelectOneCountry;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.ext.HtmlMenuRenderer;

public class SelectOneCountryRenderer
extends HtmlMenuRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, null);
        SelectOneCountry selectOneCountry = (SelectOneCountry)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (HtmlRendererUtils.isDisplayValueOnly(component)) {
            writer.startElement("span", selectOneCountry);
            HtmlRendererUtils.writeIdIfNecessary(writer, selectOneCountry, facesContext);
            String[] supportedAttributes = new String[]{"styleClass", "style"};
            HtmlRendererUtils.renderHTMLAttributes(writer, selectOneCountry, supportedAttributes);
            String countryCode = selectOneCountry.getValue().toString();
            String countryName = new Locale(countryCode, countryCode).getDisplayCountry(facesContext.getViewRoot().getLocale());
            writer.write(countryName);
            writer.endElement("span");
            return;
        }
        writer.startElement("select", selectOneCountry);
        HtmlRendererUtils.writeIdIfNecessary(writer, selectOneCountry, facesContext);
        writer.writeAttribute("name", component.getClientId(facesContext), null);
        List selectItemList = selectOneCountry.getCountriesChoicesAsSelectItemList();
        Converter converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, selectOneCountry);
        writer.writeAttribute("size", "1", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, selectOneCountry, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (this.isDisabled(facesContext, selectOneCountry)) {
            writer.writeAttribute("disabled", Boolean.TRUE, null);
        }
        Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(false, selectOneCountry, facesContext, converter);
        HtmlRendererUtils.renderSelectOptions(facesContext, selectOneCountry, converter, lookupSet, selectItemList);
        writer.writeText("", null);
        writer.endElement("select");
    }
}

