/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree2;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.tree2.TreeModel;
import org.apache.myfaces.custom.tree2.TreeNode;
import org.apache.myfaces.custom.tree2.TreeState;
import org.apache.myfaces.custom.tree2.TreeStateBase;

public class TreeModelBase
implements TreeModel {
    private static final long serialVersionUID = 3969414475396945742L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$tree2$TreeModelBase == null ? (class$org$apache$myfaces$custom$tree2$TreeModelBase = TreeModelBase.class$("org.apache.myfaces.custom.tree2.TreeModelBase")) : class$org$apache$myfaces$custom$tree2$TreeModelBase));
    private TreeNode root;
    private TreeNode currentNode;
    private TreeState treeState = new TreeStateBase();
    static /* synthetic */ Class class$org$apache$myfaces$custom$tree2$TreeModelBase;

    public TreeModelBase(TreeNode root) {
        this.root = root;
    }

    public TreeState getTreeState() {
        return this.treeState;
    }

    public void setTreeState(TreeState treeState) {
        this.treeState = treeState;
    }

    public TreeNode getNode() {
        return this.currentNode;
    }

    public void setNodeId(String nodeId) {
        if (nodeId == null) {
            this.currentNode = null;
            return;
        }
        this.currentNode = this.getNodeById(nodeId);
    }

    public String[] getPathInformation(String nodeId) {
        if (nodeId == null) {
            throw new IllegalArgumentException("Cannot determine parents for a null node.");
        }
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(nodeId);
        while (nodeId.lastIndexOf(TreeModel.SEPARATOR) != -1) {
            nodeId = nodeId.substring(0, nodeId.lastIndexOf(TreeModel.SEPARATOR));
            pathList.add(nodeId);
        }
        String[] pathInfo = new String[pathList.size()];
        for (int i = 0; i < pathInfo.length; ++i) {
            pathInfo[i] = (String)pathList.get(pathInfo.length - i - 1);
        }
        return pathInfo;
    }

    public boolean isLastChild(String nodeId) {
        TreeNode parentNode;
        if (nodeId.lastIndexOf(TreeModel.SEPARATOR) == -1) {
            return true;
        }
        String parentId = nodeId.substring(0, nodeId.lastIndexOf(TreeModel.SEPARATOR));
        String childString = nodeId.substring(nodeId.lastIndexOf(TreeModel.SEPARATOR) + 1);
        int childId = Integer.parseInt(childString);
        return childId + 1 == (parentNode = this.getNodeById(parentId)).getChildCount();
    }

    private TreeNode getNodeById(String nodeId) {
        TreeNode node = this.root;
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(nodeId, TreeModel.SEPARATOR);
        sb.append(st.nextToken()).append(TreeModel.SEPARATOR);
        while (st.hasMoreTokens()) {
            int nodeIndex = Integer.parseInt(st.nextToken());
            sb.append(nodeIndex);
            node = (TreeNode)node.getChildren().get(nodeIndex);
            sb.append(TreeModel.SEPARATOR);
        }
        return node;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

