/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;

public class Membership
implements Cloneable {
    private final LinkedList members = new LinkedList();
    protected static final Log log = LogFactory.getLog((Class)Membership.class);

    public Membership() {
    }

    public Membership(Collection initial_members) {
        if (initial_members != null) {
            this.add(initial_members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getMembers() {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            return new Vector(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Address new_member) {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            if (new_member != null && !this.members.contains(new_member)) {
                this.members.add(new_member);
            }
        }
    }

    public void add(Collection v) {
        if (v != null) {
            Iterator it = v.iterator();
            while (it.hasNext()) {
                Address addr = (Address)it.next();
                this.add(addr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Address old_member) {
        if (old_member != null) {
            LinkedList linkedList = this.members;
            synchronized (linkedList) {
                this.members.remove(old_member);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Collection v) {
        if (v != null) {
            LinkedList linkedList = this.members;
            synchronized (linkedList) {
                this.members.removeAll(v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            this.members.clear();
        }
    }

    public void set(Collection v) {
        this.clear();
        if (v != null) {
            this.add(v);
        }
    }

    public void set(Membership m) {
        this.clear();
        if (m != null) {
            this.add(m.getMembers());
        }
    }

    public void merge(Collection new_mems, Collection suspects) {
        this.remove(suspects);
        this.add(new_mems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Address member) {
        if (member == null) {
            return false;
        }
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            return this.members.contains(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort() {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            Collections.sort(this.members);
        }
    }

    public Membership copy() {
        return (Membership)this.clone();
    }

    public Object clone() {
        return new Membership(this.members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            return this.members.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object elementAt(int index) {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            return this.members.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            return this.members.toString();
        }
    }
}

