/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.ChannelException;
import org.jgroups.conf.PlainConfigurator;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.w3c.dom.Element;

public class ConfiguratorFactory {
    public static final String JAXP_MISSING_ERROR_MSG = "JAXP Error: the required XML parsing classes are not available; make sure that JAXP compatible libraries are in the classpath.";
    static final String FORCE_CONFIGURATION = "force.properties";
    static final Log log = LogFactory.getLog((Class)ConfiguratorFactory.class);
    static String propertiesOverride = null;

    protected ConfiguratorFactory() {
    }

    /*
     * WARNING - void declaration
     */
    public static ProtocolStackConfigurator getStackConfigurator(File file) throws ChannelException {
        void var1_1;
        ProtocolStackConfigurator returnValue;
        if (propertiesOverride != null) {
            returnValue = ConfiguratorFactory.getStackConfigurator(propertiesOverride);
        } else {
            ConfiguratorFactory.checkForNullConfiguration(file);
            ConfiguratorFactory.checkJAXPAvailability();
            try {
                returnValue = XmlConfigurator.getInstance(new FileInputStream(file));
            }
            catch (IOException ioe) {
                throw ConfiguratorFactory.createChannelConfigurationException(ioe);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ProtocolStackConfigurator getStackConfigurator(URL url) throws ChannelException {
        void var1_1;
        ProtocolStackConfigurator returnValue;
        if (propertiesOverride != null) {
            returnValue = ConfiguratorFactory.getStackConfigurator(propertiesOverride);
        } else {
            ConfiguratorFactory.checkForNullConfiguration(url);
            ConfiguratorFactory.checkJAXPAvailability();
            try {
                returnValue = XmlConfigurator.getInstance(url);
            }
            catch (IOException ioe) {
                throw ConfiguratorFactory.createChannelConfigurationException(ioe);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ProtocolStackConfigurator getStackConfigurator(Element element) throws ChannelException {
        void var1_1;
        ProtocolStackConfigurator returnValue;
        if (propertiesOverride != null) {
            returnValue = ConfiguratorFactory.getStackConfigurator(propertiesOverride);
        } else {
            ConfiguratorFactory.checkForNullConfiguration(element);
            try {
                returnValue = XmlConfigurator.getInstance(element);
            }
            catch (IOException ioe) {
                throw ConfiguratorFactory.createChannelConfigurationException(ioe);
            }
        }
        return var1_1;
    }

    public static ProtocolStackConfigurator getStackConfigurator(String properties) throws ChannelException {
        if (propertiesOverride != null) {
            properties = propertiesOverride;
        }
        if (properties == null) {
            properties = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32):PING(timeout=3000;num_initial_members=6):FD(timeout=3000):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=10;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=10000):FRAG:pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true)";
        }
        ConfiguratorFactory.checkForNullConfiguration(properties);
        XmlConfigurator configurator = null;
        try {
            configurator = ConfiguratorFactory.getXmlConfigurator(properties);
        }
        catch (IOException ioe) {
            throw ConfiguratorFactory.createChannelConfigurationException(ioe);
        }
        ProtocolStackConfigurator returnValue = configurator != null ? configurator : new PlainConfigurator(properties);
        return returnValue;
    }

    public static ProtocolStackConfigurator getStackConfigurator(Object properties) throws IOException {
        InputStream input = null;
        if (propertiesOverride != null) {
            properties = propertiesOverride;
        }
        if (properties == null) {
            properties = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32):PING(timeout=3000;num_initial_members=6):FD(timeout=3000):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=10;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=10000):FRAG:pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true)";
        }
        if (properties instanceof URL) {
            try {
                input = ((URL)properties).openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (input == null && properties instanceof String) {
            try {
                input = new URL((String)properties).openStream();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (input == null && ((String)properties).endsWith("xml")) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    input = classLoader.getResourceAsStream((String)properties);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if (input == null) {
                try {
                    input = new FileInputStream((String)properties);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        if (input == null && properties instanceof File) {
            try {
                input = new FileInputStream((File)properties);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (input != null) {
            return XmlConfigurator.getInstance(input);
        }
        if (properties instanceof Element) {
            return XmlConfigurator.getInstance((Element)properties);
        }
        return new PlainConfigurator((String)properties);
    }

    static InputStream getConfigStream(String properties) throws IOException {
        InputStream configStream = null;
        try {
            configStream = new URL(properties).openStream();
        }
        catch (MalformedURLException mre) {
            // empty catch block
        }
        if (configStream == null && properties.endsWith("xml")) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            configStream = classLoader.getResourceAsStream(properties);
        }
        if (configStream == null) {
            try {
                configStream = new FileInputStream(properties);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return configStream;
    }

    static XmlConfigurator getXmlConfigurator(String properties) throws IOException {
        XmlConfigurator returnValue = null;
        InputStream configStream = ConfiguratorFactory.getConfigStream(properties);
        if (configStream != null) {
            ConfiguratorFactory.checkJAXPAvailability();
            returnValue = XmlConfigurator.getInstance(configStream);
        }
        return returnValue;
    }

    static ChannelException createChannelConfigurationException(Throwable cause) {
        return new ChannelException("unable to load the protocol stack", cause);
    }

    static void checkForNullConfiguration(Object properties) {
        if (properties == null) {
            String msg = "the specifed protocol stack configuration was null.";
            throw new NullPointerException("the specifed protocol stack configuration was null.");
        }
    }

    static void checkJAXPAvailability() {
        try {
            XmlConfigurator.class.getName();
        }
        catch (NoClassDefFoundError error) {
            throw new NoClassDefFoundError(JAXP_MISSING_ERROR_MSG);
        }
    }

    static {
        try {
            Properties properties = System.getProperties();
            propertiesOverride = properties.getProperty(FORCE_CONFIGURATION);
        }
        catch (SecurityException e) {
            propertiesOverride = null;
        }
        if (propertiesOverride != null && log.isInfoEnabled()) {
            log.info((Object)("using properties override: " + propertiesOverride));
        }
    }
}

