/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Digest
implements Externalizable,
Streamable {
    Address[] senders = null;
    long[] low_seqnos = null;
    long[] high_seqnos = null;
    long[] high_seqnos_seen = null;
    int index = 0;
    protected static final Log log = LogFactory.getLog((Class)Digest.class);

    public Digest() {
    }

    public Digest(int size) {
        this.reset(size);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Digest other = (Digest)obj;
        if (!this.sameSenders(other)) {
            return false;
        }
        if (!Util.match(this.low_seqnos, other.low_seqnos)) {
            return false;
        }
        if (!Util.match(this.high_seqnos, other.high_seqnos)) {
            return false;
        }
        return Util.match(this.high_seqnos_seen, other.high_seqnos_seen);
    }

    public void add(Address sender, long low_seqno, long high_seqno) {
        if (this.index >= this.senders.length) {
            if (log.isErrorEnabled()) {
                log.error((Object)("index " + this.index + " out of bounds, please create new Digest if you want more members !"));
            }
            return;
        }
        if (sender == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"sender is null, will not add it !");
            }
            return;
        }
        this.senders[this.index] = sender;
        this.low_seqnos[this.index] = low_seqno;
        this.high_seqnos[this.index] = high_seqno;
        this.high_seqnos_seen[this.index] = -1L;
        ++this.index;
    }

    public void add(Address sender, long low_seqno, long high_seqno, long high_seqno_seen) {
        if (this.index >= this.senders.length) {
            if (log.isErrorEnabled()) {
                log.error((Object)("index " + this.index + " out of bounds, please create new Digest if you want more members !"));
            }
            return;
        }
        if (sender == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"sender is null, will not add it !");
            }
            return;
        }
        this.senders[this.index] = sender;
        this.low_seqnos[this.index] = low_seqno;
        this.high_seqnos[this.index] = high_seqno;
        this.high_seqnos_seen[this.index] = high_seqno_seen;
        ++this.index;
    }

    public void add(Digest d) {
        if (d != null) {
            for (int i = 0; i < d.size(); ++i) {
                Address sender = d.senderAt(i);
                long low_seqno = d.lowSeqnoAt(i);
                long high_seqno = d.highSeqnoAt(i);
                long high_seqno_seen = d.highSeqnoSeenAt(i);
                this.add(sender, low_seqno, high_seqno, high_seqno_seen);
            }
        }
    }

    public void merge(Digest d) {
        if (d == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"digest to be merged with is null");
            }
            return;
        }
        for (int i = 0; i < d.size(); ++i) {
            Address sender = d.senderAt(i);
            long low_seqno = d.lowSeqnoAt(i);
            long high_seqno = d.highSeqnoAt(i);
            long high_seqno_seen = d.highSeqnoSeenAt(i);
            this.merge(sender, low_seqno, high_seqno, high_seqno_seen);
        }
    }

    public void merge(Address sender, long low_seqno, long high_seqno, long high_seqno_seen) {
        if (sender == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"sender == null");
            }
            return;
        }
        int index = this.getIndex(sender);
        if (index == -1) {
            this.add(sender, low_seqno, high_seqno, high_seqno_seen);
            return;
        }
        long my_low_seqno = this.lowSeqnoAt(index);
        long my_high_seqno = this.highSeqnoAt(index);
        long my_high_seqno_seen = this.highSeqnoSeenAt(index);
        if (low_seqno < my_low_seqno) {
            this.setLowSeqnoAt(index, low_seqno);
        }
        if (high_seqno > my_high_seqno) {
            this.setHighSeqnoAt(index, high_seqno);
        }
        if (high_seqno_seen > my_high_seqno_seen) {
            this.setHighSeqnoSeenAt(index, high_seqno_seen);
        }
    }

    public int getIndex(Address sender) {
        int ret = -1;
        if (sender == null) {
            return ret;
        }
        for (int i = 0; i < this.senders.length; ++i) {
            if (!sender.equals(this.senders[i])) continue;
            return i;
        }
        return ret;
    }

    public boolean contains(Address sender) {
        return this.getIndex(sender) != -1;
    }

    public boolean sameSenders(Digest other) {
        if (other == null) {
            return false;
        }
        if (this.senders == null || other.senders == null) {
            return false;
        }
        if (this.senders.length != other.senders.length) {
            return false;
        }
        for (int i = 0; i < this.senders.length; ++i) {
            Address a1 = this.senders[i];
            Address a2 = other.senders[i];
            if (a1 == null && a2 == null || a1 != null && a2 != null && a1.equals(a2)) continue;
            return false;
        }
        return true;
    }

    public void incrementHighSeqno(Address sender) {
        if (sender == null) {
            return;
        }
        for (int i = 0; i < this.senders.length; ++i) {
            if (this.senders[i] == null || !this.senders[i].equals(sender)) continue;
            this.high_seqnos[i] = this.high_seqnos[i] + 1L;
            break;
        }
    }

    public int size() {
        return this.senders.length;
    }

    public Address senderAt(int index) {
        if (index < this.size()) {
            return this.senders[index];
        }
        if (log.isErrorEnabled()) {
            log.error((Object)("index " + index + " is out of bounds"));
        }
        return null;
    }

    public void resetAt(int index) {
        if (index < this.size()) {
            this.low_seqnos[index] = 0L;
            this.high_seqnos[index] = 0L;
            this.high_seqnos_seen[index] = -1L;
        } else if (log.isErrorEnabled()) {
            log.error((Object)("index " + index + " is out of bounds"));
        }
    }

    public void reset(int size) {
        this.senders = new Address[size];
        this.low_seqnos = new long[size];
        this.high_seqnos = new long[size];
        this.high_seqnos_seen = new long[size];
        for (int i = 0; i < size; ++i) {
            this.high_seqnos_seen[i] = -1L;
        }
        this.index = 0;
    }

    public long lowSeqnoAt(int index) {
        if (index < this.size()) {
            return this.low_seqnos[index];
        }
        if (log.isErrorEnabled()) {
            log.error((Object)("index " + index + " is out of bounds"));
        }
        return 0L;
    }

    public long highSeqnoAt(int index) {
        if (index < this.size()) {
            return this.high_seqnos[index];
        }
        if (log.isErrorEnabled()) {
            log.error((Object)("index " + index + " is out of bounds"));
        }
        return 0L;
    }

    public long highSeqnoSeenAt(int index) {
        if (index < this.size()) {
            return this.high_seqnos_seen[index];
        }
        if (log.isErrorEnabled()) {
            log.error((Object)("index " + index + " is out of bounds"));
        }
        return 0L;
    }

    public long highSeqnoAt(Address sender) {
        long ret = -1L;
        if (sender == null) {
            return ret;
        }
        int index = this.getIndex(sender);
        if (index == -1) {
            return ret;
        }
        return this.high_seqnos[index];
    }

    public long highSeqnoSeenAt(Address sender) {
        long ret = -1L;
        if (sender == null) {
            return ret;
        }
        int index = this.getIndex(sender);
        if (index == -1) {
            return ret;
        }
        return this.high_seqnos_seen[index];
    }

    public void setLowSeqnoAt(int index, long low_seqno) {
        if (index < this.size()) {
            this.low_seqnos[index] = low_seqno;
        } else if (log.isErrorEnabled()) {
            log.error((Object)("index " + index + " is out of bounds"));
        }
    }

    public void setHighSeqnoAt(int index, long high_seqno) {
        if (index < this.size()) {
            this.high_seqnos[index] = high_seqno;
        } else if (log.isErrorEnabled()) {
            log.error((Object)("index " + index + " is out of bounds"));
        }
    }

    public void setHighSeqnoSeenAt(int index, long high_seqno_seen) {
        if (index < this.size()) {
            this.high_seqnos_seen[index] = high_seqno_seen;
        } else if (log.isErrorEnabled()) {
            log.error((Object)("index " + index + " is out of bounds"));
        }
    }

    public void setHighSeqnoAt(Address sender, long high_seqno) {
        int index = this.getIndex(sender);
        if (index < 0) {
            return;
        }
        this.setHighSeqnoAt(index, high_seqno);
    }

    public void setHighSeqnoSeenAt(Address sender, long high_seqno_seen) {
        int index = this.getIndex(sender);
        if (index < 0) {
            return;
        }
        this.setHighSeqnoSeenAt(index, high_seqno_seen);
    }

    public Digest copy() {
        Digest ret = new Digest(this.senders.length);
        if (this.senders != null) {
            System.arraycopy(this.senders, 0, ret.senders, 0, this.senders.length);
        }
        ret.low_seqnos = (long[])this.low_seqnos.clone();
        ret.high_seqnos = (long[])this.high_seqnos.clone();
        ret.high_seqnos_seen = (long[])this.high_seqnos_seen.clone();
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (this.senders == null) {
            return "[]";
        }
        for (int i = 0; i < this.senders.length; ++i) {
            if (!first) {
                sb.append(", ");
            } else {
                sb.append('[');
                first = false;
            }
            sb.append(this.senders[i]).append(": ").append('[').append(this.low_seqnos[i]).append(" : ");
            sb.append(this.high_seqnos[i]);
            if (this.high_seqnos_seen[i] < 0L) continue;
            sb.append(" (").append(this.high_seqnos_seen[i]).append(")]");
        }
        sb.append(']');
        return sb.toString();
    }

    public String printHighSeqnos() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < this.senders.length; ++i) {
            if (!first) {
                sb.append(", ");
            } else {
                sb.append('[');
                first = false;
            }
            sb.append(this.senders[i]);
            sb.append('#');
            sb.append(this.high_seqnos[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public String printHighSeqnosSeen() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < this.senders.length; ++i) {
            if (!first) {
                sb.append(", ");
            } else {
                sb.append('[');
                first = false;
            }
            sb.append(this.senders[i]);
            sb.append('#');
            sb.append(this.high_seqnos_seen[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeObject(this.senders);
        if (this.low_seqnos == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.low_seqnos.length);
            for (i = 0; i < this.low_seqnos.length; ++i) {
                out.writeLong(this.low_seqnos[i]);
            }
        }
        if (this.high_seqnos == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.high_seqnos.length);
            for (i = 0; i < this.high_seqnos.length; ++i) {
                out.writeLong(this.high_seqnos[i]);
            }
        }
        if (this.high_seqnos_seen == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.high_seqnos_seen.length);
            for (i = 0; i < this.high_seqnos_seen.length; ++i) {
                out.writeLong(this.high_seqnos_seen[i]);
            }
        }
        out.writeInt(this.index);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.senders = (Address[])in.readObject();
        int num = in.readInt();
        if (num == 0) {
            this.low_seqnos = null;
        } else {
            this.low_seqnos = new long[num];
            for (i = 0; i < this.low_seqnos.length; ++i) {
                this.low_seqnos[i] = in.readLong();
            }
        }
        num = in.readInt();
        if (num == 0) {
            this.high_seqnos = null;
        } else {
            this.high_seqnos = new long[num];
            for (i = 0; i < this.high_seqnos.length; ++i) {
                this.high_seqnos[i] = in.readLong();
            }
        }
        num = in.readInt();
        if (num == 0) {
            this.high_seqnos_seen = null;
        } else {
            this.high_seqnos_seen = new long[num];
            for (i = 0; i < this.high_seqnos_seen.length; ++i) {
                this.high_seqnos_seen[i] = in.readLong();
            }
        }
        this.index = in.readInt();
    }

    public void writeTo(DataOutputStream out) throws IOException {
        out.writeInt(this.senders == null ? 0 : this.senders.length);
        for (int i = 0; i < this.senders.length; ++i) {
            Address sender = this.senders[i];
            Util.writeAddress(sender, out);
        }
        this.writeArray(this.low_seqnos, out);
        this.writeArray(this.high_seqnos, out);
        this.writeArray(this.high_seqnos_seen, out);
        out.writeInt(this.index);
    }

    private void writeArray(long[] arr, DataOutputStream out) throws IOException {
        int len = arr != null ? arr.length : 0;
        out.writeInt(len);
        if (len > 0) {
            for (int i = 0; i < arr.length; ++i) {
                out.writeLong(arr[i]);
            }
        }
    }

    private long[] readArray(DataInputStream in) throws IOException {
        int b = in.readInt();
        if (b == 0) {
            return null;
        }
        long[] retval = new long[b];
        for (int i = 0; i < b; ++i) {
            retval[i] = in.readLong();
        }
        return retval;
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        int b = in.readInt();
        if (b > 0) {
            this.senders = new Address[b];
            for (int i = 0; i < b; ++i) {
                Address sender;
                this.senders[i] = sender = Util.readAddress(in);
            }
        }
        this.low_seqnos = this.readArray(in);
        this.high_seqnos = this.readArray(in);
        this.high_seqnos_seen = this.readArray(in);
        this.index = in.readInt();
    }
}

