/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.service;

import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.service.AbstractService;

public class ServiceRunner {
    public static final String SERVICE_CLASS = "serviceClass";
    public static final String SERVICE_CHANNEL_STACK = "serviceChannel";
    public static final String SERVICE_GROUP_NAME = "serviceGroup";
    public static final String CLIENT_CHANNEL_STACK = "clientChannel";
    public static final String CLIENT_GROUP_NAME = "clientGroup";
    public static final String HELP_SWITCH = "-help";
    public static final String RESOURCE_SWITCH = "-res";

    public static void startService(ResourceBundle res) throws Exception {
        Class<?> serviceClass;
        String className = res.getString(SERVICE_CLASS);
        if (className == null || "".equals(className)) {
            System.out.println("Specified resource does not contain service class name");
            System.exit(1);
        }
        if (!AbstractService.class.isAssignableFrom(serviceClass = Class.forName(className))) {
            System.out.println("Specified service class is not instance of " + AbstractService.class.getName());
            System.exit(1);
        }
        String serviceChannelStack = res.getString(SERVICE_CHANNEL_STACK);
        final JChannel svcChannel = new JChannel(serviceChannelStack);
        svcChannel.setOpt(4, Boolean.TRUE);
        String clientChannelStack = res.getString(CLIENT_CHANNEL_STACK);
        final JChannel clientChannel = new JChannel(clientChannelStack);
        String svcGroup = res.getString(SERVICE_GROUP_NAME);
        String clientGroup = res.getString(CLIENT_GROUP_NAME);
        svcChannel.connect(svcGroup);
        clientChannel.connect(clientGroup);
        Constructor<?> serviceConstructor = serviceClass.getConstructor(Channel.class, Channel.class);
        final AbstractService service = (AbstractService)serviceConstructor.newInstance(svcChannel, clientChannel);
        service.start();
        Runnable shutdownHook = new Runnable(){

            public void run() {
                System.out.println("Shutting down service " + service.getName());
                service.stop();
                svcChannel.close();
                clientChannel.close();
                System.out.println("Done.");
            }
        };
        Thread shutdownThread = new Thread(shutdownHook, service.getName() + " shutdown hook [" + service.getAddress() + ']');
        shutdownThread.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        System.out.println("Service '" + service.getName() + "' is up'n'running");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            ServiceRunner.printUsage();
            System.exit(0);
        }
        String resourceName = null;
        for (int i = 0; i < args.length; ++i) {
            if (HELP_SWITCH.equals(args[i])) {
                ServiceRunner.printUsage();
                System.exit(0);
                continue;
            }
            if (!RESOURCE_SWITCH.equals(args[i])) continue;
            resourceName = args[++i];
        }
        if (resourceName == null) {
            ServiceRunner.printUsage();
            System.exit(0);
        }
        ResourceBundle res = ResourceBundle.getBundle(resourceName);
        ServiceRunner.startService(res);
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Usage: java org.jgroups.service.ServiceRunner -res <service_desc_res>");
        System.out.println("<service_desc_res> -\tservice description resource,");
        System.out.println("\t\t\tstandard properties file containing information");
        System.out.println("\t\t\tabout service to run.");
    }
}

