/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;

public class GossipClient {
    Timer timer = new Timer();
    final Hashtable groups = new Hashtable();
    Refresher refresher_task = new Refresher();
    final Vector gossip_servers = new Vector();
    boolean timer_running = false;
    long EXPIRY_TIME = 20000L;
    protected final Log log = LogFactory.getLog(this.getClass());

    public GossipClient(IpAddress gossip_host, long expiry) {
        this.init(gossip_host, expiry);
    }

    public GossipClient(Vector gossip_hosts, long expiry) {
        if (gossip_hosts == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"empty set of GossipServers given");
            }
            return;
        }
        for (int i = 0; i < gossip_hosts.size(); ++i) {
            this.init((IpAddress)gossip_hosts.elementAt(i), expiry);
        }
    }

    public void stop() {
        this.timer_running = false;
        this.timer.cancel();
        this.groups.clear();
        this.timer = new Timer();
        this.refresher_task = new Refresher();
    }

    public void addGossipServer(IpAddress gossip_host) {
        if (!this.gossip_servers.contains(gossip_host)) {
            this.gossip_servers.addElement(gossip_host);
        }
    }

    public void register(String group, Address mbr) {
        if (group == null || mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"group or mbr is null");
            }
            return;
        }
        Vector<Address> mbrs = (Vector<Address>)this.groups.get(group);
        if (mbrs == null) {
            mbrs = new Vector<Address>();
            mbrs.addElement(mbr);
            this.groups.put(group, mbrs);
        } else if (!mbrs.contains(mbr)) {
            mbrs.addElement(mbr);
        }
        this._register(group, mbr);
        if (!this.timer_running) {
            this.timer.schedule((TimerTask)this.refresher_task, this.EXPIRY_TIME, this.EXPIRY_TIME);
            this.timer_running = true;
        }
    }

    public Vector getMembers(String group) {
        if (group == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"group is null");
            }
            return null;
        }
        return this._getMembers(group);
    }

    void init(IpAddress gossip_host, long expiry) {
        this.EXPIRY_TIME = expiry;
        this.addGossipServer(gossip_host);
    }

    void _register(String group, Address mbr) {
        for (int i = 0; i < this.gossip_servers.size(); ++i) {
            IpAddress entry = (IpAddress)this.gossip_servers.elementAt(i);
            if (entry.getIpAddress() == null || entry.getPort() == 0) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"entry.host or entry.port is null");
                continue;
            }
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("REGISTER_REQ --> " + entry.getIpAddress() + ':' + entry.getPort()));
                }
                Socket sock = new Socket(entry.getIpAddress(), entry.getPort());
                ObjectOutputStream out = new ObjectOutputStream(sock.getOutputStream());
                GossipData gossip_req = new GossipData(1, group, mbr, null);
                out.writeObject(gossip_req);
                out.flush();
                sock.close();
                continue;
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exception connecting to host " + entry + ": " + ex));
            }
        }
    }

    Vector _getMembers(String group) {
        Vector<Address> ret = new Vector<Address>();
        for (int i = 0; i < this.gossip_servers.size(); ++i) {
            IpAddress entry = (IpAddress)this.gossip_servers.elementAt(i);
            if (entry.getIpAddress() == null || entry.getPort() == 0) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"entry.host or entry.port is null");
                continue;
            }
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("GET_REQ --> " + entry.getIpAddress() + ':' + entry.getPort()));
                }
                Socket sock = new Socket(entry.getIpAddress(), entry.getPort());
                ObjectOutputStream out = new ObjectOutputStream(sock.getOutputStream());
                GossipData gossip_req = new GossipData(2, group, null, null);
                out.writeObject(gossip_req);
                out.flush();
                ObjectInputStream in = new ObjectInputStream(sock.getInputStream());
                GossipData gossip_rsp = (GossipData)in.readObject();
                if (gossip_rsp.mbrs != null) {
                    for (int j = 0; j < gossip_rsp.mbrs.size(); ++j) {
                        Address mbr = (Address)gossip_rsp.mbrs.elementAt(j);
                        if (ret.contains(mbr)) continue;
                        ret.addElement(mbr);
                    }
                }
                sock.close();
                continue;
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exception connecting to host " + entry + ": " + ex));
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        Vector<IpAddress> gossip_hosts = new Vector<IpAddress>();
        boolean get = false;
        boolean register = false;
        boolean keep_running = false;
        String register_host = null;
        int register_port = 0;
        String get_group = null;
        String register_group = null;
        GossipClient gossip_client = null;
        long expiry = 20000L;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                GossipClient.usage();
                return;
            }
            if ("-expiry".equals(args[i])) {
                expiry = Long.parseLong(args[++i]);
                continue;
            }
            if ("-host".equals(args[i])) {
                String host = args[++i];
                int port = Integer.parseInt(args[++i]);
                try {
                    InetAddress ip_addr = InetAddress.getByName(host);
                    gossip_hosts.addElement(new IpAddress(ip_addr, port));
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
                continue;
            }
            if ("-keep_running".equals(args[i])) {
                keep_running = true;
                continue;
            }
            if ("-get".equals(args[i])) {
                get = true;
                get_group = args[++i];
                continue;
            }
            if ("-register".equals(args[i])) {
                register_group = args[++i];
                register_host = args[++i];
                register_port = Integer.parseInt(args[++i]);
                register = true;
                continue;
            }
            GossipClient.usage();
            return;
        }
        if (gossip_hosts.size() == 0) {
            System.err.println("At least 1 GossipServer has to be given");
            return;
        }
        if (!register && !get) {
            System.err.println("Neither get nor register command given, will not do anything");
            return;
        }
        try {
            gossip_client = new GossipClient(gossip_hosts, expiry);
            if (register) {
                System.out.println("Registering " + register_group + " --> " + register_host + ':' + register_port);
                gossip_client.register(register_group, new IpAddress(register_host, register_port));
            }
            if (get) {
                System.out.println("Getting members for group " + get_group);
                Vector mbrs = gossip_client.getMembers(get_group);
                System.out.println("Members for group " + get_group + " are " + mbrs);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        if (!keep_running) {
            gossip_client.stop();
        }
    }

    static void usage() {
        System.out.println("GossipClient [-help] [-host <hostname> <port>]+  [-get <groupname>] [-register <groupname hostname port>] [-expiry <msecs>] [-keep_running]]");
    }

    private class Refresher
    extends TimerTask {
        private Refresher() {
        }

        public void run() {
            int num_items = 0;
            if (GossipClient.this.log.isTraceEnabled()) {
                GossipClient.this.log.trace((Object)"refresher task is run");
            }
            Enumeration e = GossipClient.this.groups.keys();
            while (e.hasMoreElements()) {
                String group = (String)e.nextElement();
                Vector mbrs = (Vector)GossipClient.this.groups.get(group);
                if (mbrs == null) continue;
                for (int i = 0; i < mbrs.size(); ++i) {
                    Address mbr = (Address)mbrs.elementAt(i);
                    if (GossipClient.this.log.isTraceEnabled()) {
                        GossipClient.this.log.trace((Object)("registering " + group + " : " + mbr));
                    }
                    GossipClient.this.register(group, mbr);
                    ++num_items;
                }
            }
            if (GossipClient.this.log.isTraceEnabled()) {
                GossipClient.this.log.trace((Object)("refresher task done. Registered " + num_items + " items"));
            }
        }
    }
}

