/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.SocketException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.blocks.ConnectionTable;

public class ConnectionTableUnitTest
extends TestCase {
    ConnectionTable ct1;
    ConnectionTable ct2;
    final int port1 = 5555;
    final int port2 = 6666;

    public ConnectionTableUnitTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ct1 = new ConnectionTable(5555);
        this.log("address of ct1: " + this.ct1.getLocalAddress());
        this.ct2 = new ConnectionTable(6666);
        this.log("address of ct2: " + this.ct2.getLocalAddress());
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.ct1 != null) {
            this.ct1.stop();
            this.ct1 = null;
        }
        if (this.ct2 != null) {
            this.ct2.stop();
            this.ct2 = null;
        }
    }

    public void testSetup() {
        ConnectionTableUnitTest.assertNotSame((Object)this.ct1.getLocalAddress(), (Object)this.ct2.getLocalAddress());
    }

    public void testSendToSelf() throws Exception {
        long NUM = 1000L;
        Address myself = this.ct1.getLocalAddress();
        MyReceiver r = new MyReceiver(this.ct1, NUM, false);
        this.ct1.setReceiver(r);
        int i = 0;
        while ((long)i < NUM) {
            this.ct1.send(new Message(myself, null, null));
            ++i;
        }
        this.log("sent " + NUM + " msgs");
        r.waitForCompletion();
        long total_time = r.stop_time - r.start_time;
        this.log("number expected=" + r.getNumExpected() + ", number received=" + r.getNumReceived() + ", total time=" + total_time + " (" + (double)total_time / (double)r.getNumReceived() + " ms/msg)");
        ConnectionTableUnitTest.assertEquals((long)r.getNumExpected(), (long)r.getNumReceived());
    }

    public void testSendToOther() throws Exception {
        long NUM = 1000L;
        Address other = this.ct2.getLocalAddress();
        MyReceiver r = new MyReceiver(this.ct2, NUM, false);
        this.ct2.setReceiver(r);
        int i = 0;
        while ((long)i < NUM) {
            this.ct1.send(new Message(other, null, null));
            ++i;
        }
        this.log("sent " + NUM + " msgs");
        r.waitForCompletion();
        long total_time = r.stop_time - r.start_time;
        this.log("number expected=" + r.getNumExpected() + ", number received=" + r.getNumReceived() + ", total time=" + total_time + " (" + (double)total_time / (double)r.getNumReceived() + " ms/msg)");
        ConnectionTableUnitTest.assertEquals((long)r.getNumExpected(), (long)r.getNumReceived());
    }

    public void testSendToOtherGetResponse() throws Exception {
        long NUM = 1000L;
        Address other = this.ct2.getLocalAddress();
        MyReceiver r1 = new MyReceiver(this.ct1, NUM, false);
        MyReceiver r2 = new MyReceiver(this.ct2, NUM, true);
        this.ct1.setReceiver(r1);
        this.ct2.setReceiver(r2);
        int i = 0;
        while ((long)i < NUM) {
            this.ct1.send(new Message(other, null, null));
            ++i;
        }
        this.log("sent " + NUM + " msgs");
        r1.waitForCompletion();
        long total_time = r1.stop_time - r1.start_time;
        this.log("number expected=" + r1.getNumExpected() + ", number received=" + r1.getNumReceived() + ", total time=" + total_time + " (" + (double)total_time / (double)r1.getNumReceived() + " ms/msg)");
        ConnectionTableUnitTest.assertEquals((long)r1.getNumExpected(), (long)r1.getNumReceived());
    }

    void log(String msg) {
        System.out.println("-- [" + Thread.currentThread() + "]: " + msg);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ConnectionTableUnitTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    class MyReceiver
    implements ConnectionTable.Receiver {
        long num_expected = 0L;
        long num_received = 0L;
        long start_time = 0L;
        long stop_time = 0L;
        boolean done = false;
        boolean send_response = false;
        long modulo;
        ConnectionTable ct;

        MyReceiver(ConnectionTable ct, long num_expected, boolean send_response) {
            this.ct = ct;
            this.num_expected = num_expected;
            this.send_response = send_response;
            this.start_time = System.currentTimeMillis();
            this.modulo = num_expected / 10L;
        }

        public long getNumReceived() {
            return this.num_received;
        }

        public long getNumExpected() {
            return this.num_expected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Message msg) {
            Address sender = msg.getSrc();
            ++this.num_received;
            if (this.num_received % this.modulo == 0L) {
                ConnectionTableUnitTest.this.log("received msg# " + this.num_received);
            }
            if (this.send_response && this.ct != null) {
                try {
                    this.ct.send(new Message(sender, null, null));
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            }
            if (this.num_received >= this.num_expected) {
                MyReceiver myReceiver = this;
                synchronized (myReceiver) {
                    if (!this.done) {
                        this.done = true;
                        this.stop_time = System.currentTimeMillis();
                        this.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() {
            MyReceiver myReceiver = this;
            synchronized (myReceiver) {
                while (!this.done) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

