/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.FD;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.UdpHeader;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Buffer;
import org.jgroups.util.ContextObjectInputStream;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.Queue;
import org.jgroups.util.Range;
import org.jgroups.util.Streamable;

public class Util {
    private static final Object mutex = new Object();
    private static final ByteArrayOutputStream out_stream = new ByteArrayOutputStream(512);
    protected static final Log log = LogFactory.getLog((Class)Util.class);
    public static final int MAX_PORT = 65535;
    public static final String DIAG_GROUP = "DIAG_GROUP-BELA-322649";
    static boolean resolve_dns = false;

    public static void closeInputStream(InputStream inp) {
        if (inp != null) {
            try {
                inp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeOutputStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object objectFromByteBuffer(byte[] buffer) throws Exception {
        Object object = mutex;
        synchronized (object) {
            if (buffer == null) {
                return null;
            }
            Object retval = null;
            ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer);
            ContextObjectInputStream in = new ContextObjectInputStream(in_stream);
            retval = in.readObject();
            in.close();
            if (retval == null) {
                return null;
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToByteBuffer(Object obj) throws Exception {
        byte[] result = null;
        ByteArrayOutputStream byteArrayOutputStream = out_stream;
        synchronized (byteArrayOutputStream) {
            out_stream.reset();
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(obj);
            result = out_stream.toByteArray();
            out.close();
        }
        return result;
    }

    public static void writeAddress(Address addr, DataOutputStream out) throws IOException {
        if (addr == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        if (addr instanceof IpAddress) {
            out.writeBoolean(true);
            addr.writeTo(out);
        } else {
            out.writeBoolean(false);
            Util.writeOtherAddress(addr, out);
        }
    }

    public static Address readAddress(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        Address addr = null;
        if (!in.readBoolean()) {
            return null;
        }
        if (in.readBoolean()) {
            addr = new IpAddress();
            addr.readFrom(in);
        } else {
            addr = Util.readOtherAddress(in);
        }
        return addr;
    }

    private static Address readOtherAddress(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        ClassConfigurator conf = null;
        try {
            conf = ClassConfigurator.getInstance(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        int b = in.read();
        Class cl = null;
        if (b == 1) {
            int magic_number = in.readInt();
            cl = conf.get(magic_number);
        } else {
            String classname = in.readUTF();
            cl = conf.get(classname);
        }
        Address addr = (Address)cl.newInstance();
        addr.readFrom(in);
        return addr;
    }

    private static void writeOtherAddress(Address addr, DataOutputStream out) throws IOException {
        int magic_number;
        ClassConfigurator conf = null;
        try {
            conf = ClassConfigurator.getInstance(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        int n = magic_number = conf != null ? conf.getMagicNumber(addr.getClass()) : -1;
        if (magic_number == -1) {
            out.write(0);
            out.writeUTF(addr.getClass().getName());
        } else {
            out.write(1);
            out.writeInt(magic_number);
        }
        addr.writeTo(out);
    }

    public static void writeStreamable(Streamable obj, DataOutputStream out) throws IOException {
        if (obj == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        obj.writeTo(out);
    }

    public static Streamable readStreamable(Class clazz, DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        Streamable retval = null;
        if (!in.readBoolean()) {
            return null;
        }
        retval = (Streamable)clazz.newInstance();
        retval.readFrom(in);
        return retval;
    }

    public static void writeGenericStreamable(Streamable obj, DataOutputStream out) throws IOException {
        if (obj == null) {
            out.write(0);
            return;
        }
        try {
            out.write(1);
            int magic_number = ClassConfigurator.getInstance(false).getMagicNumber(obj.getClass());
            if (magic_number == -1) {
                out.write(0);
                String classname = obj.getClass().getName();
                out.writeUTF(classname);
            } else {
                out.write(1);
                out.writeInt(magic_number);
            }
            obj.writeTo(out);
        }
        catch (ChannelException e) {
            throw new IOException("failed writing object of type " + obj.getClass() + " to stream: " + e.toString());
        }
    }

    public static Streamable readGenericStreamable(DataInputStream in) throws IOException {
        Streamable retval = null;
        int b = in.read();
        if (b == 0) {
            return null;
        }
        int use_magic_number = in.read();
        try {
            Class clazz;
            if (use_magic_number == 1) {
                int magic_number = in.readInt();
                clazz = ClassConfigurator.getInstance(false).get(magic_number);
            } else {
                String classname = in.readUTF();
                clazz = ClassConfigurator.getInstance(false).get(classname);
            }
            retval = (Streamable)clazz.newInstance();
            retval.readFrom(in);
            return retval;
        }
        catch (Exception ex) {
            throw new IOException("failed reading object: " + ex.toString());
        }
    }

    public static void writeString(String s, DataOutputStream out) throws IOException {
        if (s != null) {
            out.write(1);
            out.writeUTF(s);
        } else {
            out.write(0);
        }
    }

    public static String readString(DataInputStream in) throws IOException {
        int b = in.read();
        if (b == 1) {
            return in.readUTF();
        }
        return null;
    }

    public static void writeByteBuffer(byte[] buf, DataOutputStream out) throws IOException {
        if (buf != null) {
            out.write(1);
            out.writeInt(buf.length);
            out.write(buf, 0, buf.length);
        } else {
            out.write(0);
        }
    }

    public static byte[] readByteBuffer(DataInputStream in) throws IOException {
        int b = in.read();
        if (b == 1) {
            b = in.readInt();
            byte[] buf = new byte[b];
            in.read(buf, 0, buf.length);
            return buf;
        }
        return null;
    }

    public static Buffer msgListToByteBuffer(LinkedList xmit_list) throws IOException {
        ExposedByteArrayOutputStream output = new ExposedByteArrayOutputStream(512);
        DataOutputStream out = new DataOutputStream(output);
        Buffer retval = null;
        out.writeInt(xmit_list.size());
        Iterator it = xmit_list.iterator();
        while (it.hasNext()) {
            Message msg = (Message)it.next();
            msg.writeTo(out);
        }
        out.flush();
        retval = new Buffer(output.getRawBuffer(), 0, output.size());
        out.close();
        output.close();
        return retval;
    }

    public static LinkedList byteBufferToMessageList(byte[] buffer, int offset, int length) throws Exception {
        LinkedList<Message> retval = null;
        ByteArrayInputStream input = new ByteArrayInputStream(buffer, offset, length);
        DataInputStream in = new DataInputStream(input);
        int size = in.readInt();
        if (size == 0) {
            return null;
        }
        retval = new LinkedList<Message>();
        for (int i = 0; i < size; ++i) {
            Message msg = new Message();
            msg.readFrom(in);
            retval.add(msg);
        }
        return retval;
    }

    public static boolean match(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return obj2.equals(obj1);
    }

    public static boolean match(long[] a1, long[] a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1 == a2) {
            return true;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void sleep(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sleep(long msecs, boolean busy_sleep) {
        if (!busy_sleep) {
            Util.sleep(msecs);
            return;
        }
        long start = System.currentTimeMillis();
        long stop = start + msecs;
        while (stop > start) {
            start = System.currentTimeMillis();
        }
    }

    public static long random(long range) {
        return (long)(Math.random() * 100000.0 % (double)range) + 1L;
    }

    public static void sleepRandom(long timeout) {
        if (timeout <= 0L) {
            log.error((Object)"timeout must be > 0 !");
            return;
        }
        long r = (int)(Math.random() * 100000.0 % (double)timeout) + 1;
        Util.sleep(r);
    }

    public static boolean tossWeightedCoin(double probability) {
        long cutoff;
        long r = Util.random(100L);
        return r < (cutoff = (long)(probability * 100.0));
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "localhost";
        }
    }

    public static void dumpStack(boolean exit) {
        try {
            throw new Exception("Dumping stack:");
        }
        catch (Exception e) {
            e.printStackTrace();
            if (exit) {
                System.exit(0);
            }
            return;
        }
    }

    public static String dumpQueue(Queue q) {
        StringBuffer sb = new StringBuffer();
        LinkedList values = q.values();
        if (values.size() == 0) {
            sb.append("empty");
        } else {
            Iterator it = values.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                String s = null;
                if (o instanceof Event) {
                    Event event = (Event)o;
                    int type = event.getType();
                    s = Event.type2String(type);
                    if (type == 1) {
                        s = s + "[";
                        Message m = (Message)event.getArg();
                        Map headers = m.getHeaders();
                        Iterator i = headers.keySet().iterator();
                        while (i.hasNext()) {
                            Object headerKey = i.next();
                            Object value = headers.get(headerKey);
                            String headerToString = null;
                            if (value instanceof FD.FdHeader) {
                                headerToString = value.toString();
                            } else if (value instanceof PingHeader) {
                                headerToString = headerKey + "-";
                                headerToString = ((PingHeader)value).type == 1 ? headerToString + "GMREQ" : (((PingHeader)value).type == 2 ? headerToString + "GMRSP" : headerToString + "UNKNOWN");
                            } else {
                                headerToString = headerKey + "-" + (value == null ? "null" : value.toString());
                            }
                            s = s + headerToString;
                            if (!i.hasNext()) continue;
                            s = s + ",";
                        }
                        s = s + "]";
                    }
                } else {
                    s = o.toString();
                }
                sb.append(s).append(" ");
            }
        }
        return sb.toString();
    }

    public static String printStackTrace(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        t.printStackTrace(p);
        return s.toString();
    }

    public static String getStackTrace(Throwable t) {
        return Util.printStackTrace(t);
    }

    public static String printStackTrace() {
        try {
            throw new Exception("Dumping stack:");
        }
        catch (Throwable t) {
            StringWriter s = new StringWriter();
            PrintWriter p = new PrintWriter(s);
            t.printStackTrace(p);
            return s.toString();
        }
    }

    public static String print(Throwable t) {
        return Util.printStackTrace(t);
    }

    public static void crash() {
        System.exit(-1);
    }

    public static String printEvent(Event evt) {
        Message msg;
        if (evt.getType() == 1 && (msg = (Message)evt.getArg()) != null) {
            if (msg.getLength() > 0) {
                return Util.printMessage(msg);
            }
            return msg.printObjectHeaders();
        }
        return evt.toString();
    }

    public static String printMessage(Message msg) {
        if (msg == null) {
            return "";
        }
        if (msg.getLength() == 0) {
            return null;
        }
        try {
            return msg.getObject().toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String printMethodCall(Message msg) {
        if (msg == null) {
            return "";
        }
        if (msg.getLength() == 0) {
            return "";
        }
        try {
            Object obj = msg.getObject();
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void printThreads() {
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        System.out.println("------- Threads -------");
        for (int i = 0; i < threads.length; ++i) {
            System.out.println("#" + i + ": " + threads[i]);
        }
        System.out.println("------- Threads -------\n");
    }

    public static String activeThreads() {
        StringBuffer sb = new StringBuffer();
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        sb.append("------- Threads -------\n");
        for (int i = 0; i < threads.length; ++i) {
            sb.append("#" + i + ": " + threads[i] + '\n');
        }
        sb.append("------- Threads -------\n");
        return sb.toString();
    }

    public static byte[][] fragmentBuffer(byte[] buf, int frag_size, int length) {
        long total_size = length;
        int accumulated_size = 0;
        int tmp_size = 0;
        int index = 0;
        int num_frags = length % frag_size == 0 ? length / frag_size : length / frag_size + 1;
        byte[][] retval = new byte[num_frags][];
        while ((long)accumulated_size < total_size) {
            tmp_size = (long)(accumulated_size + frag_size) <= total_size ? frag_size : (int)(total_size - (long)accumulated_size);
            byte[] fragment = new byte[tmp_size];
            System.arraycopy(buf, accumulated_size, fragment, 0, tmp_size);
            retval[index++] = fragment;
            accumulated_size += tmp_size;
        }
        return retval;
    }

    public static byte[][] fragmentBuffer(byte[] buf, int frag_size) {
        return Util.fragmentBuffer(buf, frag_size, buf.length);
    }

    public static List computeFragOffsets(int offset, int length, int frag_size) {
        ArrayList<Range> retval = new ArrayList<Range>();
        long total_size = length + offset;
        int index = offset;
        int tmp_size = 0;
        while ((long)index < total_size) {
            tmp_size = (long)(index + frag_size) <= total_size ? frag_size : (int)(total_size - (long)index);
            Range r = new Range(index, tmp_size);
            retval.add(r);
            index += tmp_size;
        }
        return retval;
    }

    public static List computeFragOffsets(byte[] buf, int frag_size) {
        return Util.computeFragOffsets(0, buf.length, frag_size);
    }

    public static byte[] defragmentBuffer(byte[][] fragments) {
        int i;
        int total_length = 0;
        int index = 0;
        if (fragments == null) {
            return null;
        }
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i] == null) continue;
            total_length += fragments[i].length;
        }
        byte[] ret = new byte[total_length];
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i] == null) continue;
            System.arraycopy(fragments[i], 0, ret, index, fragments[i].length);
            index += fragments[i].length;
        }
        return ret;
    }

    public static void printFragments(byte[][] frags) {
        for (int i = 0; i < frags.length; ++i) {
            System.out.println('\'' + new String(frags[i]) + '\'');
        }
    }

    public static String array2String(long[] array) {
        StringBuffer ret = new StringBuffer("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i] + " ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(int[] array) {
        StringBuffer ret = new StringBuffer("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i] + " ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(boolean[] array) {
        StringBuffer ret = new StringBuffer("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i] + " ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static Vector pickSubset(Vector members, double subset_percentage) {
        Vector ret = new Vector();
        int num_mbrs = members.size();
        if (num_mbrs == 0) {
            return ret;
        }
        int subset_size = (int)Math.ceil((double)num_mbrs * subset_percentage);
        Vector tmp_mbrs = (Vector)members.clone();
        for (int i = subset_size; i > 0 && tmp_mbrs.size() > 0; --i) {
            int index = (int)(Math.random() * (double)num_mbrs % (double)tmp_mbrs.size());
            ret.addElement(tmp_mbrs.elementAt(index));
            tmp_mbrs.removeElementAt(index);
        }
        return ret;
    }

    public static Vector determineLeftMembers(Vector old_mbrs, Vector new_mbrs) {
        Vector retval = new Vector();
        if (old_mbrs == null || new_mbrs == null) {
            return retval;
        }
        for (int i = 0; i < old_mbrs.size(); ++i) {
            Object mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            retval.addElement(mbr);
        }
        return retval;
    }

    public static String printMembers(Vector v) {
        StringBuffer sb = new StringBuffer("(");
        boolean first = true;
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                Object el = v.elementAt(i);
                if (el instanceof Address) {
                    sb.append(el);
                    continue;
                }
                sb.append(el);
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public static void doubleWrite(byte[] buf, OutputStream out) throws Exception {
        if (buf.length > 1) {
            out.write(buf, 0, 1);
            out.write(buf, 1, buf.length - 1);
        } else {
            out.write(buf, 0, 0);
            out.write(buf);
        }
    }

    public static long sizeOf(String classname) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Object inst = loader.loadClass(classname).newInstance();
            byte[] data = Util.objectToByteBuffer(inst);
            return data.length;
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("exception=" + ex));
            }
            return 0L;
        }
    }

    public static long sizeOf(Object inst) {
        try {
            byte[] data = Util.objectToByteBuffer(inst);
            return data.length;
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("exception+" + ex));
            }
            return 0L;
        }
    }

    public static long sizeOf(Streamable inst) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(output);
            inst.writeTo(out);
            out.flush();
            byte[] data = output.toByteArray();
            return data.length;
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("exception+" + ex));
            }
            return 0L;
        }
    }

    public static boolean sameHost(Address one, Address two) {
        if (one == null || two == null) {
            return false;
        }
        if (!(one instanceof IpAddress) || !(two instanceof IpAddress)) {
            if (log.isErrorEnabled()) {
                log.error((Object)"addresses have to be of type IpAddress to be compared");
            }
            return false;
        }
        InetAddress a = ((IpAddress)one).getIpAddress();
        InetAddress b = ((IpAddress)two).getIpAddress();
        if (a == null || b == null) {
            return false;
        }
        String host_a = a.getHostAddress();
        String host_b = b.getHostAddress();
        return host_a.equals(host_b);
    }

    public static void removeFile(String fname) {
        block3: {
            if (fname == null) {
                return;
            }
            try {
                new File(fname).delete();
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("exception=" + ex));
            }
        }
    }

    public static boolean fileExists(String fname) {
        return new File(fname).exists();
    }

    public static long[] parseCommaDelimitedLongs(String s) {
        Vector<Long> v = new Vector<Long>();
        long[] retval = null;
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            Long l = new Long(tok.nextToken());
            v.addElement(l);
        }
        if (v.size() == 0) {
            return null;
        }
        retval = new long[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            retval[i] = (Long)v.elementAt(i);
        }
        return retval;
    }

    public static List parseCommaDelimitedStrings(String l) {
        ArrayList<String> tmp = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            tmp.add(t);
        }
        return tmp;
    }

    public static String shortName(String hostname) {
        StringBuffer sb = new StringBuffer();
        if (hostname == null) {
            return null;
        }
        int index = hostname.indexOf(46);
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            sb.append(hostname.substring(0, index));
        } else {
            sb.append(hostname);
        }
        return sb.toString();
    }

    public static String shortName(InetAddress hostname) {
        if (hostname == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (resolve_dns) {
            sb.append(hostname.getHostName());
        } else {
            sb.append(hostname.getHostAddress());
        }
        return sb.toString();
    }

    public static ServerSocket createServerSocket(int start_port) {
        ServerSocket ret = null;
        while (true) {
            try {
                ret = new ServerSocket(start_port);
            }
            catch (BindException bind_ex) {
                ++start_port;
                continue;
            }
            catch (IOException io_ex) {
                if (!log.isErrorEnabled()) break;
                log.error((Object)("exception is " + io_ex));
            }
            break;
        }
        return ret;
    }

    public static ServerSocket createServerSocket(InetAddress bind_addr, int start_port) {
        ServerSocket ret = null;
        while (true) {
            try {
                ret = new ServerSocket(start_port, 50, bind_addr);
            }
            catch (BindException bind_ex) {
                ++start_port;
                continue;
            }
            catch (IOException io_ex) {
                if (!log.isErrorEnabled()) break;
                log.error((Object)("exception is " + io_ex));
            }
            break;
        }
        return ret;
    }

    public static DatagramSocket createDatagramSocket(InetAddress addr, int port) throws Exception {
        DatagramSocket sock = null;
        if (addr == null) {
            if (port == 0) {
                return new DatagramSocket();
            }
            while (port < 65535) {
                try {
                    return new DatagramSocket(port);
                }
                catch (BindException bind_ex) {
                    ++port;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        } else {
            if (port == 0) {
                port = 1024;
            }
            while (port < 65535) {
                try {
                    return new DatagramSocket(port, addr);
                }
                catch (BindException bind_ex) {
                    ++port;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        }
        return sock;
    }

    public static boolean checkForLinux() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("linux");
    }

    public static boolean checkForSolaris() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("sun");
    }

    public static boolean checkForWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("win");
    }

    public static void prompt(String s) {
        System.out.println(s);
        System.out.flush();
        try {
            while (System.in.available() > 0) {
                System.in.read();
            }
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        int retval = 0;
        if (version != null) {
            if (version.startsWith("1.2")) {
                return 12;
            }
            if (version.startsWith("1.3")) {
                return 13;
            }
            if (version.startsWith("1.4")) {
                return 14;
            }
            if (version.startsWith("1.5")) {
                return 15;
            }
            if (version.startsWith("5")) {
                return 15;
            }
            if (version.startsWith("1.6")) {
                return 16;
            }
            if (version.startsWith("6")) {
                return 16;
            }
        }
        return retval;
    }

    public static String memStats(boolean gc) {
        StringBuffer sb = new StringBuffer();
        Runtime rt = Runtime.getRuntime();
        if (gc) {
            rt.gc();
        }
        long free_mem = rt.freeMemory();
        long total_mem = rt.totalMemory();
        long used_mem = total_mem - free_mem;
        sb.append("Free mem: ").append(free_mem).append("\nUsed mem: ").append(used_mem);
        sb.append("\nTotal mem: ").append(total_mem);
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        ClassConfigurator.getInstance(true);
        Message msg = new Message(null, (Address)new IpAddress("127.0.0.1", 4444), (Serializable)((Object)"Bela"));
        long size = Util.sizeOf(msg);
        System.out.println("size=" + msg.size() + ", streamable size=" + size);
        msg.putHeader("belaban", new NakAckHeader(1, 23L, 34L));
        size = Util.sizeOf(msg);
        System.out.println("size=" + msg.size() + ", streamable size=" + size);
        msg.putHeader("bla", new UdpHeader("groupname"));
        size = Util.sizeOf(msg);
        System.out.println("size=" + msg.size() + ", streamable size=" + size);
        IpAddress a1 = new IpAddress(1234);
        IpAddress a2 = new IpAddress("127.0.0.1", 3333);
        a1.setAdditionalData("Bela".getBytes());
        size = Util.sizeOf(a1);
        System.out.println("size=" + a1.size() + ", streamable size of a1=" + size);
        size = Util.sizeOf(a2);
        System.out.println("size=" + a2.size() + ", streamable size of a2=" + size);
    }

    static {
        try {
            resolve_dns = Boolean.valueOf(System.getProperty("resolve.dns", "false"));
        }
        catch (SecurityException ex) {
            resolve_dns = false;
        }
    }
}

