/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.QueryConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.CannotAcquireResourceException;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.sql.SqlUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPool {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPool == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPool = C3P0PooledConnectionPool.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPool);
    ResourcePool rp;
    ConnectionEventListener cl = new ConnectionEventListenerImpl();
    ConnectionTester connectionTester;
    GooGooStatementCache scache;
    int checkoutTimeout;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C3P0PooledConnectionPool(final ConnectionPoolDataSource cpds, final DbAuth auth, int min, int max, int inc, int acq_retry_attempts, int acq_retry_delay, boolean break_after_acq_failure, int checkoutTimeout, int idleConnectionTestPeriod, int maxIdleTime, final boolean testConnectionOnCheckout, final boolean testConnectionOnCheckin, GooGooStatementCache myscache, final ConnectionTester connectionTester, final String testQuery, ResourcePoolFactory fact) throws SQLException {
        try {
            this.scache = myscache;
            this.connectionTester = connectionTester;
            this.checkoutTimeout = checkoutTimeout;
            ResourcePool.Manager manager = new ResourcePool.Manager(){

                public Object acquireResource() throws Exception {
                    PooledConnection out;
                    PooledConnection pooledConnection = out = auth.equals(C3P0ImplUtils.NULL_AUTH) ? cpds.getPooledConnection() : cpds.getPooledConnection(auth.getUser(), auth.getPassword());
                    if (C3P0PooledConnectionPool.this.scache != null) {
                        if (out instanceof C3P0PooledConnection) {
                            ((C3P0PooledConnection)out).initStatementCache(C3P0PooledConnectionPool.this.scache);
                        } else if (out instanceof NewPooledConnection) {
                            ((NewPooledConnection)out).initStatementCache(C3P0PooledConnectionPool.this.scache);
                        } else {
                            logger.warning("StatementPooling not implemented for external (non-c3p0) ConnectionPoolDataSources.");
                        }
                    }
                    out.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    return out;
                }

                public void refurbishResourceOnCheckout(Object resc) throws Exception {
                    if (testConnectionOnCheckout) {
                        this.testPooledConnection(resc);
                    }
                }

                public void refurbishResourceOnCheckin(Object resc) throws Exception {
                    if (testConnectionOnCheckin) {
                        this.testPooledConnection(resc);
                    }
                }

                public void refurbishIdleResource(Object resc) throws Exception {
                    this.testPooledConnection(resc);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                private void testPooledConnection(Object resc) throws Exception {
                    void var3_5;
                    SQLException rootCause;
                    Connection conn;
                    PooledConnection pc;
                    block11: {
                        int status;
                        pc = (PooledConnection)resc;
                        conn = null;
                        rootCause = null;
                        try {
                            pc.removeConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                            conn = pc.getConnection();
                            if (testQuery == null) {
                                status = connectionTester.activeCheckConnection(conn);
                                break block11;
                            }
                            if (connectionTester instanceof QueryConnectionTester) {
                                status = ((QueryConnectionTester)connectionTester).activeCheckConnection(conn, testQuery);
                                break block11;
                            }
                            logger.warning("[c3p0] testQuery '" + testQuery + "' ignored. Please set a ConnectionTester that implements " + "com.mchange.v2.c3p0.advanced.QueryConnectionTester, or use the " + "DefaultConnectionTester, to test with the testQuery.");
                            status = connectionTester.activeCheckConnection(conn);
                        }
                        catch (SQLException e) {
                            try {
                                logger.log(MLevel.FINE, "A Connection test failed with an Exception.", e);
                                status = -1;
                                rootCause = e;
                            }
                            catch (Throwable throwable) {
                                ConnectionUtils.attemptClose(conn);
                                pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                                throw throwable;
                            }
                            ConnectionUtils.attemptClose(conn);
                            pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                        }
                    }
                    ConnectionUtils.attemptClose(conn);
                    pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    switch (var3_5) {
                        case 0: {
                            break;
                        }
                        case -8: {
                            C3P0PooledConnectionPool.this.rp.resetPool();
                        }
                        case -1: {
                            SQLException throwMe = rootCause == null ? new SQLException("Connection is invalid") : SqlUtils.toSQLException("Connection is invalid", rootCause);
                            throw throwMe;
                        }
                        default: {
                            throw new Error("Bad Connection Tester (" + connectionTester + ") " + "returned invalid status (" + (int)var3_5 + ").");
                        }
                    }
                }

                public void destroyResource(Object resc) throws Exception {
                    ((PooledConnection)resc).close();
                }
            };
            ResourcePoolFactory resourcePoolFactory = fact;
            synchronized (resourcePoolFactory) {
                fact.setMin(min);
                fact.setMax(max);
                fact.setIncrement(inc);
                fact.setIdleResourceTestPeriod(idleConnectionTestPeriod * 1000);
                fact.setResourceMaxAge(maxIdleTime * 1000);
                fact.setAcquisitionRetryAttempts(acq_retry_attempts);
                fact.setAcquisitionRetryDelay(acq_retry_delay);
                fact.setBreakOnAcquisitionFailure(break_after_acq_failure);
                fact.setAgeIsAbsolute(false);
                this.rp = fact.createPool(manager);
            }
        }
        catch (ResourcePoolException e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    public PooledConnection checkoutPooledConnection() throws SQLException {
        try {
            return (PooledConnection)this.rp.checkoutResource(this.checkoutTimeout);
        }
        catch (TimeoutException e) {
            throw SqlUtils.toSQLException("An attempt by a client to checkout a Connection has timed out.", e);
        }
        catch (CannotAcquireResourceException e) {
            throw SqlUtils.toSQLException("Connections could not be acquired from the underlying database!", "08001", e);
        }
        catch (Exception e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    public void checkinPooledConnection(PooledConnection pcon) throws SQLException {
        try {
            this.rp.checkinResource(pcon);
        }
        catch (ResourcePoolException e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    public void close() throws SQLException {
        try {
            this.rp.close();
        }
        catch (ResourcePoolException e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    public int getNumConnections() throws SQLException {
        try {
            return this.rp.getPoolSize();
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, null, e);
            throw SqlUtils.toSQLException(e);
        }
    }

    public int getNumIdleConnections() throws SQLException {
        try {
            return this.rp.getAvailableCount();
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, null, e);
            throw SqlUtils.toSQLException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumBusyConnections() throws SQLException {
        try {
            ResourcePool resourcePool = this.rp;
            synchronized (resourcePool) {
                return this.rp.getAwaitingCheckinCount() - this.rp.getExcludedCount();
            }
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, null, e);
            throw SqlUtils.toSQLException(e);
        }
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        try {
            return this.rp.getExcludedCount();
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, null, e);
            throw SqlUtils.toSQLException(e);
        }
    }

    public void reset() throws SQLException {
        try {
            this.rp.resetPool();
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, null, e);
            throw SqlUtils.toSQLException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ConnectionEventListenerImpl
    implements ConnectionEventListener {
        ConnectionEventListenerImpl() {
        }

        public void connectionClosed(ConnectionEvent evt) {
            try {
                C3P0PooledConnectionPool.this.rp.checkinResource(evt.getSource());
            }
            catch (Exception e) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to check a PooledConection into a ResourcePool.", e);
            }
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("CONNECTION ERROR OCCURRED!");
            }
            try {
                PooledConnection pc = (PooledConnection)evt.getSource();
                int status = pc instanceof C3P0PooledConnection ? ((C3P0PooledConnection)pc).getConnectionStatus() : (pc instanceof NewPooledConnection ? ((NewPooledConnection)pc).getConnectionStatus() : -1);
                switch (status) {
                    case 0: {
                        throw new InternalError("connectionErrorOcccurred() should only be called for errors fatal to the Connection.");
                    }
                    case -1: {
                        C3P0PooledConnectionPool.this.rp.markBroken(pc);
                        break;
                    }
                    case -8: {
                        C3P0PooledConnectionPool.this.rp.resetPool();
                        break;
                    }
                    default: {
                        throw new InternalError("Bad Connection Tester (" + C3P0PooledConnectionPool.this.connectionTester + ") " + "returned invalid status (" + status + ").");
                    }
                }
            }
            catch (ResourcePoolException e) {
                logger.log(MLevel.WARNING, "Uh oh... our resource pool is probably broken!", e);
            }
        }
    }
}

