/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.proxy;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.aop.javassist.AspectWeaver;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConstructorUtil;

public final class AopProxy
implements Serializable {
    static final long serialVersionUID = 0L;
    private static Logger logger_ = Logger.getLogger(class$org$seasar$framework$aop$proxy$AopProxy == null ? (class$org$seasar$framework$aop$proxy$AopProxy = AopProxy.class$("org.seasar.framework.aop.proxy.AopProxy")) : class$org$seasar$framework$aop$proxy$AopProxy);
    private Class targetClass_;
    private Class enhancedClass_;
    private Pointcut defaultPointcut_;
    private Map parameters_;
    static /* synthetic */ Class class$org$seasar$framework$aop$proxy$AopProxy;

    public AopProxy(Class targetClass, Aspect[] aspects) {
        this(targetClass, aspects, null);
    }

    public AopProxy(Class targetClass, Aspect[] aspects, Map parameters) {
        this.parameters_ = parameters;
        this.setTargetClass(targetClass);
        this.setAspects(aspects);
    }

    private void setTargetClass(Class targetClass) {
        this.targetClass_ = targetClass;
        this.defaultPointcut_ = new PointcutImpl(targetClass);
    }

    private void setAspects(Aspect[] aspects) {
        if (aspects == null || aspects.length == 0) {
            throw new EmptyRuntimeException("aspects");
        }
        AspectWeaver weaver = new AspectWeaver(this.targetClass_, this.parameters_);
        for (int i = 0; i < aspects.length; ++i) {
            Aspect aspect = aspects[i];
            if (aspect.getPointcut() != null) continue;
            aspect.setPointcut(this.defaultPointcut_);
        }
        Method[] methods = this.targetClass_.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            ArrayList<MethodInterceptor> interceptorList = new ArrayList<MethodInterceptor>();
            for (int j = 0; j < aspects.length; ++j) {
                Aspect aspect = aspects[j];
                if (!aspect.getPointcut().isApplied(method)) continue;
                interceptorList.add(aspect.getMethodInterceptor());
            }
            if (interceptorList.size() <= 0) continue;
            if (this.isApplicableAspect(method)) {
                weaver.setInterceptors(method, interceptorList.toArray(new MethodInterceptor[interceptorList.size()]));
                continue;
            }
            logger_.log("WSSR0009", new Object[]{this.targetClass_.getName(), method.getName()});
        }
        this.enhancedClass_ = weaver.generateClass();
    }

    public Class getEnhancedClass() {
        return this.enhancedClass_;
    }

    public Object create() {
        return ClassUtil.newInstance(this.enhancedClass_);
    }

    public Object create(Class[] argTypes, Object[] args) {
        Constructor constructor = ClassUtil.getConstructor(this.enhancedClass_, argTypes);
        return ConstructorUtil.newInstance(constructor, args);
    }

    private boolean isApplicableAspect(Method method) {
        int mod = method.getModifiers();
        return !Modifier.isFinal(mod) && !Modifier.isStatic(mod);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

