/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.autoregister.AbstractAutoRegister;
import org.seasar.framework.container.autoregister.ClassPattern;
import org.seasar.framework.container.factory.AspectDefFactory;

public class AspectAutoRegister
extends AbstractAutoRegister {
    private MethodInterceptor interceptor;
    private String pointcut;

    public void setInterceptor(MethodInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setPointcut(String pointcut) {
        this.pointcut = pointcut;
    }

    public void registerAll() {
        S2Container container = this.getContainer();
        for (int i = 0; i < container.getComponentDefSize(); ++i) {
            ComponentDef cd = container.getComponentDef(i);
            this.register(cd);
        }
    }

    protected void register(ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        String className = componentClass.getName();
        int pos = className.lastIndexOf(46);
        String packageName = pos < 0 ? null : className.substring(0, pos);
        String shortClassName = pos < 0 ? className : className.substring(pos + 1);
        for (int i = 0; i < this.getClassPatternSize(); ++i) {
            ClassPattern cp = this.getClassPattern(i);
            if (this.isIgnore(packageName, shortClassName) || !cp.isAppliedPackageName(packageName) || !cp.isAppliedShortClassName(shortClassName)) continue;
            this.registerInterceptor(componentDef);
            return;
        }
    }

    protected void registerInterceptor(ComponentDef componentDef) {
        AspectDef aspectDef = AspectDefFactory.createAspectDef(this.interceptor, this.pointcut);
        componentDef.addAspectDef(aspectDef);
    }
}

