/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.seasar.framework.container.autoregister.AbstractComponentAutoRegister;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceUtil;

public class ComponentAutoRegister
extends AbstractComponentAutoRegister
implements ClassTraversal.ClassHandler {
    private List referenceClasses = new ArrayList();
    private Map strategies = new HashMap();

    public ComponentAutoRegister() {
        this.strategies.put("file", new FileSystemStrategy());
        this.strategies.put("jar", new JarFileStrategy());
    }

    public void addReferenceClass(Class referenceClass) {
        this.referenceClasses.add(referenceClass);
    }

    public void registerAll() {
        for (int i = 0; i < this.referenceClasses.size(); ++i) {
            Class referenceClass = (Class)this.referenceClasses.get(i);
            String baseClassPath = ResourceUtil.getResourcePath(referenceClass);
            URL url = ResourceUtil.getResource(baseClassPath);
            Strategy strategy = (Strategy)this.strategies.get(url.getProtocol());
            strategy.registerAll(referenceClass, url);
        }
    }

    private class JarFileStrategy
    implements Strategy {
        private JarFileStrategy() {
        }

        public void registerAll(Class referenceClass, URL url) {
            JarFile jarFile = this.createJarFile(url);
            ClassTraversal.forEach(jarFile, (ClassTraversal.ClassHandler)ComponentAutoRegister.this);
        }

        private JarFile createJarFile(URL url) {
            String urlString = ResourceUtil.toExternalForm(url);
            int pos = urlString.lastIndexOf(33);
            String jarFileName = urlString.substring(9, pos);
            return JarFileUtil.create(new File(jarFileName));
        }
    }

    private class FileSystemStrategy
    implements Strategy {
        private FileSystemStrategy() {
        }

        public void registerAll(Class referenceClass, URL url) {
            File rootDir = this.getRootDir(referenceClass, url);
            for (int i = 0; i < ComponentAutoRegister.this.getClassPatternSize(); ++i) {
                ClassTraversal.forEach(rootDir, ComponentAutoRegister.this.getClassPattern(i).getPackageName(), ComponentAutoRegister.this);
            }
        }

        protected File getRootDir(Class referenceClass, URL url) {
            String[] names = referenceClass.getName().split("\\.");
            File path = ResourceUtil.getFile(url);
            for (int i = 0; i < names.length; ++i) {
                path = path.getParentFile();
            }
            return path;
        }
    }

    private static interface Strategy {
        public void registerAll(Class var1, URL var2);
    }
}

