/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.BindingTypeDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.BindingTypeDefFactory;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

public abstract class AbstractAnnotationHandler
implements AnnotationHandler {
    protected static final String COMPONENT = "COMPONENT";
    protected static final String NAME = "name";
    protected static final String INSTANCE = "instance";
    protected static final String AUTO_BINDING = "autoBinding";
    protected static final String BINDING_SUFFIX = "_BINDING";
    protected static final String BINDING_TYPE = "bindingType";
    protected static final String VALUE = "value";
    protected static final String ASPECT = "ASPECT";
    protected static final String INIT_METHOD = "INIT_METHOD";
    protected static final String INTERCEPTOR = "interceptor";
    protected static final String POINTCUT = "pointcut";

    public ComponentDef createComponentDef(String className, InstanceDef instanceDef) {
        return this.createComponentDef(ClassUtil.forName(className), instanceDef);
    }

    public void appendDI(ComponentDef componentDef) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentDef.getComponentClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDef propDef;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (!pd.hasWriteMethod() || (propDef = this.createPropertyDef(beanDesc, pd)) == null) continue;
            componentDef.addPropertyDef(propDef);
        }
    }

    protected ComponentDef createComponentDefInternal(Class componentClass, InstanceDef instanceDef) {
        ComponentDefImpl componentDef = new ComponentDefImpl(componentClass);
        if (instanceDef != null) {
            componentDef.setInstanceDef(instanceDef);
        }
        return componentDef;
    }

    protected PropertyDef createPropertyDef(String propertyName, String expression, String bindingTypeName) {
        PropertyDefImpl propertyDef = new PropertyDefImpl(propertyName);
        if (!StringUtil.isEmpty(bindingTypeName)) {
            BindingTypeDef bindingTypeDef = BindingTypeDefFactory.getBindingTypeDef(bindingTypeName);
            propertyDef.setBindingTypeDef(bindingTypeDef);
        }
        if (!StringUtil.isEmpty(expression)) {
            propertyDef.setExpression(expression);
        }
        return propertyDef;
    }

    protected boolean isInitMethodRegisterable(ComponentDef cd, String methodName) {
        if (StringUtil.isEmpty(methodName)) {
            return false;
        }
        for (int i = 0; i < cd.getInitMethodDefSize(); ++i) {
            InitMethodDef other = cd.getInitMethodDef(i);
            if (!methodName.equals(other.getMethodName()) || other.getArgDefSize() != 0) continue;
            return false;
        }
        return true;
    }

    public abstract /* synthetic */ PropertyDef createPropertyDef(BeanDesc var1, PropertyDesc var2);

    public abstract /* synthetic */ void appendInitMethod(ComponentDef var1);

    public abstract /* synthetic */ void appendAspect(ComponentDef var1);

    public abstract /* synthetic */ ComponentDef createComponentDef(Class var1, InstanceDef var2);
}

