/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Barrier;
import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import EDU.oswego.cs.dl.util.concurrent.WaiterPreferenceSemaphore;

public class Rendezvous
implements Barrier {
    protected final int parties_;
    protected boolean broken_ = false;
    protected int entries_ = 0;
    protected long departures_ = 0L;
    protected final Semaphore entryGate_;
    protected final Object[] slots_;
    protected RendezvousFunction rendezvousFunction_;

    public Rendezvous(int n) {
        this(n, new Rotator());
    }

    public Rendezvous(int n, RendezvousFunction rendezvousFunction) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties_ = n;
        this.rendezvousFunction_ = rendezvousFunction;
        this.entryGate_ = new WaiterPreferenceSemaphore(n);
        this.slots_ = new Object[n];
    }

    public synchronized RendezvousFunction setRendezvousFunction(RendezvousFunction rendezvousFunction) {
        RendezvousFunction rendezvousFunction2 = this.rendezvousFunction_;
        this.rendezvousFunction_ = rendezvousFunction;
        return rendezvousFunction2;
    }

    public int parties() {
        return this.parties_;
    }

    public synchronized boolean broken() {
        return this.broken_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        while (true) {
            Rendezvous rendezvous = this;
            synchronized (rendezvous) {
                if (this.entries_ == 0) {
                    this.broken_ = false;
                    return;
                }
                this.notifyAll();
            }
            Thread.yield();
        }
    }

    public Object rendezvous(Object object) throws InterruptedException, BrokenBarrierException {
        return this.doRendezvous(object, false, 0L);
    }

    public Object attemptRendezvous(Object object, long l) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doRendezvous(object, true, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doRendezvous(Object var1_1, boolean var2_2, long var3_3) throws InterruptedException, TimeoutException, BrokenBarrierException {
        if (var2_2) {
            var5_4 = System.currentTimeMillis();
            if (!this.entryGate_.attempt(var3_3)) {
                throw new TimeoutException(var3_3);
            }
        } else {
            var5_4 = 0L;
            this.entryGate_.acquire();
        }
        var7_5 = this;
        synchronized (var7_5) {
            block20: {
                var8_6 = null;
                var9_7 = this.entries_++;
                this.slots_[var9_7] = var1_1;
                if (this.entries_ == this.parties_) {
                    block19: {
                        this.departures_ = this.entries_;
                        this.notifyAll();
                        try {
                            if (this.broken_) break block19;
                            if (this.rendezvousFunction_ != null) {
                                this.rendezvousFunction_.rendezvousFunction(this.slots_);
                            }
                        }
                        catch (RuntimeException var10_8) {
                            this.broken_ = true;
                        }
                    }
                }
                ** GOTO lbl52
                finally {
                    var8_6 = this.slots_[var9_7];
                    if (--this.departures_ > 0L) break block20;
                    var10_10 = 0;
                    if (true) ** GOTO lbl59
                }
lbl-1000:
                // 1 sources

                {
                    var10_9 = 0L;
                    if (var2_2 && (var10_9 = var3_3 - (System.currentTimeMillis() - var5_4)) <= 0L) {
                        this.broken_ = true;
                        this.departures_ = this.entries_;
                        this.notifyAll();
                        throw new TimeoutException(var3_3);
                    }
                    try {
                        this.wait(var10_9);
                    }
                    catch (InterruptedException var12_11) {
                        if (!this.broken_ && this.departures_ <= 0L) {
                            this.broken_ = true;
                            this.departures_ = this.entries_;
                            this.notifyAll();
                            throw var12_11;
                        }
                        Thread.currentThread().interrupt();
                    }
lbl52:
                    // 2 sources

                    if (!this.broken_) continue;
                    ** while (this.departures_ < 1L)
                }
lbl55:
                // 1 sources

                do {
                    this.slots_[var10_10] = null;
                    ++var10_10;
lbl59:
                    // 2 sources

                } while (var10_10 < this.slots_.length);
                this.entryGate_.release(this.entries_);
                this.entries_ = 0;
            }
            if (this.broken_) {
                throw new BrokenBarrierException(var9_7);
            }
            return var8_6;
        }
    }

    public static class Rotator
    implements RendezvousFunction {
        public void rendezvousFunction(Object[] objectArray) {
            int n = objectArray.length - 1;
            Object object = objectArray[0];
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = objectArray[n2 + 1];
                ++n2;
            }
            objectArray[n] = object;
        }
    }

    public static interface RendezvousFunction {
        public void rendezvousFunction(Object[] var1);
    }
}

