/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.hibernate3.dao.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.seasar.hibernate3.S2SessionFactory;
import org.seasar.hibernate3.dao.criteria.EqCriteriaCommand;
import org.seasar.hibernate3.dao.criteria.FirstResultCriteriaCommand;
import org.seasar.hibernate3.dao.criteria.GeCriteriaCommand;
import org.seasar.hibernate3.dao.criteria.GtCriteriaCommand;
import org.seasar.hibernate3.dao.criteria.InCriteriaCommand;
import org.seasar.hibernate3.dao.criteria.LeCriteriaCommand;
import org.seasar.hibernate3.dao.criteria.LikeCriteriaCommand;
import org.seasar.hibernate3.dao.criteria.LtCriteriaCommand;
import org.seasar.hibernate3.dao.criteria.MaxResultsCriteriaCommand;
import org.seasar.hibernate3.dao.criteria.OrderByCriteriaCommand;
import org.seasar.hibernate3.dao.impl.AbstractQueryHibernateCommand;
import org.seasar.hibernate3.dao.impl.ArgsMetaData;
import org.seasar.hibernate3.dao.impl.Argument;

public abstract class AbstractAutoQueryCommand
extends AbstractQueryHibernateCommand {
    private String[] eagerFields_;
    protected List criteriaCommandList_ = new ArrayList();

    public AbstractAutoQueryCommand(S2SessionFactory s2sessionFactory, Class beanClass, Method method) {
        super(s2sessionFactory, beanClass, method);
    }

    public Object execute(Object[] args) {
        List ret = null;
        Criteria criteria = this.getArgsCriteria(this.getSession(), args);
        criteria = this.setEagerFetch(criteria);
        ret = criteria.list();
        return this.getReturnObject(this.getMethod(), ret);
    }

    protected abstract Criteria getArgsCriteria(Session var1, Object[] var2);

    private Criteria setEagerFetch(Criteria criteria) {
        if (this.eagerFields_ != null) {
            int i = 0;
            while (i < this.eagerFields_.length) {
                criteria.setFetchMode(this.eagerFields_[i], FetchMode.JOIN);
                ++i;
            }
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        }
        return criteria;
    }

    public void setEagerFields(String[] eagerFields) {
        this.eagerFields_ = eagerFields;
    }

    public void buildCriterionList() {
        ArgsMetaData argsMeta = this.getArgsMeta();
        int i = 0;
        while (i < argsMeta.getArgsCount()) {
            Argument args = argsMeta.getArgument(i);
            String fieldName = args.getFieldName();
            String expression = args.getExpression();
            String dtoFieldName = args.getDtoFieldName();
            if (expression.equals("")) {
                if (fieldName.equals("orderBy")) {
                    this.criteriaCommandList_.add(new OrderByCriteriaCommand(fieldName, dtoFieldName));
                } else if (fieldName.equals("firstResult")) {
                    this.criteriaCommandList_.add(new FirstResultCriteriaCommand(fieldName, dtoFieldName));
                } else if (fieldName.equals("maxResults")) {
                    this.criteriaCommandList_.add(new MaxResultsCriteriaCommand(fieldName, dtoFieldName));
                } else {
                    this.criteriaCommandList_.add(new EqCriteriaCommand(fieldName, dtoFieldName));
                }
            } else if (expression.equals("=")) {
                this.criteriaCommandList_.add(new EqCriteriaCommand(fieldName, dtoFieldName));
            } else if (expression.equals(">")) {
                this.criteriaCommandList_.add(new GtCriteriaCommand(fieldName, dtoFieldName));
            } else if (expression.equals(">=")) {
                this.criteriaCommandList_.add(new GeCriteriaCommand(fieldName, dtoFieldName));
            } else if (expression.equals("<")) {
                this.criteriaCommandList_.add(new LtCriteriaCommand(fieldName, dtoFieldName));
            } else if (expression.equals("<=")) {
                this.criteriaCommandList_.add(new LeCriteriaCommand(fieldName, dtoFieldName));
            } else if (expression.equals("like")) {
                this.criteriaCommandList_.add(new LikeCriteriaCommand(fieldName, dtoFieldName));
            } else if (expression.equals("in")) {
                this.criteriaCommandList_.add(new InCriteriaCommand(fieldName, dtoFieldName));
            }
            ++i;
        }
    }
}

